/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.clients.admin.AbortTransactionSpec;
import org.apache.kafka.clients.admin.internals.AbortTransactionHandler;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.message.WriteTxnMarkersResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbortTransactionHandlerTest {
    private final LogContext logContext = new LogContext();
    private final TopicPartition topicPartition = new TopicPartition("foo", 5);
    private final AbortTransactionSpec abortSpec = new AbortTransactionSpec(this.topicPartition, 12345L, 15, 4321);
    private final Node node = new Node(1, "host", 1234);

    @Test
    public void testInvalidBuildRequestCall() {
        AbortTransactionHandler handler = new AbortTransactionHandler(this.abortSpec, this.logContext);
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.buildRequest(1, Collections.emptySet()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.buildRequest(1, Set.of(new TopicPartition("foo", 1))));
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.buildRequest(1, Set.of(this.topicPartition, new TopicPartition("foo", 1))));
    }

    @Test
    public void testValidBuildRequestCall() {
        AbortTransactionHandler handler = new AbortTransactionHandler(this.abortSpec, this.logContext);
        WriteTxnMarkersRequest.Builder request = handler.buildBatchedRequest(1, Collections.singleton(this.topicPartition));
        Assertions.assertEquals((int)1, (int)request.data.markers().size());
        WriteTxnMarkersRequestData.WritableTxnMarker markerRequest = (WriteTxnMarkersRequestData.WritableTxnMarker)request.data.markers().get(0);
        Assertions.assertEquals((long)this.abortSpec.producerId(), (long)markerRequest.producerId());
        Assertions.assertEquals((short)this.abortSpec.producerEpoch(), (short)markerRequest.producerEpoch());
        Assertions.assertEquals((int)this.abortSpec.coordinatorEpoch(), (int)markerRequest.coordinatorEpoch());
        Assertions.assertEquals((int)1, (int)markerRequest.topics().size());
        WriteTxnMarkersRequestData.WritableTxnMarkerTopic topicRequest = (WriteTxnMarkersRequestData.WritableTxnMarkerTopic)markerRequest.topics().get(0);
        Assertions.assertEquals((Object)this.abortSpec.topicPartition().topic(), (Object)topicRequest.name());
        Assertions.assertEquals(Collections.singletonList(this.abortSpec.topicPartition().partition()), (Object)topicRequest.partitionIndexes());
    }

    @Test
    public void testInvalidHandleResponseCall() {
        AbortTransactionHandler handler = new AbortTransactionHandler(this.abortSpec, this.logContext);
        WriteTxnMarkersResponseData response = new WriteTxnMarkersResponseData();
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.handleResponse(this.node, Collections.emptySet(), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.handleResponse(this.node, Set.of(new TopicPartition("foo", 1)), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.handleResponse(this.node, Set.of(this.topicPartition, new TopicPartition("foo", 1)), (AbstractResponse)new WriteTxnMarkersResponse(response)));
    }

    @Test
    public void testInvalidResponse() {
        AbortTransactionHandler handler = new AbortTransactionHandler(this.abortSpec, this.logContext);
        WriteTxnMarkersResponseData response = new WriteTxnMarkersResponseData();
        this.assertFailed(KafkaException.class, this.topicPartition, (AdminApiHandler.ApiResult<TopicPartition, Void>)handler.handleResponse(this.node, Collections.singleton(this.topicPartition), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        WriteTxnMarkersResponseData.WritableTxnMarkerResult markerResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerResult();
        response.markers().add(markerResponse);
        this.assertFailed(KafkaException.class, this.topicPartition, (AdminApiHandler.ApiResult<TopicPartition, Void>)handler.handleResponse(this.node, Collections.singleton(this.topicPartition), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        markerResponse.setProducerId(this.abortSpec.producerId());
        this.assertFailed(KafkaException.class, this.topicPartition, (AdminApiHandler.ApiResult<TopicPartition, Void>)handler.handleResponse(this.node, Collections.singleton(this.topicPartition), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topicResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult();
        markerResponse.topics().add(topicResponse);
        this.assertFailed(KafkaException.class, this.topicPartition, (AdminApiHandler.ApiResult<TopicPartition, Void>)handler.handleResponse(this.node, Collections.singleton(this.topicPartition), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        topicResponse.setName(this.abortSpec.topicPartition().topic());
        this.assertFailed(KafkaException.class, this.topicPartition, (AdminApiHandler.ApiResult<TopicPartition, Void>)handler.handleResponse(this.node, Collections.singleton(this.topicPartition), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult();
        topicResponse.partitions().add(partitionResponse);
        this.assertFailed(KafkaException.class, this.topicPartition, (AdminApiHandler.ApiResult<TopicPartition, Void>)handler.handleResponse(this.node, Collections.singleton(this.topicPartition), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        partitionResponse.setPartitionIndex(this.abortSpec.topicPartition().partition());
        topicResponse.setName(this.abortSpec.topicPartition().topic() + "random");
        this.assertFailed(KafkaException.class, this.topicPartition, (AdminApiHandler.ApiResult<TopicPartition, Void>)handler.handleResponse(this.node, Collections.singleton(this.topicPartition), (AbstractResponse)new WriteTxnMarkersResponse(response)));
        topicResponse.setName(this.abortSpec.topicPartition().topic());
        markerResponse.setProducerId(this.abortSpec.producerId() + 1L);
        this.assertFailed(KafkaException.class, this.topicPartition, (AdminApiHandler.ApiResult<TopicPartition, Void>)handler.handleResponse(this.node, Collections.singleton(this.topicPartition), (AbstractResponse)new WriteTxnMarkersResponse(response)));
    }

    @Test
    public void testSuccessfulResponse() {
        this.assertCompleted(this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.NONE));
    }

    @Test
    public void testRetriableErrors() {
        this.assertUnmapped(this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.NOT_LEADER_OR_FOLLOWER));
        this.assertUnmapped(this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.UNKNOWN_TOPIC_OR_PARTITION));
        this.assertUnmapped(this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.REPLICA_NOT_AVAILABLE));
        this.assertUnmapped(this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.BROKER_NOT_AVAILABLE));
    }

    @Test
    public void testFatalErrors() {
        this.assertFailed(ClusterAuthorizationException.class, this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.CLUSTER_AUTHORIZATION_FAILED));
        this.assertFailed(InvalidProducerEpochException.class, this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.INVALID_PRODUCER_EPOCH));
        this.assertFailed(TransactionCoordinatorFencedException.class, this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.TRANSACTION_COORDINATOR_FENCED));
        this.assertFailed(UnknownServerException.class, this.abortSpec.topicPartition(), this.handleWithError(this.abortSpec, Errors.UNKNOWN_SERVER_ERROR));
    }

    private AdminApiHandler.ApiResult<TopicPartition, Void> handleWithError(AbortTransactionSpec abortSpec, Errors error) {
        AbortTransactionHandler handler = new AbortTransactionHandler(abortSpec, this.logContext);
        WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult().setPartitionIndex(abortSpec.topicPartition().partition()).setErrorCode(error.code());
        WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topicResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult().setName(abortSpec.topicPartition().topic());
        topicResponse.partitions().add(partitionResponse);
        WriteTxnMarkersResponseData.WritableTxnMarkerResult markerResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerResult().setProducerId(abortSpec.producerId());
        markerResponse.topics().add(topicResponse);
        WriteTxnMarkersResponseData response = new WriteTxnMarkersResponseData();
        response.markers().add(markerResponse);
        return handler.handleResponse(this.node, Collections.singleton(abortSpec.topicPartition()), (AbstractResponse)new WriteTxnMarkersResponse(response));
    }

    private void assertUnmapped(TopicPartition topicPartition, AdminApiHandler.ApiResult<TopicPartition, Void> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(topicPartition), (Object)result.unmappedKeys);
    }

    private void assertCompleted(TopicPartition topicPartition, AdminApiHandler.ApiResult<TopicPartition, Void> result) {
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(topicPartition), result.completedKeys.keySet());
        Assertions.assertNull(result.completedKeys.get(topicPartition));
    }

    private void assertFailed(Class<? extends Throwable> expectedExceptionType, TopicPartition topicPartition, AdminApiHandler.ApiResult<TopicPartition, Void> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(topicPartition), result.failedKeys.keySet());
        Assertions.assertInstanceOf(expectedExceptionType, result.failedKeys.get(topicPartition));
    }
}

