/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoundRobinAssignorTest {
    private final RoundRobinAssignor assignor = new RoundRobinAssignor();
    private final String topic = "topic";
    private final String consumerId = "consumer";
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";

    @Test
    public void testOneConsumerNoTopic() {
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer", new ConsumerPartitionAssignor.Subscription(Collections.emptyList())));
        Assertions.assertEquals(Collections.singleton("consumer"), assignment.keySet());
        Assertions.assertTrue((boolean)((List)assignment.get("consumer")).isEmpty());
    }

    @Test
    public void testOneConsumerNonexistentTopic() {
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer", new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic"))));
        Assertions.assertEquals(Collections.singleton("consumer"), assignment.keySet());
        Assertions.assertTrue((boolean)((List)assignment.get("consumer")).isEmpty());
    }

    @Test
    public void testOneConsumerOneTopic() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic", 3);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer", new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic"))));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic", 0), RoundRobinAssignorTest.tp("topic", 1), RoundRobinAssignorTest.tp("topic", 2)), assignment.get("consumer"));
    }

    @Test
    public void testOnlyAssignsPartitionsFromSubscribedTopics() {
        String otherTopic = "other";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic", 3);
        partitionsPerTopic.put(otherTopic, 3);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer", new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic"))));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic", 0), RoundRobinAssignorTest.tp("topic", 1), RoundRobinAssignorTest.tp("topic", 2)), assignment.get("consumer"));
    }

    @Test
    public void testOneConsumerMultipleTopics() {
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(1, 2);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer", new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic1", "topic2"))));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 0), RoundRobinAssignorTest.tp("topic2", 0), RoundRobinAssignorTest.tp("topic2", 1)), assignment.get("consumer"));
    }

    @Test
    public void testTwoConsumersOneTopicOnePartition() {
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic", 1);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put(consumer1, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic")));
        consumers.put(consumer2, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic")));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic", 0)), assignment.get(consumer1));
        Assertions.assertEquals(Collections.emptyList(), assignment.get(consumer2));
    }

    @Test
    public void testTwoConsumersOneTopicTwoPartitions() {
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic", 2);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put(consumer1, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic")));
        consumers.put(consumer2, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic")));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic", 0)), assignment.get(consumer1));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic", 1)), assignment.get(consumer2));
    }

    @Test
    public void testMultipleConsumersMixedTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 2);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put(consumer1, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics(topic1)));
        consumers.put(consumer2, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics(topic1, topic2)));
        consumers.put(consumer3, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics(topic1)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp(topic1, 0)), assignment.get(consumer1));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp(topic1, 1), RoundRobinAssignorTest.tp(topic2, 0), RoundRobinAssignorTest.tp(topic2, 1)), assignment.get(consumer2));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp(topic1, 2)), assignment.get(consumer3));
    }

    @Test
    public void testTwoDynamicConsumersTwoTopicsSixPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put(consumer1, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics(topic1, topic2)));
        consumers.put(consumer2, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics(topic1, topic2)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp(topic1, 0), RoundRobinAssignorTest.tp(topic1, 2), RoundRobinAssignorTest.tp(topic2, 1)), assignment.get(consumer1));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp(topic1, 1), RoundRobinAssignorTest.tp(topic2, 0), RoundRobinAssignorTest.tp(topic2, 2)), assignment.get(consumer2));
    }

    @Test
    public void testTwoStaticConsumersTwoTopicsSixPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer-b";
        String instance1 = "instance1";
        String consumer2 = "consumer-a";
        String instance2 = "instance2";
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        ConsumerPartitionAssignor.Subscription consumer1Subscription = new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics(topic1, topic2), null);
        consumer1Subscription.setGroupInstanceId(Optional.of(instance1));
        consumers.put(consumer1, consumer1Subscription);
        ConsumerPartitionAssignor.Subscription consumer2Subscription = new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics(topic1, topic2), null);
        consumer2Subscription.setGroupInstanceId(Optional.of(instance2));
        consumers.put(consumer2, consumer2Subscription);
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp(topic1, 0), RoundRobinAssignorTest.tp(topic1, 2), RoundRobinAssignorTest.tp(topic2, 1)), assignment.get(consumer1));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp(topic1, 1), RoundRobinAssignorTest.tp(topic2, 0), RoundRobinAssignorTest.tp(topic2, 2)), assignment.get(consumer2));
    }

    @Test
    public void testOneStaticConsumerAndOneDynamicConsumerTwoTopicsSixPartitions() {
        String consumer1 = "consumer-b";
        String instance1 = "instance1";
        String consumer2 = "consumer-a";
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        ConsumerPartitionAssignor.Subscription consumer1Subscription = new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic1", "topic2"), null);
        consumer1Subscription.setGroupInstanceId(Optional.of(instance1));
        consumers.put(consumer1, consumer1Subscription);
        consumers.put(consumer2, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic1", "topic2")));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 0), RoundRobinAssignorTest.tp("topic1", 2), RoundRobinAssignorTest.tp("topic2", 1)), assignment.get(consumer1));
        Assertions.assertEquals(RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 1), RoundRobinAssignorTest.tp("topic2", 0), RoundRobinAssignorTest.tp("topic2", 2)), assignment.get(consumer2));
    }

    @Test
    public void testStaticMemberRoundRobinAssignmentPersistent() {
        String consumer1 = "consumer1";
        String instance1 = "instance1";
        String consumer2 = "consumer2";
        String instance2 = "instance2";
        String consumer3 = "consumer3";
        String instance3 = "instance3";
        ArrayList<AbstractPartitionAssignor.MemberInfo> staticMemberInfos = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo(consumer1, Optional.of(instance1)));
        staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo(consumer2, Optional.of(instance2)));
        staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo(consumer3, Optional.of(instance3)));
        String consumer4 = "consumer4";
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        for (AbstractPartitionAssignor.MemberInfo m : staticMemberInfos) {
            ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic1", "topic2"), null);
            subscription.setGroupInstanceId(m.groupInstanceId);
            consumers.put(m.memberId, subscription);
        }
        consumers.put(consumer4, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic1", "topic2")));
        HashMap<String, List<TopicPartition>> expectedAssignment = new HashMap<String, List<TopicPartition>>();
        expectedAssignment.put(consumer1, RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 0), RoundRobinAssignorTest.tp("topic2", 1)));
        expectedAssignment.put(consumer2, RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 1), RoundRobinAssignorTest.tp("topic2", 2)));
        expectedAssignment.put(consumer3, RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 2)));
        expectedAssignment.put(consumer4, RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic2", 0)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assertions.assertEquals(expectedAssignment, (Object)assignment);
        consumers.remove(consumer4);
        String consumer5 = "consumer5";
        consumers.put(consumer5, new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic1", "topic2")));
        expectedAssignment.remove(consumer4);
        expectedAssignment.put(consumer5, RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic2", 0)));
        assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assertions.assertEquals(expectedAssignment, (Object)assignment);
    }

    @Test
    public void testStaticMemberRoundRobinAssignmentPersistentAfterMemberIdChanges() {
        String consumer1 = "consumer1";
        String instance1 = "instance1";
        String consumer2 = "consumer2";
        String instance2 = "instance2";
        String consumer3 = "consumer3";
        String instance3 = "instance3";
        HashMap<String, String> memberIdToInstanceId = new HashMap<String, String>();
        memberIdToInstanceId.put(consumer1, instance1);
        memberIdToInstanceId.put(consumer2, instance2);
        memberIdToInstanceId.put(consumer3, instance3);
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(5, 5);
        HashMap<String, List<TopicPartition>> expectedInstanceAssignment = new HashMap<String, List<TopicPartition>>();
        expectedInstanceAssignment.put(instance1, RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 0), RoundRobinAssignorTest.tp("topic1", 3), RoundRobinAssignorTest.tp("topic2", 1), RoundRobinAssignorTest.tp("topic2", 4)));
        expectedInstanceAssignment.put(instance2, RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 1), RoundRobinAssignorTest.tp("topic1", 4), RoundRobinAssignorTest.tp("topic2", 2)));
        expectedInstanceAssignment.put(instance3, RoundRobinAssignorTest.partitions(RoundRobinAssignorTest.tp("topic1", 2), RoundRobinAssignorTest.tp("topic2", 0), RoundRobinAssignorTest.tp("topic2", 3)));
        ArrayList<AbstractPartitionAssignor.MemberInfo> staticMemberInfos = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        for (Map.Entry entry : memberIdToInstanceId.entrySet()) {
            staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo((String)entry.getKey(), Optional.of((String)entry.getValue())));
        }
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        for (AbstractPartitionAssignor.MemberInfo m : staticMemberInfos) {
            ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(RoundRobinAssignorTest.topics("topic1", "topic2"), null);
            subscription.setGroupInstanceId(m.groupInstanceId);
            consumers.put(m.memberId, subscription);
        }
        Map<String, List<TopicPartition>> map = RoundRobinAssignorTest.checkStaticAssignment((AbstractPartitionAssignor)this.assignor, partitionsPerTopic, consumers);
        Assertions.assertEquals(expectedInstanceAssignment, map);
        memberIdToInstanceId.clear();
        String consumer4 = "consumer4";
        String consumer5 = "consumer5";
        consumers.put(consumer4, (ConsumerPartitionAssignor.Subscription)consumers.get(consumer3));
        consumers.remove(consumer3);
        consumers.put(consumer5, (ConsumerPartitionAssignor.Subscription)consumers.get(consumer2));
        consumers.remove(consumer2);
        Map<String, List<TopicPartition>> newStaticAssignment = RoundRobinAssignorTest.checkStaticAssignment((AbstractPartitionAssignor)this.assignor, partitionsPerTopic, consumers);
        Assertions.assertEquals(map, newStaticAssignment);
    }

    private static List<String> topics(String ... topics) {
        return Arrays.asList(topics);
    }

    private static List<TopicPartition> partitions(TopicPartition ... partitions) {
        return Arrays.asList(partitions);
    }

    private static TopicPartition tp(String topic, int partition) {
        return new TopicPartition(topic, partition);
    }

    private Map<String, Integer> setupPartitionsPerTopicWithTwoTopics(int numberOfPartitions1, int numberOfPartitions2) {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic1", numberOfPartitions1);
        partitionsPerTopic.put("topic2", numberOfPartitions2);
        return partitionsPerTopic;
    }

    private static Map<String, List<TopicPartition>> checkStaticAssignment(AbstractPartitionAssignor assignor, Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> consumers) {
        Map assignmentByMemberId = assignor.assign(partitionsPerTopic, consumers);
        return consumers.entrySet().stream().filter(e -> ((ConsumerPartitionAssignor.Subscription)e.getValue()).groupInstanceId().isPresent()).collect(Collectors.toMap(e -> (String)((ConsumerPartitionAssignor.Subscription)e.getValue()).groupInstanceId().get(), e -> (List)assignmentByMemberId.get(e.getKey())));
    }
}

