/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.internals.AbstractMembershipManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.CounterConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.Utils;
import org.apache.kafka.clients.consumer.internals.metrics.ShareRebalanceMetricsManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShareMembershipManagerTest {
    private static final String GROUP_ID = "test-group";
    private static final String RACK_ID = null;
    private static final int MEMBER_EPOCH = 1;
    private final LogContext logContext = new LogContext();
    private SubscriptionState subscriptionState;
    private ConsumerMetadata metadata;
    private Time time;
    private ShareRebalanceMetricsManager rebalanceMetricsManager;
    private Metrics metrics;

    @BeforeEach
    public void setup() {
        this.metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
        this.subscriptionState = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        this.time = new MockTime(0L);
        this.metrics = new Metrics(this.time);
        this.rebalanceMetricsManager = new ShareRebalanceMetricsManager(this.metrics);
    }

    @AfterEach
    public void tearDown() {
    }

    private ShareMembershipManager createMembershipManager() {
        ShareMembershipManager manager = (ShareMembershipManager)Mockito.spy((Object)new ShareMembershipManager(this.logContext, GROUP_ID, RACK_ID, this.subscriptionState, this.metadata, this.time, this.rebalanceMetricsManager));
        this.assertMemberIdIsGenerated(manager.memberId());
        return manager;
    }

    private ShareMembershipManager createMembershipManagerJoiningGroup() {
        ShareMembershipManager manager = (ShareMembershipManager)Mockito.spy((Object)new ShareMembershipManager(this.logContext, GROUP_ID, RACK_ID, this.subscriptionState, this.metadata, this.time, this.rebalanceMetricsManager));
        this.assertMemberIdIsGenerated(manager.memberId());
        manager.transitionToJoining();
        return manager;
    }

    @Test
    public void testMembershipManagerRegistersForClusterMetadataUpdatesOnFirstJoin() {
        ShareMembershipManager manager = new ShareMembershipManager(this.logContext, GROUP_ID, RACK_ID, this.subscriptionState, this.metadata, this.time, this.rebalanceMetricsManager);
        manager.transitionToJoining();
        Mockito.clearInvocations((Object[])new ConsumerMetadata[]{this.metadata});
        this.receiveEmptyAssignment(manager);
        this.mockLeaveGroup();
        manager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)manager.state());
        manager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)manager.state());
        manager.transitionToJoining();
    }

    @Test
    public void testReconcilingWhenReceivingAssignmentFoundInMetadata() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testTransitionToReconcilingIfEmptyAssignmentReceived() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        ShareGroupHeartbeatResponse responseWithoutAssignment = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(responseWithoutAssignment);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        ShareGroupHeartbeatResponse responseWithAssignment = this.createShareGroupHeartbeatResponse(this.createAssignment(true), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(responseWithAssignment);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
    }

    @Test
    public void testMemberIdAndEpochResetOnFencedMembers() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
        this.mockMemberHasAutoAssignedPartition();
        membershipManager.transitionToFenced();
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testTransitionToFatal() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
    }

    @Test
    public void testTransitionToFailedWhenTryingToJoin() {
        ShareMembershipManager membershipManager = new ShareMembershipManager(this.logContext, GROUP_ID, RACK_ID, this.subscriptionState, this.metadata, this.time, this.rebalanceMetricsManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.transitionToJoining();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFencingWhenStateIsStable() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testListenersGetNotifiedOnTransitionsToFatal() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        this.mockStableMember(membershipManager);
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(1), membershipManager.memberId);
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.empty(), membershipManager.memberId);
    }

    @Test
    public void testListenersGetNotifiedOnTransitionsToLeavingGroup() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        this.mockStableMember(membershipManager);
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(1), membershipManager.memberId);
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.empty(), membershipManager.memberId);
    }

    @Test
    public void testListenersGetNotifiedOfMemberEpochUpdatesOnlyIfItChanges() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        int epoch = 5;
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(membershipManager.memberId()).setMemberEpoch(epoch)));
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(epoch), membershipManager.memberId);
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(membershipManager.memberId()).setMemberEpoch(epoch)));
        ((MemberStateListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onMemberEpochUpdated((Optional)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    private void mockStableMember(ShareMembershipManager membershipManager) {
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        membershipManager.poll(this.time.milliseconds());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testFencingWhenStateIsReconciling() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testFencingWhenStateIsLeaving() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveOperation = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state(), (String)"Member should transition from LEAVING to UNSUBSCRIBED when getting fenced (it does not need to send leave request if fenced");
        Assertions.assertTrue((boolean)leaveOperation.isDone(), (String)"Fenced member should complete the ongoing leave operation");
    }

    private void assertTransitionToUnsubscribeOnHBSentAndWaitForResponseToCompleteLeave(ShareMembershipManager membershipManager, CompletableFuture<Void> sendLeave) {
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertFalse((boolean)sendLeave.isDone(), (String)"Send leave operation should not complete until a response is received");
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment(), membershipManager.memberId()));
        this.assertSendLeaveCompleted(membershipManager, sendLeave);
    }

    @Test
    public void testLeaveGroupEpoch() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testSameAssignmentReconciledAgainWhenFenced() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topic1 = Uuid.randomUuid();
        ShareGroupHeartbeatResponseData.Assignment assignment1 = new ShareGroupHeartbeatResponseData.Assignment();
        ShareGroupHeartbeatResponseData.Assignment assignment2 = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Arrays.asList(0, 1, 2))));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topic1, "topic1"));
        Assertions.assertEquals(this.toTopicIdPartitionMap(assignment1), (Object)membershipManager.currentAssignment().partitions);
        String memberId = membershipManager.memberId();
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(assignment2, memberId));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        CompletableFuture<Object> commitResult = new CompletableFuture<Object>();
        membershipManager.poll(this.time.milliseconds());
        membershipManager.transitionToFenced();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        Assertions.assertTrue((boolean)this.subscriptionState.assignedPartitions().isEmpty());
        commitResult.complete(null);
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        Assertions.assertTrue((boolean)this.subscriptionState.assignedPartitions().isEmpty());
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(assignment1, memberId));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.poll(this.time.milliseconds());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals(this.toTopicIdPartitionMap(assignment1), (Object)membershipManager.currentAssignment().partitions);
    }

    @Test
    public void testSameAssignmentReconciledAgainWithMissingTopic() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topic1 = Uuid.randomUuid();
        Uuid topic2 = Uuid.randomUuid();
        ShareGroupHeartbeatResponseData.Assignment assignment1 = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Collections.singletonList(0)), new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Collections.singletonList(0))));
        ShareGroupHeartbeatResponseData.Assignment assignment2 = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Arrays.asList(0, 1)), new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Collections.singletonList(0))));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topic1, "topic1"));
        String memberId = membershipManager.memberId();
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(assignment1, memberId));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, Collections.singletonList(new TopicIdPartition(topic1, new TopicPartition("topic1", 0))));
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new ShareMembershipManager[]{membershipManager});
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(assignment2, memberId));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(assignment1, memberId));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.poll(this.time.milliseconds());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singletonMap(topic1, Utils.mkSortedSet((Comparable[])new Integer[]{0})), (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertEquals(Set.of(topic2), (Object)membershipManager.topicsAwaitingReconciliation());
    }

    private Map<Uuid, SortedSet<Integer>> toTopicIdPartitionMap(ShareGroupHeartbeatResponseData.Assignment assignment) {
        HashMap<Uuid, SortedSet<Integer>> result = new HashMap<Uuid, SortedSet<Integer>>();
        for (ShareGroupHeartbeatResponseData.TopicPartitions topicPartitions : assignment.topicPartitions()) {
            result.put(topicPartitions.topicId(), new TreeSet(topicPartitions.partitions()));
        }
        return result;
    }

    @Test
    public void testDelayedMetadataUsedToCompleteAssignment() {
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        TopicIdPartition topicId1Partition0 = new TopicIdPartition(topicId1, new TopicPartition(topic1, 0));
        Uuid topicId2 = Uuid.randomUuid();
        String topic2 = "topic2";
        TopicIdPartition topicId2Partition0 = new TopicIdPartition(topicId2, new TopicPartition(topic2, 0));
        ShareMembershipManager membershipManager = this.mockMemberSuccessfullyReceivesAndAcksAssignment(topicId1, topic1, Collections.singletonList(0));
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.getTopicPartitions(Collections.singleton(topicId1Partition0)));
        Mockito.clearInvocations((Object[])new Object[]{membershipManager, this.subscriptionState});
        Map newAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId1, (Object)Utils.mkSortedSet((Comparable[])new Integer[]{0})), Utils.mkEntry((Object)topicId2, (Object)Utils.mkSortedSet((Comparable[])new Integer[]{0}))});
        this.receiveAssignment(newAssignment, membershipManager);
        membershipManager.poll(this.time.milliseconds());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.shouldHeartbeatNow());
        membershipManager.onHeartbeatRequestGenerated();
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(Collections.singleton(topicId2), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Mockito.clearInvocations((Object[])new ShareMembershipManager[]{membershipManager});
        Map fullTopicMetadata = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId1, (Object)topic1), Utils.mkEntry((Object)topicId2, (Object)topic2)});
        Mockito.when((Object)this.metadata.topicNames()).thenReturn((Object)fullTopicMetadata);
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, Arrays.asList(topicId1Partition0, topicId2Partition0));
    }

    @Test
    public void testLeaveGroupWhenStateIsStable() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testHeartbeatSuccessfulResponseWhenLeavingGroupCompletesLeave() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(this.createAssignment(true), membershipManager.memberId()));
        this.assertSendLeaveCompleted(membershipManager, leaveResult);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testHeartbeatFailedResponseWhenLeavingGroupCompletesLeave(boolean retriableResponseError) {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatFailure(retriableResponseError);
        this.assertSendLeaveCompleted(membershipManager, leaveResult);
    }

    private void assertSendLeaveCompleted(ShareMembershipManager membershipManager, CompletableFuture<Void> sendLeave) {
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state(), (String)"Member should remain UNSUBSCRIBED after receiving the response to the HB to leave");
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        Assertions.assertTrue((boolean)sendLeave.isDone(), (String)"Leave group result should complete when the response to the heartbeat request to leave is received.");
        Assertions.assertFalse((boolean)sendLeave.isCompletedExceptionally());
    }

    @ParameterizedTest
    @MethodSource(value={"notInGroupStates"})
    public void testIgnoreHeartbeatResponseWhenNotInGroup(MemberState state) {
        ShareMembershipManager membershipManager = this.createMembershipManager();
        Mockito.when((Object)membershipManager.state()).thenReturn((Object)state);
        ShareGroupHeartbeatResponseData responseData = (ShareGroupHeartbeatResponseData)Mockito.mock(ShareGroupHeartbeatResponseData.class);
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(responseData));
        Assertions.assertEquals((Object)state, (Object)membershipManager.state());
        ((ShareGroupHeartbeatResponseData)Mockito.verify((Object)responseData, (VerificationMode)Mockito.never())).memberId();
        ((ShareGroupHeartbeatResponseData)Mockito.verify((Object)responseData, (VerificationMode)Mockito.never())).memberEpoch();
        ((ShareGroupHeartbeatResponseData)Mockito.verify((Object)responseData, (VerificationMode)Mockito.never())).assignment();
    }

    @Test
    public void testLeaveGroupWhenStateIsReconciling() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(membershipManager);
    }

    @Test
    public void testIgnoreHeartbeatWhenLeavingGroup() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(this.createAssignment(true), membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().partitions.isEmpty());
        Assertions.assertFalse((boolean)leaveResult.isDone(), (String)"Leave group result should not complete until the heartbeat request to leave is sent out.");
    }

    @Test
    public void testLeaveGroupWhenMemberOwnsAssignment() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        List<TopicIdPartition> assignedPartitions = Arrays.asList(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), new TopicIdPartition(topicId, new TopicPartition(topicName, 1)));
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
        Assertions.assertEquals((int)1, (int)membershipManager.currentAssignment().partitions.size());
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(membershipManager);
    }

    @Test
    public void testFencedWhenAssignmentEmpty() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)false);
        membershipManager.transitionToFenced();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenMemberAlreadyLeaving() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertFalse((boolean)leaveResult1.isDone());
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        this.mockLeaveGroup();
        CompletableFuture leaveResult2 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).unsubscribe();
        Assertions.assertFalse((boolean)leaveResult2.isDone());
        this.assertTransitionToUnsubscribeOnHBSentAndWaitForResponseToCompleteLeave(membershipManager, leaveResult1);
        Assertions.assertTrue((boolean)leaveResult2.isDone());
        Assertions.assertFalse((boolean)leaveResult2.isCompletedExceptionally());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenMemberAlreadyLeft() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        this.assertTransitionToUnsubscribeOnHBSentAndWaitForResponseToCompleteLeave(membershipManager, leaveResult1);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        this.mockLeaveGroup();
        CompletableFuture leaveResult2 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertTrue((boolean)leaveResult2.isDone());
        Assertions.assertFalse((boolean)leaveResult2.isCompletedExceptionally());
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenMemberIsStale() {
        ShareMembershipManager membershipManager = this.mockStaleMember();
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertTrue((boolean)leaveResult1.isDone());
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
    }

    @Test
    public void testFatalFailureWhenStateIsUnjoined() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
    }

    @Test
    public void testFatalFailureWhenStateIsStable() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.testStateUpdateOnFatalFailure(membershipManager);
    }

    @Test
    public void testFatalFailureWhenStateIsLeaving() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFatalFailureWhenMemberAlreadyLeft() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testUpdateStateFailsOnResponsesWithErrors() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse unknownMemberResponse = this.createShareGroupHeartbeatResponseWithError(membershipManager.memberId());
        Assertions.assertThrows(IllegalArgumentException.class, () -> membershipManager.onHeartbeatSuccess(unknownMemberResponse));
    }

    @Test
    public void testNewAssignmentReplacesPreviousOneWaitingOnMetadata() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Collections.singletonList(0), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        Set<TopicPartition> expectedAssignment = Collections.singleton(new TopicPartition(topicName, 0));
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(expectedAssignment, expectedAssignment);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
    }

    @Test
    public void testNewEmptyAssignmentReplacesPreviousOneWaitingOnMetadata() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, Collections.emptyList());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testNewAssignmentNotInMetadataReplacesPreviousOneWaitingOnMetadata() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        this.receiveAssignment(topicId, Collections.singletonList(0), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Assertions.assertEquals((Object)topicId, membershipManager.topicsAwaitingReconciliation().iterator().next());
    }

    @Test
    public void testUnresolvedTargetAssignmentIsReconciledWhenMetadataReceived() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topicId = Uuid.randomUuid();
        this.receiveAssignment(topicId, Collections.singletonList(1), membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.poll(this.time.milliseconds());
        Set<TopicPartition> expectedAssignment = Collections.singleton(new TopicPartition(topicName, 1));
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(expectedAssignment, expectedAssignment);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
    }

    @Test
    public void testMemberKeepsUnresolvedAssignmentWaitingForMetadataUntilResolved() {
        Uuid topic1 = Uuid.randomUuid();
        String topic1Name = "topic1";
        Uuid topic2 = Uuid.randomUuid();
        ShareGroupHeartbeatResponseData.Assignment assignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Collections.singletonList(0)), new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Arrays.asList(1, 3))));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topic1, topic1Name));
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true, assignment);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Assertions.assertEquals(Collections.singleton(topic2), (Object)membershipManager.topicsAwaitingReconciliation());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.onHeartbeatSuccess(this.createShareGroupHeartbeatResponse(assignment, membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(Collections.singleton(topic2), (Object)membershipManager.topicsAwaitingReconciliation());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
    }

    @Test
    public void testReconcileNewPartitionsAssignedWhenNoPartitionOwned() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        List<TopicIdPartition> assignedPartitions = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
    }

    @Test
    public void testReconcileNewPartitionsAssignedWhenOtherPartitionsOwned() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        TopicIdPartition ownedPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(ownedPartition));
        this.receiveAssignment(topicId, Arrays.asList(0, 1, 2), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        ArrayList<TopicIdPartition> assignedPartitions = new ArrayList<TopicIdPartition>();
        assignedPartitions.add(ownedPartition);
        assignedPartitions.addAll(this.topicIdPartitions(topicId, topicName, 1, 2));
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
    }

    @Test
    public void testReconciliationSkippedWhenSameAssignmentReceived() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        List<TopicIdPartition> expectedAssignmentReconciled = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, expectedAssignmentReconciled);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new Object[]{this.subscriptionState, membershipManager});
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, expectedAssignmentReconciled);
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationCompleted();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((Object)1.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
    }

    @Test
    public void testReconcileNewPartitionsAssignedAndRevoked() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        TopicIdPartition ownedPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(ownedPartition));
        this.mockRevocation();
        this.receiveAssignment(topicId, Arrays.asList(1, 2), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        TreeSet<TopicPartition> expectedSet = new TreeSet<TopicPartition>((Comparator<TopicPartition>)AbstractMembershipManager.TOPIC_PARTITION_COMPARATOR);
        expectedSet.add(new TopicPartition(topicName, 1));
        expectedSet.add(new TopicPartition(topicName, 2));
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 1, 2), (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(expectedSet, expectedSet);
    }

    @Test
    public void testMetadataUpdatesReconcilesUnresolvedAssignments() {
        Uuid topicId = Uuid.randomUuid();
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(Arrays.asList(0, 1))));
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true, targetAssignment);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        String topicName = "topic1";
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId, topicName), true);
        membershipManager.poll(this.time.milliseconds());
        List<TopicIdPartition> expectedAssignmentReconciled = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, expectedAssignmentReconciled);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
    }

    @Test
    public void testMetadataUpdatesRequestsAnotherUpdateIfNeeded() {
        Uuid topicId = Uuid.randomUuid();
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(Arrays.asList(0, 1))));
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true, targetAssignment);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        membershipManager.poll(this.time.milliseconds());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)2))).requestUpdate(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRevokePartitionsUsesTopicNamesLocalCacheWhenMetadataNotAvailable() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).markPendingRevocation(Set.of());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        List<Integer> partitions = Arrays.asList(0, 1);
        Set assignedPartitions = partitions.stream().map(p -> new TopicPartition(topicName, p.intValue())).collect(Collectors.toSet());
        Map<Uuid, TreeSet<Integer>> assignedTopicIdPartitions = Collections.singletonMap(topicId, new TreeSet<Integer>(partitions));
        Assertions.assertEquals(assignedTopicIdPartitions, (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        this.mockAckSent(membershipManager);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(assignedPartitions);
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        this.mockRevocation();
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId, topicName), false);
        this.receiveAssignment(topicId, Collections.singletonList(1), membershipManager);
        membershipManager.poll(this.time.milliseconds());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.times((int)2))).markPendingRevocation(Set.of(new TopicPartition(topicName, 0)));
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.never())).requestUpdate(ArgumentMatchers.anyBoolean());
        List<TopicIdPartition> remainingAssignment = this.topicIdPartitions(topicId, topicName, 1);
        this.testRevocationCompleted(membershipManager, remainingAssignment);
    }

    @Test
    public void testOnSubscriptionUpdatedDoesNotTransitionToJoiningIfInGroup() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        membershipManager.onSubscriptionUpdated();
        Assertions.assertTrue((boolean)membershipManager.subscriptionUpdated());
        membershipManager.onConsumerPoll();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).transitionToJoining();
        Assertions.assertFalse((boolean)membershipManager.subscriptionUpdated());
    }

    @Test
    public void testOnSubscriptionUpdatedTransitionsToJoiningOnPollIfNotInGroup() {
        ShareMembershipManager membershipManager = this.createMembershipManager();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.onSubscriptionUpdated();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).transitionToJoining();
        Assertions.assertTrue((boolean)membershipManager.subscriptionUpdated());
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.onConsumerPoll();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager)).transitionToJoining();
    }

    private void assertLeaveGroupDueToExpiredPollAndTransitionToStale(ShareMembershipManager membershipManager) {
        Assertions.assertDoesNotThrow(() -> membershipManager.transitionToSendingLeaveGroup(true));
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        membershipManager.onHeartbeatRequestGenerated();
        this.assertStaleMemberLeavesGroupAndClearsAssignment(membershipManager);
    }

    @Test
    public void testTransitionToLeavingWhileReconcilingDueToStaleMember() {
        ShareMembershipManager membershipManager = this.memberJoinWithAssignment();
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.assertLeaveGroupDueToExpiredPollAndTransitionToStale(membershipManager);
    }

    @Test
    public void testTransitionToLeavingWhileJoiningDueToStaleMember() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.assertLeaveGroupDueToExpiredPollAndTransitionToStale(membershipManager);
    }

    @Test
    public void testTransitionToLeavingWhileStableDueToStaleMember() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        this.assertLeaveGroupDueToExpiredPollAndTransitionToStale(membershipManager);
    }

    @Test
    public void testTransitionToLeavingWhileAcknowledgingDueToStaleMember() {
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true);
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        this.assertLeaveGroupDueToExpiredPollAndTransitionToStale(membershipManager);
    }

    @Test
    public void testStaleMemberDoesNotSendHeartbeatAndAllowsTransitionToJoiningToRecover() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        membershipManager.transitionToSendingLeaveGroup(true);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.shouldSkipHeartbeat(), (String)"Stale member should not send heartbeats");
        Assertions.assertDoesNotThrow(() -> ((ShareMembershipManager)membershipManager).maybeRejoinStaleMember());
    }

    @Test
    public void testStaleMemberRejoinsWhenTimerResetsNoCallbacks() {
        ShareMembershipManager membershipManager = this.mockStaleMember();
        this.assertStaleMemberLeavesGroupAndClearsAssignment(membershipManager);
        membershipManager.maybeRejoinStaleMember();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
    }

    private ShareMembershipManager mockStaleMember() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToSendingLeaveGroup(true);
        membershipManager.onHeartbeatRequestGenerated();
        return membershipManager;
    }

    private void mockPartitionOwnedAndNewPartitionAdded(String topicName, int partitionOwned, int partitionAdded, CounterConsumerRebalanceListener listener, ShareMembershipManager membershipManager) {
        Uuid topicId = Uuid.randomUuid();
        TopicPartition owned = new TopicPartition(topicName, partitionOwned);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(owned));
        membershipManager.updateAssignment(Collections.singletonMap(topicId, Utils.mkSortedSet((Comparable[])new Integer[]{partitionOwned})));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.ofNullable(listener));
        this.receiveAssignment(topicId, Arrays.asList(partitionOwned, partitionAdded), membershipManager);
    }

    private SortedSet<TopicIdPartition> topicIdPartitionsSet(Uuid topicId, String topicName, int ... partitions) {
        TreeSet<TopicIdPartition> topicIdPartitions = new TreeSet<TopicIdPartition>((Comparator<TopicIdPartition>)new Utils.TopicIdPartitionComparator());
        for (int partition : partitions) {
            topicIdPartitions.add(new TopicIdPartition(topicId, new TopicPartition(topicName, partition)));
        }
        return topicIdPartitions;
    }

    private List<TopicIdPartition> topicIdPartitions(Uuid topicId, String topicName, int ... partitions) {
        return new ArrayList<TopicIdPartition>(this.topicIdPartitionsSet(topicId, topicName, partitions));
    }

    private Map<Uuid, SortedSet<Integer>> topicIdPartitionsMap(Uuid topicId, int ... partitions) {
        TreeSet<Integer> topicIdPartitions = new TreeSet<Integer>();
        for (int partition : partitions) {
            topicIdPartitions.add(partition);
        }
        return Collections.singletonMap(topicId, topicIdPartitions);
    }

    private void testFenceIsNoOp(ShareMembershipManager membershipManager) {
        Assertions.assertNotEquals((int)0, (int)membershipManager.memberEpoch());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).rebalanceListener();
    }

    private void assertStaleMemberLeavesGroupAndClearsAssignment(ShareMembershipManager membershipManager) {
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().partitions.isEmpty());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testMemberJoiningTransitionsToStableWhenReceivingEmptyAssignment() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testMetricsWhenHeartbeatFailed() {
        ShareMembershipManager membershipManager = this.createMemberInStableState();
        membershipManager.onHeartbeatFailure(false);
        Assertions.assertEquals((Object)1.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
    }

    @Test
    public void testRebalanceMetricsOnSuccessfulRebalance() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        this.mockOwnedPartition(membershipManager, Uuid.randomUuid(), "topic1");
        CompletableFuture<Void> commitResult = this.mockRevocation();
        this.receiveEmptyAssignment(membershipManager);
        long reconciliationDurationMs = 1234L;
        this.time.sleep(reconciliationDurationMs);
        membershipManager.poll(this.time.milliseconds());
        commitResult.complete(null);
        Assertions.assertEquals((Object)1.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
        Assertions.assertEquals((double)120.0, (double)1.0, (double)((Double)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceRatePerHour)));
    }

    @Test
    public void testRebalanceMetricsOnFailedRebalance() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        Uuid topicId = Uuid.randomUuid();
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.time.sleep(2300L);
        Assertions.assertTrue((boolean)this.rebalanceMetricsManager.rebalanceStarted());
        membershipManager.onHeartbeatFailure(false);
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
    }

    private Object getMetricValue(Metrics metrics, MetricName name) {
        return ((KafkaMetric)metrics.metrics().get(name)).metricValue();
    }

    private ShareMembershipManager mockMemberSuccessfullyReceivesAndAcksAssignment(Uuid topicId, String topicName, List<Integer> partitions) {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, partitions, membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.poll(this.time.milliseconds());
        List<TopicIdPartition> assignedPartitions = partitions.stream().map(tp -> new TopicIdPartition(topicId, new TopicPartition(topicName, tp.intValue()))).collect(Collectors.toList());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
        return membershipManager;
    }

    private void verifyReconciliationNotTriggered(ShareMembershipManager membershipManager) {
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationCompleted();
    }

    private void verifyReconciliationTriggeredAndCompleted(ShareMembershipManager membershipManager, List<TopicIdPartition> expectedAssignment) {
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager)).markReconciliationInProgress();
        ((ShareMembershipManager)Mockito.verify((Object)membershipManager)).markReconciliationCompleted();
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        List<TopicPartition> expectedTopicPartitions = this.buildTopicPartitions(expectedAssignment);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback((Collection)ArgumentMatchers.eq(new HashSet<TopicPartition>(expectedTopicPartitions)), (Collection)ArgumentMatchers.any());
        Map<Uuid, SortedSet<Integer>> assignmentByTopicId = this.assignmentByTopicId(expectedAssignment);
        Assertions.assertEquals(assignmentByTopicId, (Object)membershipManager.currentAssignment().partitions);
    }

    private List<TopicPartition> buildTopicPartitions(List<TopicIdPartition> topicIdPartitions) {
        return topicIdPartitions.stream().map(TopicIdPartition::topicPartition).collect(Collectors.toList());
    }

    private void mockAckSent(ShareMembershipManager membershipManager) {
        membershipManager.onHeartbeatRequestGenerated();
    }

    private void mockTopicNameInMetadataCache(Map<Uuid, String> topicNames, boolean isPresent) {
        if (isPresent) {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(topicNames);
        } else {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        }
    }

    private CompletableFuture<Void> mockRevocation() {
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        return CompletableFuture.completedFuture(null);
    }

    private void mockMemberHasAutoAssignedPartition() {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
    }

    private void testRevocationCompleted(ShareMembershipManager membershipManager, List<TopicIdPartition> expectedCurrentAssignment) {
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Map<Uuid, SortedSet<Integer>> assignmentByTopicId = this.assignmentByTopicId(expectedCurrentAssignment);
        Assertions.assertEquals(assignmentByTopicId, (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        List<TopicPartition> expectedTopicPartitionAssignment = this.buildTopicPartitions(expectedCurrentAssignment);
        HashSet<TopicPartition> expectedSet = new HashSet<TopicPartition>(expectedTopicPartitionAssignment);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(expectedSet, Collections.emptySet());
    }

    private Map<Uuid, SortedSet<Integer>> assignmentByTopicId(List<TopicIdPartition> topicIdPartitions) {
        HashMap<Uuid, SortedSet<Integer>> assignmentByTopicId = new HashMap<Uuid, SortedSet<Integer>>();
        topicIdPartitions.forEach(topicIdPartition -> {
            Uuid topicId = topicIdPartition.topicId();
            assignmentByTopicId.computeIfAbsent(topicId, k -> new TreeSet()).add(topicIdPartition.partition());
        });
        return assignmentByTopicId;
    }

    private void mockOwnedPartitionAndAssignmentReceived(ShareMembershipManager membershipManager, Uuid topicId, String topicName, Collection<TopicIdPartition> previouslyOwned) {
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.getTopicPartitions(previouslyOwned));
        HashMap partitionsByTopicId = new HashMap();
        partitionsByTopicId.put(topicId, new TreeSet(previouslyOwned.stream().map(TopicIdPartition::partition).collect(Collectors.toSet())));
        membershipManager.updateAssignment(partitionsByTopicId);
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
    }

    private Set<TopicPartition> getTopicPartitions(Collection<TopicIdPartition> topicIdPartitions) {
        return topicIdPartitions.stream().map(topicIdPartition -> new TopicPartition(topicIdPartition.topic(), topicIdPartition.partition())).collect(Collectors.toSet());
    }

    private void mockOwnedPartition(ShareMembershipManager membershipManager, Uuid topicId, String topic) {
        int partition = 0;
        TopicPartition previouslyOwned = new TopicPartition(topic, partition);
        membershipManager.updateAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, new TreeSet<Integer>(Collections.singletonList(partition)))}));
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(previouslyOwned));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
    }

    private ShareMembershipManager mockJoinAndReceiveAssignment(boolean triggerReconciliation) {
        return this.mockJoinAndReceiveAssignment(triggerReconciliation, this.createAssignment(triggerReconciliation));
    }

    private ShareMembershipManager mockJoinAndReceiveAssignment(boolean triggerReconciliation, ShareGroupHeartbeatResponseData.Assignment assignment) {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(assignment, membershipManager.memberId());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        if (triggerReconciliation) {
            membershipManager.poll(this.time.milliseconds());
            ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(ArgumentMatchers.anyCollection(), ArgumentMatchers.anyCollection());
        } else {
            ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        }
        Mockito.clearInvocations((Object[])new ShareMembershipManager[]{membershipManager});
        return membershipManager;
    }

    private ShareMembershipManager createMemberInStableState() {
        ShareMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.poll(this.time.milliseconds());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new Object[]{this.subscriptionState, membershipManager});
        return membershipManager;
    }

    private void receiveAssignment(Map<Uuid, SortedSet<Integer>> topicIdPartitionList, ShareMembershipManager membershipManager) {
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(topicIdPartitionList.entrySet().stream().map(tp -> new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)tp.getKey()).setPartitions(new ArrayList((Collection)tp.getValue()))).collect(Collectors.toList()));
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(targetAssignment, membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
    }

    private void receiveAssignment(Uuid topicId, List<Integer> partitions, ShareMembershipManager membershipManager) {
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(partitions)));
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(targetAssignment, membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
    }

    private void receiveEmptyAssignment(ShareMembershipManager membershipManager) {
        ShareGroupHeartbeatResponseData.Assignment targetAssignment = new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.emptyList());
        ShareGroupHeartbeatResponse heartbeatResponse = this.createShareGroupHeartbeatResponse(targetAssignment, membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
    }

    private void testFencedMemberReleasesAssignmentAndTransitionsToJoining(ShareMembershipManager membershipManager) {
        this.mockMemberHasAutoAssignedPartition();
        membershipManager.transitionToFenced();
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
    }

    private void testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(ShareMembershipManager membershipManager) {
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone(), (String)"Leave group result should not complete until the heartbeat request to leave is sent out.");
        this.assertTransitionToUnsubscribeOnHBSentAndWaitForResponseToCompleteLeave(membershipManager, leaveResult);
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    private void mockLeaveGroup() {
        this.mockMemberHasAutoAssignedPartition();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
    }

    private void mockPrepareLeaving(ShareMembershipManager membershipManager) {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        membershipManager.leaveGroup();
    }

    private void testStateUpdateOnFatalFailure(ShareMembershipManager membershipManager) {
        String memberId = membershipManager.memberId();
        int lastEpoch = membershipManager.memberEpoch();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        Assertions.assertEquals((Object)memberId, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)lastEpoch, (int)membershipManager.memberEpoch());
    }

    private ShareGroupHeartbeatResponse createShareGroupHeartbeatResponse(ShareGroupHeartbeatResponseData data) {
        return new ShareGroupHeartbeatResponse(data);
    }

    private ShareGroupHeartbeatResponse createShareGroupHeartbeatResponse(ShareGroupHeartbeatResponseData.Assignment assignment, String memberId) {
        return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(memberId).setMemberEpoch(1).setAssignment(assignment));
    }

    private ShareGroupHeartbeatResponse createShareGroupHeartbeatResponseWithError(String memberId) {
        return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setMemberId(memberId).setMemberEpoch(5));
    }

    private void assertMemberIdIsGenerated(String originalMemberId) {
        Assertions.assertNotNull((Object)originalMemberId, (String)"Member Id should be generated at startup");
        Assertions.assertFalse((boolean)originalMemberId.isEmpty(), (String)"Member Id should be generated at startup");
    }

    private ShareGroupHeartbeatResponseData.Assignment createAssignment(boolean mockMetadata) {
        Uuid topic1 = Uuid.randomUuid();
        Uuid topic2 = Uuid.randomUuid();
        if (mockMetadata) {
            HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
            topicNames.put(topic1, "topic1");
            topicNames.put(topic2, "topic2");
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(topicNames);
        }
        return new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Arrays.asList(0, 1, 2)), new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Arrays.asList(3, 4, 5))));
    }

    private KafkaMetric getMetric(String name) {
        return (KafkaMetric)this.metrics.metrics().get(this.metrics.metricName(name, "consumer-share-coordinator-metrics"));
    }

    private ShareMembershipManager memberJoinWithAssignment() {
        Uuid topicId = Uuid.randomUuid();
        ShareMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true);
        membershipManager.onHeartbeatRequestGenerated();
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, "topic"));
        this.receiveAssignment(topicId, Collections.singletonList(0), membershipManager);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertFalse((boolean)membershipManager.currentAssignment().isNone());
        return membershipManager;
    }

    private static Stream<Arguments> notInGroupStates() {
        return Stream.of(Arguments.of((Object[])new Object[]{MemberState.UNSUBSCRIBED}), Arguments.of((Object[])new Object[]{MemberState.FENCED}), Arguments.of((Object[])new Object[]{MemberState.FATAL}), Arguments.of((Object[])new Object[]{MemberState.STALE}));
    }
}

