/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.RoundRobinPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.test.MockSerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockProducerTest {
    private final String topic = "topic";
    private MockProducer<byte[], byte[]> producer;
    private final ProducerRecord<byte[], byte[]> record1 = new ProducerRecord("topic", (Object)"key1".getBytes(), (Object)"value1".getBytes());
    private final ProducerRecord<byte[], byte[]> record2 = new ProducerRecord("topic", (Object)"key2".getBytes(), (Object)"value2".getBytes());
    private final String groupId = "group";

    private void buildMockProducer(boolean autoComplete) {
        this.producer = new MockProducer(Cluster.empty(), autoComplete, null, (Serializer)new MockSerializer(), (Serializer)new MockSerializer());
    }

    @AfterEach
    public void cleanup() {
        if (this.producer != null && !this.producer.closed()) {
            this.producer.close();
        }
    }

    @Test
    public void testAutoCompleteMock() throws Exception {
        this.buildMockProducer(true);
        Future metadata = this.producer.send(this.record1);
        Assertions.assertTrue((boolean)metadata.isDone(), (String)"Send should be immediately complete");
        Assertions.assertFalse((boolean)this.isError(metadata), (String)"Send should be successful");
        Assertions.assertEquals((long)0L, (long)((RecordMetadata)metadata.get()).offset(), (String)"Offset should be 0");
        Assertions.assertEquals((Object)"topic", (Object)((RecordMetadata)metadata.get()).topic());
        Assertions.assertEquals(Collections.singletonList(this.record1), (Object)this.producer.history(), (String)"We should have the record in our history");
        this.producer.clear();
        Assertions.assertEquals((int)0, (int)this.producer.history().size(), (String)"Clear should erase our history");
    }

    @Test
    public void testPartitioner() throws Exception {
        PartitionInfo partitionInfo0 = new PartitionInfo("topic", 0, null, null, null);
        PartitionInfo partitionInfo1 = new PartitionInfo("topic", 1, null, null, null);
        Cluster cluster = new Cluster(null, new ArrayList(0), Arrays.asList(partitionInfo0, partitionInfo1), Collections.emptySet(), Collections.emptySet());
        MockProducer producer = new MockProducer(cluster, true, (Partitioner)new RoundRobinPartitioner(), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        ProducerRecord record = new ProducerRecord("topic", (Object)"key", (Object)"value");
        Future metadata = producer.send(record);
        Assertions.assertEquals((int)0, (int)((RecordMetadata)metadata.get()).partition(), (String)"Partition should be correct");
        producer.clear();
        Assertions.assertEquals((int)0, (int)producer.history().size(), (String)"Clear should erase our history");
        producer.close();
    }

    @Test
    public void testManualCompletion() throws Exception {
        this.buildMockProducer(false);
        Future md1 = this.producer.send(this.record1);
        Assertions.assertFalse((boolean)md1.isDone(), (String)"Send shouldn't have completed");
        Future md2 = this.producer.send(this.record2);
        Assertions.assertFalse((boolean)md2.isDone(), (String)"Send shouldn't have completed");
        Assertions.assertTrue((boolean)this.producer.completeNext(), (String)"Complete the first request");
        Assertions.assertFalse((boolean)this.isError(md1), (String)"Request should be successful");
        Assertions.assertFalse((boolean)md2.isDone(), (String)"Second request still incomplete");
        IllegalArgumentException e = new IllegalArgumentException("blah");
        Assertions.assertTrue((boolean)this.producer.errorNext((RuntimeException)e), (String)"Complete the second request with an error");
        try {
            md2.get();
            Assertions.fail((String)"Expected error to be thrown");
        }
        catch (ExecutionException err) {
            Assertions.assertEquals((Object)e, (Object)err.getCause());
        }
        Assertions.assertFalse((boolean)this.producer.completeNext(), (String)"No more requests to complete");
        Future md3 = this.producer.send(this.record1);
        Future md4 = this.producer.send(this.record2);
        Assertions.assertTrue((!md3.isDone() && !md4.isDone() ? 1 : 0) != 0, (String)"Requests should not be completed.");
        this.producer.flush();
        Assertions.assertTrue((md3.isDone() && md4.isDone() ? 1 : 0) != 0, (String)"Requests should be completed.");
    }

    @Test
    public void shouldInitTransactions() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        Assertions.assertTrue((boolean)this.producer.transactionInitialized());
    }

    @Test
    public void shouldThrowOnInitTransactionIfProducerAlreadyInitializedForTransactions() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.initTransactions());
    }

    @Test
    public void shouldThrowOnBeginTransactionIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.beginTransaction());
    }

    @Test
    public void shouldBeginTransactions() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assertions.assertTrue((boolean)this.producer.transactionInFlight());
    }

    @Test
    public void shouldThrowOnBeginTransactionsIfTransactionInflight() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.beginTransaction());
    }

    @Test
    public void shouldThrowOnSendOffsetsToTransactionIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.sendOffsetsToTransaction(null, new ConsumerGroupMetadata("group")));
    }

    @Test
    public void shouldThrowOnSendOffsetsToTransactionTransactionIfNoTransactionGotStarted() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.sendOffsetsToTransaction(null, new ConsumerGroupMetadata("group")));
    }

    @Test
    public void shouldThrowOnCommitIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.commitTransaction());
    }

    @Test
    public void shouldThrowOnCommitTransactionIfNoTransactionGotStarted() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.commitTransaction());
    }

    @Test
    public void shouldCommitEmptyTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        Assertions.assertFalse((boolean)this.producer.transactionInFlight());
        Assertions.assertTrue((boolean)this.producer.transactionCommitted());
        Assertions.assertFalse((boolean)this.producer.transactionAborted());
    }

    @Test
    public void shouldCountCommittedTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assertions.assertEquals((long)0L, (long)this.producer.commitCount());
        this.producer.commitTransaction();
        Assertions.assertEquals((long)1L, (long)this.producer.commitCount());
    }

    @Test
    public void shouldNotCountAbortedTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.abortTransaction();
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        Assertions.assertEquals((long)1L, (long)this.producer.commitCount());
    }

    @Test
    public void shouldThrowOnAbortIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.abortTransaction());
    }

    @Test
    public void shouldThrowOnAbortTransactionIfNoTransactionGotStarted() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.abortTransaction());
    }

    @Test
    public void shouldAbortEmptyTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.abortTransaction();
        Assertions.assertFalse((boolean)this.producer.transactionInFlight());
        Assertions.assertTrue((boolean)this.producer.transactionAborted());
        Assertions.assertFalse((boolean)this.producer.transactionCommitted());
    }

    @Test
    public void shouldThrowFenceProducerIfTransactionsNotInitialized() {
        this.buildMockProducer(true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.fenceProducer());
    }

    @Test
    public void shouldThrowOnBeginTransactionsIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        Assertions.assertThrows(ProducerFencedException.class, () -> this.producer.beginTransaction());
    }

    @Test
    public void shouldThrowOnSendIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        Throwable e = Assertions.assertThrows(KafkaException.class, () -> this.producer.send(null));
        Assertions.assertInstanceOf(ProducerFencedException.class, (Object)e.getCause(), (String)"The root cause of the exception should be ProducerFenced");
    }

    @Test
    public void shouldThrowOnSendOffsetsToTransactionByGroupIdIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        Assertions.assertThrows(ProducerFencedException.class, () -> this.producer.sendOffsetsToTransaction(null, new ConsumerGroupMetadata("group")));
    }

    @Test
    public void shouldThrowOnSendOffsetsToTransactionByGroupMetadataIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        Assertions.assertThrows(ProducerFencedException.class, () -> this.producer.sendOffsetsToTransaction(null, new ConsumerGroupMetadata("group")));
    }

    @Test
    public void shouldThrowOnCommitTransactionIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        Assertions.assertThrows(ProducerFencedException.class, () -> this.producer.commitTransaction());
    }

    @Test
    public void shouldThrowOnAbortTransactionIfProducerGotFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        Assertions.assertThrows(ProducerFencedException.class, () -> this.producer.abortTransaction());
    }

    @Test
    public void shouldPublishMessagesOnlyAfterCommitIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.send(this.record1);
        this.producer.send(this.record2);
        Assertions.assertTrue((boolean)this.producer.history().isEmpty());
        this.producer.commitTransaction();
        ArrayList<ProducerRecord<byte[], byte[]>> expectedResult = new ArrayList<ProducerRecord<byte[], byte[]>>();
        expectedResult.add(this.record1);
        expectedResult.add(this.record2);
        Assertions.assertEquals(expectedResult, (Object)this.producer.history());
    }

    @Test
    public void shouldFlushOnCommitForNonAutoCompleteIfTransactionsAreEnabled() {
        this.buildMockProducer(false);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Future md1 = this.producer.send(this.record1);
        Future md2 = this.producer.send(this.record2);
        Assertions.assertFalse((boolean)md1.isDone());
        Assertions.assertFalse((boolean)md2.isDone());
        this.producer.commitTransaction();
        Assertions.assertTrue((boolean)md1.isDone());
        Assertions.assertTrue((boolean)md2.isDone());
    }

    @Test
    public void shouldDropMessagesOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.send(this.record1);
        this.producer.send(this.record2);
        this.producer.abortTransaction();
        Assertions.assertTrue((boolean)this.producer.history().isEmpty());
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        Assertions.assertTrue((boolean)this.producer.history().isEmpty());
    }

    @Test
    public void shouldThrowOnAbortForNonAutoCompleteIfTransactionsAreEnabled() {
        this.buildMockProducer(false);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Future md1 = this.producer.send(this.record1);
        Assertions.assertFalse((boolean)md1.isDone());
        this.producer.abortTransaction();
        Assertions.assertTrue((boolean)md1.isDone());
    }

    @Test
    public void shouldPreserveCommittedMessagesOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.send(this.record1);
        this.producer.send(this.record2);
        this.producer.commitTransaction();
        this.producer.beginTransaction();
        this.producer.abortTransaction();
        ArrayList<ProducerRecord<byte[], byte[]>> expectedResult = new ArrayList<ProducerRecord<byte[], byte[]>>();
        expectedResult.add(this.record1);
        expectedResult.add(this.record2);
        Assertions.assertEquals(expectedResult, (Object)this.producer.history());
    }

    @Test
    public void shouldPublishConsumerGroupOffsetsOnlyAfterCommitIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group1 = "g1";
        Map<TopicPartition, OffsetAndMetadata> group1Commit = Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null), new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
        String group2 = "g2";
        Map<TopicPartition, OffsetAndMetadata> group2Commit = Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(101L, null), new TopicPartition("topic", 1), new OffsetAndMetadata(21L, null));
        this.producer.sendOffsetsToTransaction(group1Commit, new ConsumerGroupMetadata(group1));
        this.producer.sendOffsetsToTransaction(group2Commit, new ConsumerGroupMetadata(group2));
        Assertions.assertTrue((boolean)this.producer.consumerGroupOffsetsHistory().isEmpty());
        HashMap<String, Map<TopicPartition, OffsetAndMetadata>> expectedResult = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        expectedResult.put(group1, group1Commit);
        expectedResult.put(group2, group2Commit);
        this.producer.commitTransaction();
        Assertions.assertEquals(Collections.singletonList(expectedResult), (Object)this.producer.consumerGroupOffsetsHistory());
    }

    @Test
    public void shouldThrowOnNullConsumerGroupMetadataWhenSendOffsetsToTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assertions.assertThrows(NullPointerException.class, () -> this.producer.sendOffsetsToTransaction(Collections.emptyMap(), new ConsumerGroupMetadata(null)));
    }

    @Test
    public void shouldIgnoreEmptyOffsetsWhenSendOffsetsToTransactionByGroupMetadata() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        this.producer.sendOffsetsToTransaction(Collections.emptyMap(), new ConsumerGroupMetadata("groupId"));
        Assertions.assertFalse((boolean)this.producer.sentOffsets());
    }

    @Test
    public void shouldAddOffsetsWhenSendOffsetsToTransactionByGroupMetadata() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assertions.assertFalse((boolean)this.producer.sentOffsets());
        Map<TopicPartition, OffsetAndMetadata> groupCommit = Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
        this.producer.sendOffsetsToTransaction(groupCommit, new ConsumerGroupMetadata("groupId"));
        Assertions.assertTrue((boolean)this.producer.sentOffsets());
    }

    @Test
    public void shouldResetSentOffsetsFlagOnlyWhenBeginningNewTransaction() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        Assertions.assertFalse((boolean)this.producer.sentOffsets());
        Map<TopicPartition, OffsetAndMetadata> groupCommit = Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null));
        this.producer.sendOffsetsToTransaction(groupCommit, new ConsumerGroupMetadata("groupId"));
        this.producer.commitTransaction();
        Assertions.assertTrue((boolean)this.producer.sentOffsets());
        this.producer.beginTransaction();
        Assertions.assertFalse((boolean)this.producer.sentOffsets());
        this.producer.sendOffsetsToTransaction(groupCommit, new ConsumerGroupMetadata("groupId"));
        this.producer.commitTransaction();
        Assertions.assertTrue((boolean)this.producer.sentOffsets());
        this.producer.beginTransaction();
        Assertions.assertFalse((boolean)this.producer.sentOffsets());
    }

    @Test
    public void shouldPublishLatestAndCumulativeConsumerGroupOffsetsOnlyAfterCommitIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group = "g";
        Map<TopicPartition, OffsetAndMetadata> groupCommit1 = Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null), new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
        Map<TopicPartition, OffsetAndMetadata> groupCommit2 = Map.of(new TopicPartition("topic", 1), new OffsetAndMetadata(101L, null), new TopicPartition("topic", 2), new OffsetAndMetadata(21L, null));
        this.producer.sendOffsetsToTransaction(groupCommit1, new ConsumerGroupMetadata(group));
        this.producer.sendOffsetsToTransaction(groupCommit2, new ConsumerGroupMetadata(group));
        Assertions.assertTrue((boolean)this.producer.consumerGroupOffsetsHistory().isEmpty());
        Map<String, Map<TopicPartition, OffsetAndMetadata>> expectedResult = Map.of(group, Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null), new TopicPartition("topic", 1), new OffsetAndMetadata(101L, null), new TopicPartition("topic", 2), new OffsetAndMetadata(21L, null)));
        this.producer.commitTransaction();
        Assertions.assertEquals(Collections.singletonList(expectedResult), (Object)this.producer.consumerGroupOffsetsHistory());
    }

    @Test
    public void shouldDropConsumerGroupOffsetsOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group = "g";
        Map<TopicPartition, OffsetAndMetadata> groupCommit = Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null), new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
        this.producer.sendOffsetsToTransaction(groupCommit, new ConsumerGroupMetadata(group));
        this.producer.abortTransaction();
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        Assertions.assertTrue((boolean)this.producer.consumerGroupOffsetsHistory().isEmpty());
        this.producer.beginTransaction();
        this.producer.sendOffsetsToTransaction(groupCommit, new ConsumerGroupMetadata(group));
        this.producer.abortTransaction();
        this.producer.beginTransaction();
        this.producer.commitTransaction();
        Assertions.assertTrue((boolean)this.producer.consumerGroupOffsetsHistory().isEmpty());
    }

    @Test
    public void shouldPreserveOffsetsFromCommitByGroupIdOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group = "g";
        Map<TopicPartition, OffsetAndMetadata> groupCommit = Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null), new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
        this.producer.sendOffsetsToTransaction(groupCommit, new ConsumerGroupMetadata(group));
        this.producer.commitTransaction();
        this.producer.beginTransaction();
        this.producer.abortTransaction();
        HashMap<String, Map<TopicPartition, OffsetAndMetadata>> expectedResult = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        expectedResult.put(group, groupCommit);
        Assertions.assertEquals(Collections.singletonList(expectedResult), (Object)this.producer.consumerGroupOffsetsHistory());
    }

    @Test
    public void shouldPreserveOffsetsFromCommitByGroupMetadataOnAbortIfTransactionsAreEnabled() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.beginTransaction();
        String group = "g";
        Map<TopicPartition, OffsetAndMetadata> groupCommit = Map.of(new TopicPartition("topic", 0), new OffsetAndMetadata(42L, null), new TopicPartition("topic", 1), new OffsetAndMetadata(73L, null));
        this.producer.sendOffsetsToTransaction(groupCommit, new ConsumerGroupMetadata(group));
        this.producer.commitTransaction();
        this.producer.beginTransaction();
        String group2 = "g2";
        Map<TopicPartition, OffsetAndMetadata> groupCommit2 = Map.of(new TopicPartition("topic", 2), new OffsetAndMetadata(53L, null), new TopicPartition("topic", 3), new OffsetAndMetadata(84L, null));
        this.producer.sendOffsetsToTransaction(groupCommit2, new ConsumerGroupMetadata(group2));
        this.producer.abortTransaction();
        HashMap<String, Map<TopicPartition, OffsetAndMetadata>> expectedResult = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        expectedResult.put(group, groupCommit);
        Assertions.assertEquals(Collections.singletonList(expectedResult), (Object)this.producer.consumerGroupOffsetsHistory());
    }

    @Test
    public void shouldThrowOnInitTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.initTransactions());
    }

    @Test
    public void shouldThrowOnSendIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.send(null));
    }

    @Test
    public void shouldThrowOnBeginTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.beginTransaction());
    }

    @Test
    public void shouldThrowSendOffsetsToTransactionByGroupIdIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.sendOffsetsToTransaction(null, new ConsumerGroupMetadata("group")));
    }

    @Test
    public void shouldThrowSendOffsetsToTransactionByGroupMetadataIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.sendOffsetsToTransaction(null, new ConsumerGroupMetadata("group")));
    }

    @Test
    public void shouldThrowOnCommitTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.commitTransaction());
    }

    @Test
    public void shouldThrowOnAbortTransactionIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.abortTransaction());
    }

    @Test
    public void shouldThrowOnFenceProducerIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.fenceProducer());
    }

    @Test
    public void shouldThrowOnFlushProducerIfProducerIsClosed() {
        this.buildMockProducer(true);
        this.producer.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer.flush());
    }

    @Test
    public void shouldNotThrowOnFlushProducerIfProducerIsFenced() {
        this.buildMockProducer(true);
        this.producer.initTransactions();
        this.producer.fenceProducer();
        Assertions.assertDoesNotThrow(() -> this.producer.flush());
    }

    @Test
    public void shouldThrowClassCastException() {
        try (MockProducer customProducer = new MockProducer(Cluster.empty(), true, null, (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());){
            Assertions.assertThrows(ClassCastException.class, () -> customProducer.send(new ProducerRecord("topic", (Object)"key1", (Object)"value1")));
        }
    }

    @Test
    public void shouldBeFlushedIfNoBufferedRecords() {
        this.buildMockProducer(true);
        Assertions.assertTrue((boolean)this.producer.flushed());
    }

    @Test
    public void shouldBeFlushedWithAutoCompleteIfBufferedRecords() {
        this.buildMockProducer(true);
        this.producer.send(this.record1);
        Assertions.assertTrue((boolean)this.producer.flushed());
    }

    @Test
    public void shouldNotBeFlushedWithNoAutoCompleteIfBufferedRecords() {
        this.buildMockProducer(false);
        this.producer.send(this.record1);
        Assertions.assertFalse((boolean)this.producer.flushed());
    }

    @Test
    public void shouldNotBeFlushedAfterFlush() {
        this.buildMockProducer(false);
        this.producer.send(this.record1);
        this.producer.flush();
        Assertions.assertTrue((boolean)this.producer.flushed());
    }

    @Test
    public void testMetadataOnException() throws InterruptedException {
        this.buildMockProducer(false);
        Future metadata = this.producer.send(this.record2, (md, exception) -> {
            Assertions.assertNotNull((Object)md);
            Assertions.assertEquals((long)md.offset(), (long)-1L, (String)"Invalid offset");
            Assertions.assertEquals((long)md.timestamp(), (long)-1L, (String)"Invalid timestamp");
            Assertions.assertEquals((long)md.serializedKeySize(), (long)-1L, (String)"Invalid Serialized Key size");
            Assertions.assertEquals((long)md.serializedValueSize(), (long)-1L, (String)"Invalid Serialized value size");
        });
        IllegalArgumentException e = new IllegalArgumentException("dummy exception");
        Assertions.assertTrue((boolean)this.producer.errorNext((RuntimeException)e), (String)"Complete the second request with an error");
        try {
            metadata.get();
            Assertions.fail((String)"Something went wrong, expected an error");
        }
        catch (ExecutionException err) {
            Assertions.assertEquals((Object)e, (Object)err.getCause());
        }
    }

    private boolean isError(Future<?> future) {
        try {
            future.get();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

