/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourcePatternFilterTest {
    @Test
    public void shouldBeUnknownIfResourceTypeUnknown() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL).isUnknown());
    }

    @Test
    public void shouldBeUnknownIfPatternTypeUnknown() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.GROUP, null, PatternType.UNKNOWN).isUnknown());
    }

    @Test
    public void shouldNotMatchIfDifferentResourceType() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.GROUP, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchIfDifferentName() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Different", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldNotMatchIfDifferentNameCase() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "NAME", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchIfDifferentPatternType() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchWhereResourceTypeIsAny() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.ANY, "Name", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchWhereResourceNameIsAny() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchWherePatternTypeIsAny() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.ANY).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchWherePatternTypeIsMatch() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchLiteralIfExactMatch() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchLiteralIfNameMatchesAndFilterIsOnPatternTypeAny() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.ANY).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchLiteralIfNameMatchesAndFilterIsOnPatternTypeMatch() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchLiteralIfNamePrefixed() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name-something", PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchLiteralWildcardIfExactMatch() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "*", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchLiteralWildcardAgainstOtherName() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchLiteralWildcardTheWayAround() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "*", PatternType.LITERAL).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
    }

    @Test
    public void shouldNotMatchLiteralWildcardIfFilterHasPatternTypeOfAny() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.ANY).matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchLiteralWildcardIfFilterHasPatternTypeOfMatch() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
    }

    @Test
    public void shouldMatchPrefixedIfExactMatch() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldNotMatchIfBothPrefixedAndFilterIsPrefixOfResource() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name-something", PatternType.PREFIXED)));
    }

    @Test
    public void shouldNotMatchIfBothPrefixedAndResourceIsPrefixOfFilter() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name-something", PatternType.PREFIXED).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldNotMatchPrefixedIfNamePrefixedAnyFilterTypeIsAny() {
        Assertions.assertFalse((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name-something", PatternType.ANY).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void shouldMatchPrefixedIfNamePrefixedAnyFilterTypeIsMatch() {
        Assertions.assertTrue((boolean)new ResourcePatternFilter(ResourceType.TOPIC, "Name-something", PatternType.MATCH).matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
    }

    @Test
    public void testAllTenantLiteral() {
        ResourcePatternFilter filter = new ResourcePatternFilter(ResourceType.TOPIC, "Tenant_", PatternType.CONFLUENT_ALL_TENANT_LITERAL);
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.GROUP, "Tenant_Name", PatternType.LITERAL)));
    }

    @Test
    public void testAllTenantPrefixed() {
        ResourcePatternFilter filter = new ResourcePatternFilter(ResourceType.TOPIC, "Tenant_", PatternType.CONFLUENT_ALL_TENANT_PREFIXED);
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.GROUP, "Tenant_Name", PatternType.PREFIXED)));
    }

    @Test
    public void testAllTenantAny() {
        ResourcePatternFilter filter = new ResourcePatternFilter(ResourceType.TOPIC, "Tenant_", PatternType.CONFLUENT_ALL_TENANT_ANY);
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_", PatternType.PREFIXED)));
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.GROUP, "Tenant_Name", PatternType.LITERAL)));
    }

    @Test
    public void testOnlyTenantMatch() {
        ResourcePatternFilter filter = new ResourcePatternFilter(ResourceType.TOPIC, "Tenant_Name", PatternType.CONFLUENT_ONLY_TENANT_MATCH);
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_", PatternType.PREFIXED)));
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name", PatternType.PREFIXED)));
        Assertions.assertTrue((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_N", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name_Something", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Tenant_Name_Something", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "OtherTenant_", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "Name", PatternType.PREFIXED)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)filter.matches(new ResourcePattern(ResourceType.GROUP, "Tenant_Name", PatternType.LITERAL)));
    }
}

