/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TokenBucketTest {
    Time time;

    @BeforeEach
    public void setup() {
        this.time = new MockTime(0L, System.currentTimeMillis(), System.nanoTime());
    }

    protected TokenBucket tokenBucket() {
        return new TokenBucket();
    }

    @Test
    public void testRecord() {
        MetricConfig config = new MetricConfig().quota(Quota.upperBound((double)5.0)).timeWindow(2L, TimeUnit.SECONDS).samples(10);
        TokenBucket tk = this.tokenBucket();
        Assertions.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        tk.record(config, 60.0, this.time.milliseconds());
        Assertions.assertEquals((double)40.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        tk.record(config, 5.0, this.time.milliseconds());
        Assertions.assertEquals((double)45.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        tk.record(config, 60.0, this.time.milliseconds());
        Assertions.assertEquals((double)-5.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
    }

    @Test
    public void testUnrecord() {
        MetricConfig config = new MetricConfig().quota(Quota.upperBound((double)5.0)).timeWindow(2L, TimeUnit.SECONDS).samples(10);
        TokenBucket tk = this.tokenBucket();
        Assertions.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        tk.record(config, -60.0, this.time.milliseconds());
        Assertions.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        tk.record(config, 60.0, this.time.milliseconds());
        Assertions.assertEquals((double)40.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        tk.record(config, -60.0, this.time.milliseconds());
        Assertions.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
    }

    @Test
    public void testUpdateQuota() {
        MetricConfig config = new MetricConfig().quota(Quota.upperBound((double)5.0)).timeWindow(2L, TimeUnit.SECONDS).samples(10);
        TokenBucket tk = this.tokenBucket();
        Assertions.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        config.quota(Quota.upperBound((double)10.0));
        Assertions.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(5000L);
        Assertions.assertEquals((double)150.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        config.quota(Quota.upperBound((double)2.0));
        Assertions.assertEquals((double)40.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
    }

    @Test
    public void TestNegativeBound() {
        MetricConfig config = new MetricConfig().quota(Quota.upperBound((double)5.0)).timeWindow(2L, TimeUnit.SECONDS).samples(10);
        TokenBucket tk = new TokenBucket(TimeUnit.SECONDS, TimeUnit.MINUTES.toMillis(1L));
        Assertions.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        tk.record(config, 500.0, this.time.milliseconds());
        Assertions.assertEquals((double)-300.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        tk.record(config, 500.0, this.time.milliseconds());
        Assertions.assertEquals((double)-300.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(1000L);
        Assertions.assertEquals((double)-295.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
    }

    @Test
    public void TestZeroQuota() {
        MetricConfig config = new MetricConfig().quota(Quota.upperBound((double)0.0)).timeWindow(2L, TimeUnit.SECONDS).samples(10);
        TokenBucket tk = new TokenBucket(TimeUnit.SECONDS, TimeUnit.MINUTES.toMillis(1L));
        Assertions.assertEquals((double)0.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        tk.record(config, 500.0, this.time.milliseconds());
        Assertions.assertEquals((double)-500.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
    }
}

