/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.common.network.ProxyProtocolCombinedEngine;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;
import org.apache.kafka.common.network.ProxyTlv;
import org.apache.kafka.common.network.ProxyTlvType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullAndEmptySource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class AbstractProxyProtocolEngineTest {
    protected static final String DEFAULT_SOURCE_ADDRESS_IPV4 = "216.58.208.238";
    protected static final String DEFAULT_SOURCE_ADDRESS_IPV6 = "2001:db8:85a3:8d3:1319:8a2e:370:7348";
    protected static final String DEFAULT_DESTINATION_ADDRESS_IPV4 = "127.0.0.1";
    protected static final String DEFAULT_DESTINATION_ADDRESS_IPV6 = "2001:db8:85a3:8d3:1319:8a2e:370:7349";
    protected static final int DEFAULT_SOURCE_PORT = 8888;
    protected static final int DEFAULT_DESTINATION_PORT = 9092;
    protected static final ProxyProtocolCommand DEFAULT_COMMAND = ProxyProtocolCommand.PROXY;
    protected static final String DEFAULT_LKC_ID = "lkc-4proxy";
    protected static final String DEFAULT_INGRESS_GATEWAY_ID = "test_ingress_gateway_id";
    protected static final String DEFAULT_ACCESS_POINT_ID = "test_access_point_id";
    protected static final String DEFAULT_AVAILABILITY_ZONE_ID = "test_availability_zone_id";
    protected static final String DEFAULT_FQDN_TEMPLATE = "test_fqdn_template";
    protected static final String DEFAULT_INGRESS_TYPE = "test_ingress_type";
    protected static final String DEFAULT_PRIVATE_ENDPOINT_ID = "test_private_endpoint_id";
    protected static final String DEFAULT_GATEWAY_ZONES = "test_gateway_zone1,test_gateway_zone2";
    protected static final CCloudTrafficType DEFAULT_CCLOUD_TRAFFIC_TYPE = CCloudTrafficType.PL_PUBLIC_IP_NLB;
    protected static final ProxyTlv DEFAULT_TLV = ProxyTlv.createForSubtype((ProxyTlvType)ProxyTlvType.LKC_ID, (String)"lkc-4proxy");
    protected static final ProxyTlv DEFAULT_CCLOUD_TRAFFIC_TYPE_TLV = DEFAULT_CCLOUD_TRAFFIC_TYPE.tlv();
    protected static final ProxyTlv DEFAULT_INGRESS_GATEWAY_ID_TLV = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.INGRESS_GATEWAY_ID, (String)"test_ingress_gateway_id", (Charset)StandardCharsets.US_ASCII);
    protected static final ProxyTlv DEFAULT_ACCESS_POINT_ID_TLV = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.ACCESS_POINT_ID, (String)"test_access_point_id", (Charset)StandardCharsets.US_ASCII);
    protected static final ProxyTlv DEFAULT_AVAILABILITY_ZONE_ID_TLV = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.AVAILABILITY_ZONE_ID, (String)"test_availability_zone_id", (Charset)StandardCharsets.US_ASCII);
    protected static final ProxyTlv DEFAULT_FQDN_TEMPLATE_TLV = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.FQDN_TEMPLATE, (String)"test_fqdn_template", (Charset)StandardCharsets.US_ASCII);
    protected static final ProxyTlv DEFAULT_INGRESS_TYPE_TLV = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.INGRESS_TYPE, (String)"test_ingress_type", (Charset)StandardCharsets.US_ASCII);
    protected static final ProxyTlv DEFAULT_PRIVATE_ENDPOINT_ID_TLV = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.PRIVATE_ENDPOINT_ID, (String)"test_private_endpoint_id", (Charset)StandardCharsets.US_ASCII);
    protected static final ProxyTlv DEFAULT_GATEWAY_ZONES_TLV = ProxyTlv.createForSubtypeWithCharSet((ProxyTlvType)ProxyTlvType.GATEWAY_ZONES, (String)"test_gateway_zone1,test_gateway_zone2", (Charset)StandardCharsets.US_ASCII);

    protected abstract ProxyProtocolEngine newServerPPE();

    protected abstract ProxyProtocolEngine newClientPPE();

    protected abstract List<String> getInvalidProxyHeaders();

    protected abstract byte[] generateHeader(String var1);

    protected void putStreamAndFlip(ByteBuffer buf, String header) {
        buf.put(this.generateHeader(header));
        buf.flip();
    }

    protected ByteBuffer putStream(String header) {
        return ByteBuffer.wrap(this.generateHeader(header));
    }

    @Test
    public void testInvalidHeaders() {
        for (String header : this.getInvalidProxyHeaders()) {
            ProxyProtocolEngine engine = this.newServerPPE();
            ByteBuffer buf = ByteBuffer.allocate(1000);
            this.putStreamAndFlip(buf, header);
            Assertions.assertThrows(IOException.class, () -> engine.processHeaders(buf));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"216.58.208.238", "2001:db8:85a3:8d3:1319:8a2e:370:7348"})
    public void testFormatAndParse(String sourceAddress) throws IOException {
        ProxyProtocolEngine engine = this.newClientPPE(sourceAddress, 8888, DEFAULT_COMMAND, DEFAULT_LKC_ID);
        this.assertValidEngineState(engine, true, false, engine.clientAddress(), engine.clientPort(), engine.command(), engine.tlv(ProxyTlvType.LKC_ID) == null ? Collections.emptyList() : Collections.singletonList(engine.tlv(ProxyTlvType.LKC_ID)));
        String destinationAddress = engine.clientAddress() instanceof Inet4Address ? DEFAULT_DESTINATION_ADDRESS_IPV4 : DEFAULT_DESTINATION_ADDRESS_IPV6;
        ByteBuffer buf = ByteBuffer.allocate(131);
        buf.put(engine.emitHeaders(InetAddress.getByName(destinationAddress), 9092));
        buf.put(new byte[3]);
        buf.flip();
        engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        engine.processHeaders(buf);
        this.assertValidEngineState(engine, true, true, InetAddress.getByName(sourceAddress), 8888, this.isUsingV2Engine(engine) ? DEFAULT_COMMAND : null, this.isUsingV2Engine(engine) ? Collections.singletonList(DEFAULT_TLV) : Collections.emptyList());
    }

    private boolean isUsingV2Engine(ProxyProtocolEngine engine) {
        if (engine instanceof ProxyProtocolV2Engine) {
            return true;
        }
        if (engine instanceof ProxyProtocolCombinedEngine) {
            return ((ProxyProtocolCombinedEngine)engine).getActiveEngine() instanceof ProxyProtocolV2Engine;
        }
        return false;
    }

    @ParameterizedTest
    @NullAndEmptySource
    @ValueSource(strings={" ", " 216.58.208.238 ", "\n"})
    public void testClientAddressConfig(String address) {
        Assertions.assertThrows(ConfigException.class, () -> this.newClientPPE(address, 8888, DEFAULT_COMMAND, DEFAULT_LKC_ID));
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(ints={-1, 65536})
    public void testClientPortConfig(Integer port) {
        Assertions.assertThrows(ConfigException.class, () -> this.newClientPPE(DEFAULT_SOURCE_ADDRESS_IPV4, port, DEFAULT_COMMAND, DEFAULT_LKC_ID));
    }

    protected ProxyProtocolEngine newClientPPE(String clientAddress, Integer clientPort, Object command, String lkcId) {
        return this.newClientPPE(clientAddress, clientPort, command, lkcId, null);
    }

    protected ProxyProtocolEngine newClientPPE(String clientAddress, Integer clientPort, Object command, String lkcId, CCloudTrafficType trafficType) {
        return this.newClientPPE(clientAddress, clientPort, command, lkcId, trafficType, null, null, null, null, null, null, null);
    }

    protected ProxyProtocolEngine newClientPPE(String clientAddress, Integer clientPort, Object command, String lkcId, CCloudTrafficType trafficType, String ingressGatewayId, String accessPointId, String availabilityZoneId, String fqdnTemplate, String ingressType, String privateEndpointId, String gatewayZones) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (clientAddress != null) {
            config.put("confluent.proxy.protocol.client.address", clientAddress);
        }
        if (clientPort != null) {
            config.put("confluent.proxy.protocol.client.port", clientPort);
        }
        if (command != null) {
            config.put("confluent.proxy.protocol.client.mode", command.toString());
        }
        if (lkcId != null) {
            config.put("confluent.lkc.id", lkcId);
        }
        if (trafficType != null) {
            config.put("confluent.ccloud.traffic.type", trafficType);
        }
        if (ingressGatewayId != null) {
            config.put("confluent.ccloud.ingress.gateway.id", ingressGatewayId);
        }
        if (accessPointId != null) {
            config.put("confluent.ccloud.access.point.id", accessPointId);
        }
        if (availabilityZoneId != null) {
            config.put("confluent.ccloud.availability.zone.id", availabilityZoneId);
        }
        if (fqdnTemplate != null) {
            config.put("confluent.ccloud.fqdn.template", fqdnTemplate);
        }
        if (ingressType != null) {
            config.put("confluent.ccloud.ingress.type", ingressType);
        }
        if (privateEndpointId != null) {
            config.put("confluent.ccloud.private.endpoint.id", privateEndpointId);
        }
        if (gatewayZones != null) {
            config.put("confluent.ccloud.gateway.zones", gatewayZones);
        }
        ProxyProtocolEngine engine = this.newClientPPE();
        engine.configure(config);
        return engine;
    }

    protected void assertValidEngineState(ProxyProtocolEngine engine, boolean hasClientInformation, boolean ready, InetAddress clientAddress, Integer clientPort, Object command) {
        this.assertValidEngineState(engine, hasClientInformation, ready, clientAddress, clientPort, command, Collections.emptyList());
    }

    protected void assertValidEngineState(ProxyProtocolEngine engine, boolean hasClientInformation, boolean ready, InetAddress clientAddress, Integer clientPort, Object command, List<ProxyTlv> expectedTlvs) {
        Assertions.assertEquals((Object)hasClientInformation, (Object)engine.hasClientInformation(), (String)"Values for hasClientInformation() did not match");
        Assertions.assertEquals((Object)ready, (Object)engine.ready(), (String)"Values for ready() did not match");
        if (clientAddress != null) {
            Assertions.assertEquals((Object)clientAddress, (Object)engine.clientAddress());
        } else {
            Assertions.assertNull((Object)engine.clientAddress());
        }
        if (clientPort != null) {
            Assertions.assertEquals((Integer)clientPort, (int)engine.clientPort());
        } else {
            Assertions.assertEquals((int)-1, (int)engine.clientPort());
        }
        if (command != null) {
            Assertions.assertEquals((Object)command, (Object)engine.command());
        } else {
            Assertions.assertNull((Object)engine.command());
        }
        if (!expectedTlvs.isEmpty()) {
            expectedTlvs.forEach(expectedTlv -> {
                ProxyTlv actualTlv = engine.tlv(expectedTlv.type());
                Assertions.assertNotNull((Object)actualTlv);
                Assertions.assertEquals((Object)expectedTlv, (Object)actualTlv);
            });
        } else {
            Assertions.assertNull((Object)engine.tlv(ProxyTlvType.LKC_ID));
            Assertions.assertNull((Object)engine.tlv(ProxyTlvType.CCLOUD_TRAFFIC_TYPE));
        }
    }
}

