/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.kafka.common.network.ConnectionExpiryManager;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConnectionExpiryManagerTest {
    @Test
    public void testUpdateApiKey() {
        MockTime time = new MockTime();
        HashSet<ApiKeys> idlenessIgnoredApiKeys = new HashSet<ApiKeys>(Arrays.asList(ApiKeys.METADATA, ApiKeys.FIND_COORDINATOR));
        ConnectionExpiryManager expiryManager = new ConnectionExpiryManager((Time)time, 1000L, idlenessIgnoredApiKeys);
        Assertions.assertEquals((int)0, (int)expiryManager.size());
        expiryManager.update("0", time.nanoseconds(), ApiKeys.METADATA);
        Assertions.assertEquals((int)0, (int)expiryManager.size());
        expiryManager.update("1", time.nanoseconds(), ApiKeys.FIND_COORDINATOR);
        Assertions.assertEquals((int)0, (int)expiryManager.size());
        expiryManager.update("2", time.nanoseconds(), ApiKeys.PRODUCE);
        expiryManager.update("3", time.nanoseconds(), ApiKeys.FETCH);
        expiryManager.update("4", time.nanoseconds(), ApiKeys.APPEND_RECORDS);
        expiryManager.update("5", time.nanoseconds(), ApiKeys.API_VERSIONS);
        time.sleep(1000L);
        expiryManager.update("2", time.nanoseconds(), ApiKeys.PRODUCE);
        expiryManager.update("3", time.nanoseconds(), ApiKeys.METADATA);
        expiryManager.update("4", time.nanoseconds(), ApiKeys.FIND_COORDINATOR);
        Assertions.assertEquals((Object)"3", (Object)expiryManager.peekOldestChannelId());
        expiryManager.remove("3");
        Assertions.assertEquals((Object)"4", (Object)expiryManager.peekOldestChannelId());
        expiryManager.remove("4");
        Assertions.assertEquals((Object)"5", (Object)expiryManager.peekOldestChannelId());
        expiryManager.remove("5");
        Assertions.assertEquals((Object)"2", (Object)expiryManager.peekOldestChannelId());
    }

    @Test
    public void testUpdate() {
        MockTime time = new MockTime();
        HashSet<ApiKeys> idlenessIgnoredApiKeys = new HashSet<ApiKeys>(Arrays.asList(ApiKeys.METADATA, ApiKeys.FIND_COORDINATOR));
        ConnectionExpiryManager expiryManager = new ConnectionExpiryManager((Time)time, 1000L, idlenessIgnoredApiKeys);
        Assertions.assertEquals((int)0, (int)expiryManager.size());
        expiryManager.update("0", time.nanoseconds());
        Assertions.assertEquals((int)1, (int)expiryManager.size());
        expiryManager.update("1", time.nanoseconds());
        Assertions.assertEquals((int)2, (int)expiryManager.size());
        expiryManager.update("2", time.nanoseconds());
        Assertions.assertEquals((int)3, (int)expiryManager.size());
        Assertions.assertEquals((Object)"0", (Object)expiryManager.peekOldestChannelId());
        expiryManager.remove("0");
        Assertions.assertEquals((Object)"1", (Object)expiryManager.peekOldestChannelId());
        expiryManager.remove("1");
        Assertions.assertEquals((Object)"2", (Object)expiryManager.peekOldestChannelId());
    }
}

