/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.network.AbstractProxyProtocolEngineTest;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV1Engine;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyProtocolV1EngineTest
extends AbstractProxyProtocolEngineTest {
    @Test
    public void testProxyProtocolV1EngineBasic() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        ByteBuffer buf = this.putStream("PROXY TCP4 200.200.200.200 201.201.201.201 8888 9092\r\n");
        engine.processHeaders(buf);
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        InetAddress address = InetAddress.getByName("200.200.200.200");
        Assertions.assertEquals((Object)engine.clientAddress(), (Object)address);
        Assertions.assertEquals((int)engine.clientPort(), (int)8888);
    }

    @Test
    public void testProxyProtocolV1EngineIpv6() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        this.assertValidEngineState(engine, false, false, null, -1, null);
        ByteBuffer buf = this.putStream("PROXY TCP6 2001:db8:85a3:8d3:1319:8a2e:370:7348 2001:db8:85a3:8d3:1319:8a2e:370:7349 8888 9092\r\n");
        engine.processHeaders(buf);
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        InetAddress address = InetAddress.getByName("2001:db8:85a3:8d3:1319:8a2e:370:7348");
        Assertions.assertEquals((Object)engine.clientAddress(), (Object)address);
        Assertions.assertEquals((int)engine.clientPort(), (int)8888);
    }

    @Test
    public void testProxyProtocolV1EngineWithMultipleSegments() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        ByteBuffer buf = ByteBuffer.allocate(1000);
        this.putStreamAndFlip(buf, "PRO");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        this.putStreamAndFlip(buf, "XY TCP4 200.200.200.200 201.201.201.201 88");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        this.putStreamAndFlip(buf, "88 9092\r\n");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        InetAddress address = InetAddress.getByName("200.200.200.200");
        Assertions.assertEquals((Object)engine.clientAddress(), (Object)address);
        Assertions.assertEquals((int)engine.clientPort(), (int)8888);
    }

    @Test
    public void TestProxyProtocolV1EngineVerifyRemaining() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        ByteBuffer buf = this.putStream("PROXY TCP4 200.200.200.200 201.201.201.201 8888 9092\r\nhello");
        engine.processHeaders(buf);
        Assertions.assertTrue((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        InetAddress address = InetAddress.getByName("200.200.200.200");
        Assertions.assertEquals((Object)engine.clientAddress(), (Object)address);
        Assertions.assertEquals((int)engine.clientPort(), (int)8888);
        Assertions.assertEquals((int)5, (int)buf.remaining());
    }

    @Test
    public void testNonProxyHeaderFallbackEnabled() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        engine.configure(Collections.singletonMap("confluent.proxy.protocol.fallback.enabled", true));
        ByteBuffer buf = this.putStream("NOT A PROXY HEADER");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        buf.flip();
        Assertions.assertEquals((int)18, (int)buf.remaining());
    }

    @Test
    public void testNonProxyHeaderWithMultipleSegments() throws IOException {
        ProxyProtocolEngine engine = this.newServerPPE();
        engine.configure(Collections.singletonMap("confluent.proxy.protocol.fallback.enabled", true));
        ByteBuffer buf = ByteBuffer.allocate(1000);
        this.putStreamAndFlip(buf, "NOT");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertFalse((boolean)engine.ready());
        this.putStreamAndFlip(buf, " ENOUGH BYTES IN FIRST CALL");
        engine.processHeaders(buf);
        buf.compact();
        Assertions.assertFalse((boolean)engine.hasClientInformation());
        Assertions.assertTrue((boolean)engine.ready());
        buf.flip();
        Assertions.assertEquals((int)30, (int)buf.remaining());
    }

    @Override
    protected ProxyProtocolEngine newServerPPE() {
        return new ProxyProtocolV1Engine(ConnectionMode.SERVER, new LogContext());
    }

    @Override
    protected ProxyProtocolEngine newClientPPE() {
        return new ProxyProtocolV1Engine(ConnectionMode.CLIENT, new LogContext());
    }

    @Override
    protected byte[] generateHeader(String header) {
        return header.getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    protected List<String> getInvalidProxyHeaders() {
        return Arrays.asList("PROXY TCP4 \r\n", "PROXY TCP4 201.201.201.201 8888\r\n", "PROXY TCP4 200.200.200.200 201.201.201.201 8888 9092\r\r", "PROXY SMTP 200.200.200.200 201.201.201.201 8888 9092\r\n", "PROXY TCP hello.world 201.201.201.201 8888 9092\r\n", "PROXY TCP4                                                                                         200.200.200.200 201.201.201.201 8888 9092\n", "NOT A PROXY HEADER\n");
    }
}

