/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.message.DescribeBrokerRemovalsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeBrokerRemovalsResponseTest {
    @Test
    public void testErrorCountsWithTopLevelError() {
        DescribeBrokerRemovalsResponseData data = new DescribeBrokerRemovalsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("This broker is not the controller").setRemovedBrokers(Arrays.asList(new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(1).setRemovalErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()), new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(2)));
        Map errorCounts = new DescribeBrokerRemovalsResponse(data).errorCounts();
        Assertions.assertEquals((int)1, (int)errorCounts.size());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)errorCounts.get(Errors.NOT_CONTROLLER)));
    }

    @Test
    public void testErrorCountsWithNoTopLevelErrorShouldReturnZeroCountOfErrors() {
        DescribeBrokerRemovalsResponseData data = new DescribeBrokerRemovalsResponseData().setErrorCode(Errors.NONE.code()).setRemovedBrokers(Arrays.asList(new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(0).setRemovalErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()), new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(1).setRemovalErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()), new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(2).setRemovalErrorCode(Errors.NONE.code()), new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(1).setRemovalErrorCode(Errors.UNKNOWN_SERVER_ERROR.code())));
        Map errorCounts = new DescribeBrokerRemovalsResponse(data).errorCounts();
        Assertions.assertEquals((int)1, (int)errorCounts.size());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)errorCounts.get(Errors.NONE)));
    }
}

