/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.OffsetCommitResponseTest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TxnOffsetCommitResponseTest
extends OffsetCommitResponseTest {
    @Override
    @Test
    public void testConstructorWithErrorResponse() {
        TxnOffsetCommitResponse response = new TxnOffsetCommitResponse(10, this.errorsMap);
        Assertions.assertEquals((Object)this.errorsMap, (Object)response.errors());
        Assertions.assertEquals((Object)this.expectedErrorCounts, (Object)response.errorCounts());
        Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
    }

    @Override
    @Test
    public void testParse() {
        TxnOffsetCommitResponseData data = new TxnOffsetCommitResponseData().setThrottleTimeMs(10).setTopics(Arrays.asList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(this.errorOne.code()))), new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(2).setErrorCode(this.errorTwo.code())))));
        Iterator iterator = ApiKeys.TXN_OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            TxnOffsetCommitResponse response = TxnOffsetCommitResponse.parse((ByteBuffer)MessageUtil.toByteBufferAccessor((Message)data, (short)version).buffer(), (short)version, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals((Object)this.expectedErrorCounts, (Object)response.errorCounts());
            Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
            Assertions.assertEquals((Object)(version >= 1 ? 1 : 0), (Object)response.shouldClientThrottle(version));
        }
    }
}

