/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.resource;

import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceTypeTest {
    private static final AclResourceTypeTestInfo[] INFOS = new AclResourceTypeTestInfo[]{new AclResourceTypeTestInfo(ResourceType.UNKNOWN, 0, "unknown", true), new AclResourceTypeTestInfo(ResourceType.ANY, 1, "any", false), new AclResourceTypeTestInfo(ResourceType.TOPIC, 2, "topic", false), new AclResourceTypeTestInfo(ResourceType.GROUP, 3, "group", false), new AclResourceTypeTestInfo(ResourceType.CLUSTER, 4, "cluster", false), new AclResourceTypeTestInfo(ResourceType.TRANSACTIONAL_ID, 5, "transactional_id", false), new AclResourceTypeTestInfo(ResourceType.DELEGATION_TOKEN, 6, "delegation_token", false), new AclResourceTypeTestInfo(ResourceType.USER, 7, "user", false)};

    @Test
    public void testIsUnknown() {
        for (AclResourceTypeTestInfo info : INFOS) {
            Assertions.assertEquals((Object)info.unknown, (Object)info.resourceType.isUnknown(), (String)(String.valueOf(info.resourceType) + " was supposed to have unknown == " + info.unknown));
        }
    }

    @Test
    public void testCode() {
        Assertions.assertEquals((int)ResourceType.values().length, (int)INFOS.length);
        for (AclResourceTypeTestInfo info : INFOS) {
            Assertions.assertEquals((int)info.code, (int)info.resourceType.code(), (String)(String.valueOf(info.resourceType) + " was supposed to have code == " + info.code));
            Assertions.assertEquals((Object)info.resourceType, (Object)ResourceType.fromCode((byte)((byte)info.code)), (String)("AclResourceType.fromCode(" + info.code + ") was supposed to be " + String.valueOf(info.resourceType)));
        }
        Assertions.assertEquals((Object)ResourceType.UNKNOWN, (Object)ResourceType.fromCode((byte)120));
    }

    @Test
    public void testName() {
        for (AclResourceTypeTestInfo info : INFOS) {
            Assertions.assertEquals((Object)info.resourceType, (Object)ResourceType.fromString((String)info.name), (String)("ResourceType.fromString(" + info.name + ") was supposed to be " + String.valueOf(info.resourceType)));
        }
        Assertions.assertEquals((Object)ResourceType.UNKNOWN, (Object)ResourceType.fromString((String)"something"));
    }

    @Test
    public void testExhaustive() {
        Assertions.assertEquals((int)INFOS.length, (int)ResourceType.values().length);
        for (int i = 0; i < INFOS.length; ++i) {
            Assertions.assertEquals((Object)ResourceTypeTest.INFOS[i].resourceType, (Object)ResourceType.values()[i]);
        }
    }

    private static class AclResourceTypeTestInfo {
        private final ResourceType resourceType;
        private final int code;
        private final String name;
        private final boolean unknown;

        AclResourceTypeTestInfo(ResourceType resourceType, int code, String name, boolean unknown) {
            this.resourceType = resourceType;
            this.code = code;
            this.name = name;
            this.unknown = unknown;
        }
    }
}

