/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Iterator;
import org.apache.kafka.common.utils.FixedOrderMap;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FixedOrderMapTest {
    @Test
    public void shouldMaintainOrderWhenAdding() {
        FixedOrderMap map = new FixedOrderMap();
        map.put((Object)"a", (Object)0);
        map.put((Object)"b", (Object)1);
        map.put((Object)"c", (Object)2);
        map.put((Object)"b", (Object)3);
        Iterator iterator = map.entrySet().iterator();
        Assertions.assertEquals((Object)Utils.mkEntry((Object)"a", (Object)0), iterator.next());
        Assertions.assertEquals((Object)Utils.mkEntry((Object)"b", (Object)3), iterator.next());
        Assertions.assertEquals((Object)Utils.mkEntry((Object)"c", (Object)2), iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldForbidRemove() {
        FixedOrderMap map = new FixedOrderMap();
        map.put((Object)"a", (Object)0);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove((Object)"a"));
        Assertions.assertEquals((int)0, (Integer)((Integer)map.get((Object)"a")));
    }

    @Test
    public void shouldForbidConditionalRemove() {
        FixedOrderMap map = new FixedOrderMap();
        map.put((Object)"a", (Object)0);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove((Object)"a", (Object)0));
        Assertions.assertEquals((int)0, (Integer)((Integer)map.get((Object)"a")));
    }
}

