/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;

public class LogCaptureAppender
extends AbstractAppender
implements AutoCloseable {
    private final List<LogEvent> events = new LinkedList<LogEvent>();
    private final Map<Class<?>, Level> logLevelChanges = new HashMap();
    private final List<org.apache.logging.log4j.core.Logger> loggers = new ArrayList<org.apache.logging.log4j.core.Logger>();

    public LogCaptureAppender() {
        super("LogCaptureAppender-" + String.valueOf(UUID.randomUUID()), null, null, true, Property.EMPTY_ARRAY);
    }

    public static LogCaptureAppender createAndRegister() {
        LogCaptureAppender logCaptureAppender = new LogCaptureAppender();
        Logger logger = LogManager.getRootLogger();
        logCaptureAppender.addToLogger(logger);
        return logCaptureAppender;
    }

    public static LogCaptureAppender createAndRegister(Class<?> clazz) {
        LogCaptureAppender logCaptureAppender = new LogCaptureAppender();
        Logger logger = LogManager.getLogger(clazz);
        logCaptureAppender.addToLogger(logger);
        return logCaptureAppender;
    }

    public void addToLogger(Logger logger) {
        org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)logger;
        this.start();
        coreLogger.addAppender((Appender)this);
        this.loggers.add(coreLogger);
    }

    public void setClassLogger(Class<?> clazz, Level level) {
        if (!this.logLevelChanges.containsKey(clazz)) {
            Level currentLevel = LogManager.getLogger(clazz).getLevel();
            this.logLevelChanges.put(clazz, currentLevel);
        }
        Configurator.setLevel((String)clazz.getName(), (Level)level);
    }

    public void setClassLogger(String clazzName, Level level) {
        Logger logger = LogManager.getLogger((String)clazzName);
        if (!this.logLevelChanges.containsKey(logger.getClass())) {
            Level currentLevel = logger.getLevel();
            this.logLevelChanges.put(logger.getClass(), currentLevel);
        }
        Configurator.setLevel((String)clazzName, (Level)level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.add(event.toImmutable());
        }
    }

    public List<String> getMessages(String level) {
        return this.getEvents().stream().filter(e -> level.equals(e.getLevel())).map(Event::getMessage).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessages() {
        LinkedList<String> result = new LinkedList<String>();
        List<LogEvent> list = this.events;
        synchronized (list) {
            for (LogEvent event : this.events) {
                result.add(event.getMessage().getFormattedMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> getEvents() {
        LinkedList<Event> result = new LinkedList<Event>();
        List<LogEvent> list = this.events;
        synchronized (list) {
            for (LogEvent event : this.events) {
                Optional<String> throwableClassName;
                Optional<String> throwableString;
                Throwable throwable = event.getThrown();
                if (throwable == null) {
                    throwableString = Optional.empty();
                    throwableClassName = Optional.empty();
                } else {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    throwableString = Optional.of(stringWriter.toString());
                    throwableClassName = Optional.of(throwable.getClass().getName());
                }
                result.add(new Event(event.getLevel().toString(), event.getMessage().getFormattedMessage(), throwableString, throwableClassName, event.getThreadName()));
            }
        }
        return result;
    }

    @Override
    public void close() {
        for (Map.Entry<Class<?>, Level> entry : this.logLevelChanges.entrySet()) {
            Class<?> clazz = entry.getKey();
            Level originalLevel = entry.getValue();
            Configurator.setLevel((String)clazz.getName(), (Level)originalLevel);
        }
        this.logLevelChanges.clear();
        this.unregister();
    }

    public void unregister() {
        for (org.apache.logging.log4j.core.Logger logger : this.loggers) {
            logger.removeAppender((Appender)this);
        }
        this.loggers.clear();
        this.stop();
    }

    public static class Event {
        private final String level;
        private final String message;
        private final Optional<String> throwableInfo;
        private final Optional<String> throwableClassName;
        private final String threadName;

        Event(String level, String message, Optional<String> throwableInfo, Optional<String> throwableClassName, String threadName) {
            this.level = level;
            this.message = message;
            this.throwableInfo = throwableInfo;
            this.throwableClassName = throwableClassName;
            this.threadName = threadName;
        }

        public String getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Optional<String> getThrowableInfo() {
            return this.throwableInfo;
        }

        public Optional<String> getThrowableClassName() {
            return this.throwableClassName;
        }

        public String getThreadName() {
            return this.threadName;
        }
    }
}

