/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.authorizer;

import java.util.Optional;
import org.apache.kafka.server.authorizer.AuthorizerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AuthorizerConfigTest {
    @Test
    public void testDefaultMaxAcls() {
        AuthorizerConfig config = new AuthorizerConfig();
        Assertions.assertEquals((int)1000, (int)config.defaultMaxAcls());
        config.setDefaultMaxAcls(Integer.valueOf(2000));
        Assertions.assertEquals((int)2000, (int)config.defaultMaxAcls());
        config.setDefaultMaxAcls(null);
        Assertions.assertEquals((int)1000, (int)config.defaultMaxAcls());
    }

    @Test
    public void testMaxAcls() {
        AuthorizerConfig config = new AuthorizerConfig();
        String tenantId = "lkc-abcd";
        Assertions.assertEquals((int)1000, (int)config.maxAcls(tenantId));
        config.setDefaultMaxAcls(Integer.valueOf(2000));
        Assertions.assertEquals((int)2000, (int)config.maxAcls(tenantId));
        config.setTenantMaxAcls(Optional.of(tenantId), Optional.of(3000));
        Assertions.assertEquals((int)3000, (int)config.maxAcls(tenantId));
        String secondTenantId = "lkc-xyz";
        Assertions.assertEquals((int)2000, (int)config.maxAcls(secondTenantId));
        config.setTenantMaxAcls(Optional.of(tenantId), Optional.empty());
        Assertions.assertEquals((int)2000, (int)config.maxAcls(tenantId));
        Assertions.assertEquals((int)2000, (int)config.maxAcls(secondTenantId));
        config.setTenantMaxAcls(Optional.empty(), Optional.of(5000));
        Assertions.assertEquals((int)5000, (int)config.maxAcls(tenantId));
        Assertions.assertEquals((int)5000, (int)config.maxAcls(secondTenantId));
        config.setTenantMaxAcls(Optional.empty(), Optional.empty());
        Assertions.assertEquals((int)2000, (int)config.maxAcls(tenantId));
        Assertions.assertEquals((int)2000, (int)config.maxAcls(secondTenantId));
    }
}

