/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.opentest4j.TestAbortedException;

public class ConditionalSkipExtension
implements BeforeTestExecutionCallback {
    private static final String CONFIG_PATH = "/build-tune-scripts/bt-config.json";
    private static final String ARCH = System.getProperty("os.arch").contains("arm") || System.getProperty("os.arch").contains("aarch64") ? "master-arm64" : "master-x86";
    private static Set<String> disabledTests;

    public ConditionalSkipExtension() {
        try {
            InputStream inputStream = ConditionalSkipExtension.class.getResourceAsStream(CONFIG_PATH);
            if (inputStream == null) {
                throw new RuntimeException("Resource bt-config.json not found");
            }
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<Map<String, Map<String, List<String>>>> typeRef = new TypeReference<Map<String, Map<String, List<String>>>>(){};
            Map config = (Map)mapper.readValue(inputStream, (TypeReference)typeRef);
            disabledTests = new HashSet<String>((Collection)((Map)config.get("disabledTests")).get(ARCH));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read config file", e);
        }
    }

    public void beforeTestExecution(ExtensionContext context) throws TestAbortedException {
        Optional testMethod = context.getTestMethod();
        Object displayName = context.getDisplayName();
        if (testMethod.isPresent() ? disabledTests.contains(displayName = ((Class)context.getTestClass().get()).getName() + "#" + (String)displayName) : context.getTestClass().isPresent() && disabledTests.contains(displayName = ((Class)context.getTestClass().get()).getName())) {
            throw new TestAbortedException("Test skipped based on config: " + (String)displayName);
        }
    }
}

