/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class RequestHeaderData
implements ApiMessage {
    short requestApiKey;
    short requestApiVersion;
    int correlationId;
    String clientId;
    Uuid clusterLinkId;
    TraceContext traceContext;
    String clusterLinkTenant;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field("request_api_key", Type.INT16, "The API key of this request."), new Field("request_api_version", Type.INT16, "The API version of this request."), new Field("correlation_id", Type.INT32, "The correlation ID of this request."), new Field("client_id", Type.NULLABLE_STRING, "The client ID string."));
    public static final Schema SCHEMA_2 = new Schema(new Field("request_api_key", Type.INT16, "The API key of this request."), new Field("request_api_version", Type.INT16, "The API version of this request."), new Field("correlation_id", Type.INT32, "The correlation ID of this request."), new Field("client_id", Type.NULLABLE_STRING, "The client ID string."), Field.TaggedFieldsSection.of(10000, new Field("cluster_link_id", Type.UUID, "Cluster link ID if this request was sent on a cluster link."), 10001, new Field("trace_context", TraceContext.SCHEMA_2, ""), 10002, new Field("cluster_link_tenant", Type.COMPACT_NULLABLE_STRING, "Tenant associated with cluster link if this request was sent on behalf of a cluster link by a broker. Should only be used for requests from broker to KRaft controller.")));
    public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 1;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public RequestHeaderData(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public RequestHeaderData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public RequestHeaderData() {
        this.requestApiKey = 0;
        this.requestApiVersion = 0;
        this.correlationId = 0;
        this.clientId = "";
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.traceContext = new TraceContext();
        this.clusterLinkTenant = "";
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 1;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.requestApiKey = _readable.readShort();
        this.requestApiVersion = _readable.readShort();
        this.correlationId = _readable.readInt();
        short length = _readable.readShort();
        if (length < 0) {
            this.clientId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientId had invalid length " + length);
            }
            this.clientId = _readable.readString(length);
        }
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.traceContext = new TraceContext();
        this.clusterLinkTenant = "";
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        this.clusterLinkId = _readable.readUuid();
                        continue block5;
                    }
                    case 10001: {
                        this.traceContext = new TraceContext(_readable, _version, _context);
                        continue block5;
                    }
                    case 10002: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.clusterLinkTenant = null;
                            continue block5;
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field clusterLinkTenant had invalid length " + length2);
                        }
                        this.clusterLinkTenant = _readable.readString(length2);
                        continue block5;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.requestApiKey);
        _writable.writeShort(this.requestApiVersion);
        _writable.writeInt(this.correlationId);
        if (this.clientId == null) {
            _writable.writeShort((short)-1);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(this.clientId);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        if (_version >= 2 && !this.clusterLinkId.equals(Uuid.ZERO_UUID)) {
            ++_numTaggedFields;
        }
        if (_version >= 2 && !this.traceContext.equals(new TraceContext())) {
            ++_numTaggedFields;
        }
        if (_version >= 2) {
            if (this.clusterLinkTenant == null || !this.clusterLinkTenant.equals("")) {
                ++_numTaggedFields;
            }
        } else if (this.clusterLinkTenant == null || !this.clusterLinkTenant.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterLinkTenant at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.clusterLinkId.equals(Uuid.ZERO_UUID)) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(16);
                _writable.writeUuid(this.clusterLinkId);
            }
            if (!this.traceContext.equals(new TraceContext())) {
                _writable.writeUnsignedVarint(10001);
                _writable.writeUnsignedVarint(this.traceContext.size(_cache, _version, _context));
                this.traceContext.write(_writable, _cache, _version, _context);
            }
            if (this.clusterLinkTenant == null) {
                _writable.writeUnsignedVarint(10002);
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(0);
            } else if (!this.clusterLinkTenant.equals("")) {
                _writable.writeUnsignedVarint(10002);
                byte[] _stringBytes = _cache.getSerializedValue(this.clusterLinkTenant);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(2);
        _size.addBytes(2);
        _size.addBytes(4);
        if (this.clientId == null) {
            _size.addBytes(2);
        } else {
            _stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clientId, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        if (_version >= 2 && !this.clusterLinkId.equals(Uuid.ZERO_UUID)) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(16);
        }
        if (_version >= 2 && !this.traceContext.equals(new TraceContext())) {
            ++_numTaggedFields;
            _size.addBytes(2);
            int _sizeBeforeStruct = _size.totalSize();
            this.traceContext.addSize(_size, _cache, _version, _context);
            int _structSize = _size.totalSize() - _sizeBeforeStruct;
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_structSize));
        }
        if (_version >= 2) {
            if (this.clusterLinkTenant == null) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _size.addBytes(1);
                _size.addBytes(1);
            } else if (!this.clusterLinkTenant.equals("")) {
                ++_numTaggedFields;
                _size.addBytes(2);
                _stringBytes = this.clusterLinkTenant.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterLinkTenant' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterLinkTenant, _stringBytes);
                int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestHeaderData)) {
            return false;
        }
        RequestHeaderData other = (RequestHeaderData)obj;
        if (this.requestApiKey != other.requestApiKey) {
            return false;
        }
        if (this.requestApiVersion != other.requestApiVersion) {
            return false;
        }
        if (this.correlationId != other.correlationId) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (!this.clusterLinkId.equals(other.clusterLinkId)) {
            return false;
        }
        if (this.traceContext == null ? other.traceContext != null : !this.traceContext.equals(other.traceContext)) {
            return false;
        }
        if (this.clusterLinkTenant == null ? other.clusterLinkTenant != null : !this.clusterLinkTenant.equals(other.clusterLinkTenant)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.requestApiKey;
        hashCode = 31 * hashCode + this.requestApiVersion;
        hashCode = 31 * hashCode + this.correlationId;
        hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.traceContext == null ? 0 : this.traceContext.hashCode());
        hashCode = 31 * hashCode + (this.clusterLinkTenant == null ? 0 : this.clusterLinkTenant.hashCode());
        return hashCode;
    }

    @Override
    public RequestHeaderData duplicate() {
        RequestHeaderData _duplicate = new RequestHeaderData();
        _duplicate.requestApiKey = this.requestApiKey;
        _duplicate.requestApiVersion = this.requestApiVersion;
        _duplicate.correlationId = this.correlationId;
        _duplicate.clientId = this.clientId == null ? null : this.clientId;
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.traceContext = this.traceContext.duplicate();
        _duplicate.clusterLinkTenant = this.clusterLinkTenant == null ? null : this.clusterLinkTenant;
        return _duplicate;
    }

    public String toString() {
        return "RequestHeaderData(requestApiKey=" + this.requestApiKey + ", requestApiVersion=" + this.requestApiVersion + ", correlationId=" + this.correlationId + ", clientId=" + (String)(this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clusterLinkId=" + this.clusterLinkId.toString() + ", traceContext=" + this.traceContext.toString() + ", clusterLinkTenant=" + (String)(this.clusterLinkTenant == null ? "null" : "'" + this.clusterLinkTenant.toString() + "'") + ")";
    }

    public short requestApiKey() {
        return this.requestApiKey;
    }

    public short requestApiVersion() {
        return this.requestApiVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public TraceContext traceContext() {
        return this.traceContext;
    }

    public String clusterLinkTenant() {
        return this.clusterLinkTenant;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RequestHeaderData setRequestApiKey(short v) {
        this.requestApiKey = v;
        return this;
    }

    public RequestHeaderData setRequestApiVersion(short v) {
        this.requestApiVersion = v;
        return this;
    }

    public RequestHeaderData setCorrelationId(int v) {
        this.correlationId = v;
        return this;
    }

    public RequestHeaderData setClientId(String v) {
        this.clientId = v;
        return this;
    }

    public RequestHeaderData setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public RequestHeaderData setTraceContext(TraceContext v) {
        this.traceContext = v;
        return this;
    }

    public RequestHeaderData setClusterLinkTenant(String v) {
        this.clusterLinkTenant = v;
        return this;
    }

    public static class TraceContext
    implements Message {
        byte[] traceId;
        byte[] parentSpanId;
        byte traceFlags;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field("trace_id", Type.COMPACT_BYTES, "Trace Id to identify the trace"), new Field("parent_span_id", Type.COMPACT_BYTES, "The span id when the request was generated"), new Field("trace_flags", Type.INT8, "Trace flags for spans. This has the same struct as the w3c trace flags"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public TraceContext(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TraceContext() {
            this.traceId = Bytes.EMPTY;
            this.parentSpanId = Bytes.EMPTY;
            this.traceFlags = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TraceContext");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field traceId was serialized as null");
            }
            byte[] newBytes = _readable.readArray(length);
            this.traceId = newBytes;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field parentSpanId was serialized as null");
            }
            newBytes = _readable.readArray(length);
            this.parentSpanId = newBytes;
            this.traceFlags = _readable.readByte();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TraceContext");
            }
            int _numTaggedFields = 0;
            _writable.writeUnsignedVarint(this.traceId.length + 1);
            _writable.writeByteArray(this.traceId);
            _writable.writeUnsignedVarint(this.parentSpanId.length + 1);
            _writable.writeByteArray(this.parentSpanId);
            _writable.writeByte(this.traceFlags);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TraceContext");
            }
            _size.addBytes(this.traceId.length);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.traceId.length + 1));
            _size.addBytes(this.parentSpanId.length);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.parentSpanId.length + 1));
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TraceContext)) {
                return false;
            }
            TraceContext other = (TraceContext)obj;
            if (!Arrays.equals(this.traceId, other.traceId)) {
                return false;
            }
            if (!Arrays.equals(this.parentSpanId, other.parentSpanId)) {
                return false;
            }
            if (this.traceFlags != other.traceFlags) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + Arrays.hashCode(this.traceId);
            hashCode = 31 * hashCode + Arrays.hashCode(this.parentSpanId);
            hashCode = 31 * hashCode + this.traceFlags;
            return hashCode;
        }

        @Override
        public TraceContext duplicate() {
            TraceContext _duplicate = new TraceContext();
            _duplicate.traceId = MessageUtil.duplicate(this.traceId);
            _duplicate.parentSpanId = MessageUtil.duplicate(this.parentSpanId);
            _duplicate.traceFlags = this.traceFlags;
            return _duplicate;
        }

        public String toString() {
            return "TraceContext(traceId=" + Arrays.toString(this.traceId) + ", parentSpanId=" + Arrays.toString(this.parentSpanId) + ", traceFlags=" + this.traceFlags + ")";
        }

        public byte[] traceId() {
            return this.traceId;
        }

        public byte[] parentSpanId() {
            return this.parentSpanId;
        }

        public byte traceFlags() {
            return this.traceFlags;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TraceContext setTraceId(byte[] v) {
            this.traceId = v;
            return this;
        }

        public TraceContext setParentSpanId(byte[] v) {
            this.parentSpanId = v;
            return this;
        }

        public TraceContext setTraceFlags(byte v) {
            this.traceFlags = v;
            return this;
        }
    }
}

