/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import io.confluent.kafka.security.oauthbearer.HttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.HttpRequestFormatterFactory;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.FileTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;

public class AccessTokenRetrieverFactory {
    public static AccessTokenRetriever create(Map<String, ?> configs, Map<String, Object> jaasConfig) {
        return AccessTokenRetrieverFactory.create(configs, null, jaasConfig);
    }

    public static AccessTokenRetriever create(Map<String, ?> configs, String saslMechanism, Map<String, Object> jaasConfig) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        URL tokenEndpointUrl = cu.validateUrl("sasl.oauthbearer.token.endpoint.url");
        if (tokenEndpointUrl.getProtocol().toLowerCase(Locale.ROOT).equals("file")) {
            return new FileTokenRetriever(cu.validateFile("sasl.oauthbearer.token.endpoint.url"));
        }
        JaasOptionsUtils jou = new JaasOptionsUtils(jaasConfig);
        HttpRequestFormatter httpRequestFormatter = HttpRequestFormatterFactory.create(cu, jou);
        String scope = jou.validateString("scope", false);
        SSLSocketFactory sslSocketFactory = null;
        if (jou.shouldCreateSSLSocketFactory(tokenEndpointUrl)) {
            sslSocketFactory = jou.createSSLSocketFactory();
        }
        return new HttpAccessTokenRetriever(httpRequestFormatter, scope, sslSocketFactory, tokenEndpointUrl.toString(), cu.validateLong("sasl.login.retry.backoff.ms"), cu.validateLong("sasl.login.retry.backoff.max.ms"), cu.validateInteger("sasl.login.connect.timeout.ms", false), cu.validateInteger("sasl.login.read.timeout.ms", false));
    }
}

