/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.authorizer;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class AuthorizerConfig {
    private static final int DEFAULT_MAX_ACLS_PER_TENANT_PROP = 1000;
    private Optional<Integer> tenantDefaultMaxAcls = Optional.empty();
    private int defaultMaxAcls = 1000;
    private Map<String, Integer> tenantIdToMaxAcls = new ConcurrentHashMap<String, Integer>();

    public void setTenantMaxAcls(Optional<String> tenantIdOpt, Optional<Integer> maxAcls) {
        if (tenantIdOpt.isPresent()) {
            if (maxAcls.isPresent()) {
                this.tenantIdToMaxAcls.put(tenantIdOpt.get(), maxAcls.get());
            } else {
                this.tenantIdToMaxAcls.remove(tenantIdOpt.get());
            }
        } else {
            this.tenantDefaultMaxAcls = maxAcls;
        }
    }

    public void setDefaultMaxAcls(Integer maxAcls) {
        this.defaultMaxAcls = maxAcls == null ? 1000 : maxAcls;
    }

    public int defaultMaxAcls() {
        return this.defaultMaxAcls;
    }

    public int maxAcls(String tenantId) {
        if (tenantId == null) {
            return this.defaultMaxAcls;
        }
        return this.tenantIdToMaxAcls.getOrDefault(tenantId, this.tenantDefaultMaxAcls.orElse(this.defaultMaxAcls));
    }
}

