/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security;

import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class PrivateKeyUtils {
    public static KeyPair getRsaKeyPair() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        return keyPairGenerator.generateKeyPair();
    }

    public static String getPkcs1PemKey(KeyPair keyPair) throws Exception {
        StringWriter stringWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
            pemWriter.writeObject((Object)keyPair);
        }
        return stringWriter.toString();
    }
}

