/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.DeleteRecordsHandler;
import org.apache.kafka.clients.admin.internals.PartitionLeaderStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteRecordsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final int timeout = 2000;
    private final TopicPartition t0p0 = new TopicPartition("t0", 0);
    private final TopicPartition t0p1 = new TopicPartition("t0", 1);
    private final TopicPartition t0p2 = new TopicPartition("t0", 2);
    private final TopicPartition t0p3 = new TopicPartition("t0", 3);
    private final Node node1 = new Node(1, "host", 1234);
    private final Node node2 = new Node(2, "host", 1235);
    private final Map<TopicPartition, RecordsToDelete> recordsToDelete = Map.of(this.t0p0, RecordsToDelete.beforeOffset((long)10L), this.t0p1, RecordsToDelete.beforeOffset((long)10L), this.t0p2, RecordsToDelete.beforeOffset((long)10L), this.t0p3, RecordsToDelete.beforeOffset((long)10L));

    @Test
    public void testBuildRequestSimple() {
        DeleteRecordsHandler handler = new DeleteRecordsHandler(this.recordsToDelete, this.logContext, 2000);
        DeleteRecordsRequest request = (DeleteRecordsRequest)handler.buildBatchedRequest(this.node1.id(), Set.of(this.t0p0, this.t0p1)).build();
        List topics = request.data().topics();
        Assertions.assertEquals((int)1, (int)topics.size());
        DeleteRecordsRequestData.DeleteRecordsTopic topic = (DeleteRecordsRequestData.DeleteRecordsTopic)topics.get(0);
        Assertions.assertEquals((int)2, (int)topic.partitions().size());
    }

    @Test
    public void testHandleSuccessfulResponse() {
        AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> result = this.handleResponse(this.createResponse(Collections.emptyMap(), this.recordsToDelete.keySet()));
        this.assertResult(result, this.recordsToDelete.keySet(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
    }

    @Test
    public void testHandleRetriablePartitionTimeoutResponse() {
        TopicPartition errorPartition = this.t0p0;
        HashMap<TopicPartition, Short> errorsByPartition = new HashMap<TopicPartition, Short>();
        errorsByPartition.put(errorPartition, Errors.REQUEST_TIMED_OUT.code());
        AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> result = this.handleResponse(this.createResponse(errorsByPartition));
        Set<TopicPartition> retriable = Collections.singleton(errorPartition);
        HashSet<TopicPartition> completed = new HashSet<TopicPartition>(this.recordsToDelete.keySet());
        completed.removeAll(retriable);
        this.assertResult(result, completed, Collections.emptyMap(), Collections.emptyList(), retriable);
    }

    @Test
    public void testHandleLookupRetriablePartitionInvalidMetadataResponse() {
        TopicPartition errorPartition = this.t0p0;
        Errors error = Errors.NOT_LEADER_OR_FOLLOWER;
        HashMap<TopicPartition, Short> errorsByPartition = new HashMap<TopicPartition, Short>();
        errorsByPartition.put(errorPartition, error.code());
        AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> result = this.handleResponse(this.createResponse(errorsByPartition));
        ArrayList<TopicPartition> unmapped = new ArrayList<TopicPartition>();
        unmapped.add(errorPartition);
        HashSet<TopicPartition> completed = new HashSet<TopicPartition>(this.recordsToDelete.keySet());
        completed.removeAll(unmapped);
        this.assertResult(result, completed, Collections.emptyMap(), unmapped, Collections.emptySet());
    }

    @Test
    public void testHandlePartitionErrorResponse() {
        TopicPartition errorPartition = this.t0p0;
        Errors error = Errors.TOPIC_AUTHORIZATION_FAILED;
        HashMap<TopicPartition, Short> errorsByPartition = new HashMap<TopicPartition, Short>();
        errorsByPartition.put(errorPartition, error.code());
        AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> result = this.handleResponse(this.createResponse(errorsByPartition));
        HashMap<TopicPartition, Throwable> failed = new HashMap<TopicPartition, Throwable>();
        failed.put(errorPartition, (Throwable)error.exception());
        HashSet<TopicPartition> completed = new HashSet<TopicPartition>(this.recordsToDelete.keySet());
        completed.removeAll(failed.keySet());
        this.assertResult(result, completed, failed, Collections.emptyList(), Collections.emptySet());
    }

    @Test
    public void testHandleUnexpectedPartitionErrorResponse() {
        TopicPartition errorPartition = this.t0p0;
        Errors error = Errors.UNKNOWN_SERVER_ERROR;
        HashMap<TopicPartition, Short> errorsByPartition = new HashMap<TopicPartition, Short>();
        errorsByPartition.put(errorPartition, error.code());
        AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> result = this.handleResponse(this.createResponse(errorsByPartition));
        HashMap<TopicPartition, Throwable> failed = new HashMap<TopicPartition, Throwable>();
        failed.put(errorPartition, (Throwable)error.exception());
        HashSet<TopicPartition> completed = new HashSet<TopicPartition>(this.recordsToDelete.keySet());
        completed.removeAll(failed.keySet());
        this.assertResult(result, completed, failed, Collections.emptyList(), Collections.emptySet());
    }

    @Test
    public void testMixedResponse() {
        HashMap<TopicPartition, Short> errorsByPartition = new HashMap<TopicPartition, Short>();
        TopicPartition errorPartition = this.t0p0;
        Errors error = Errors.UNKNOWN_SERVER_ERROR;
        errorsByPartition.put(errorPartition, error.code());
        TopicPartition retriableErrorPartition = this.t0p1;
        Errors retriableError = Errors.NOT_LEADER_OR_FOLLOWER;
        errorsByPartition.put(retriableErrorPartition, retriableError.code());
        TopicPartition retriableErrorPartition2 = this.t0p2;
        Errors retriableError2 = Errors.REQUEST_TIMED_OUT;
        errorsByPartition.put(retriableErrorPartition2, retriableError2.code());
        AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> result = this.handleResponse(this.createResponse(errorsByPartition));
        HashSet<TopicPartition> completed = new HashSet<TopicPartition>(this.recordsToDelete.keySet());
        HashMap<TopicPartition, Throwable> failed = new HashMap<TopicPartition, Throwable>();
        failed.put(errorPartition, (Throwable)error.exception());
        completed.removeAll(failed.keySet());
        ArrayList<TopicPartition> unmapped = new ArrayList<TopicPartition>();
        unmapped.add(retriableErrorPartition);
        completed.removeAll(unmapped);
        Set<TopicPartition> retriable = Collections.singleton(retriableErrorPartition2);
        completed.removeAll(retriable);
        this.assertResult(result, completed, failed, unmapped, retriable);
    }

    @Test
    public void testHandleResponseSanityCheck() {
        TopicPartition errorPartition = this.t0p0;
        HashMap<TopicPartition, RecordsToDelete> recordsToDeleteMap = new HashMap<TopicPartition, RecordsToDelete>(this.recordsToDelete);
        recordsToDeleteMap.remove(errorPartition);
        AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> result = this.handleResponse(this.createResponse(Collections.emptyMap(), recordsToDeleteMap.keySet()));
        Assertions.assertEquals((int)(this.recordsToDelete.size() - 1), (int)result.completedKeys.size());
        Assertions.assertEquals((int)1, (int)result.failedKeys.size());
        Assertions.assertEquals((Object)errorPartition, result.failedKeys.keySet().iterator().next());
        String sanityCheckMessage = ((Throwable)result.failedKeys.get(errorPartition)).getMessage();
        Assertions.assertTrue((boolean)sanityCheckMessage.contains("did not contain a result for topic partition"));
        Assertions.assertTrue((boolean)result.unmappedKeys.isEmpty());
    }

    @Test
    public void testBuildRequestMultipleLeaders() {
        MetadataResponseData metadataResponseData = new MetadataResponseData();
        MetadataResponseData.MetadataResponseTopic topicMetadata = new MetadataResponseData.MetadataResponseTopic();
        topicMetadata.setName("t0").setErrorCode(Errors.NONE.code());
        topicMetadata.partitions().add(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(0).setLeaderId(this.node1.id()).setErrorCode(Errors.NONE.code()));
        topicMetadata.partitions().add(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(1).setLeaderId(this.node2.id()).setErrorCode(Errors.NONE.code()));
        topicMetadata.partitions().add(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(2).setLeaderId(this.node1.id()).setErrorCode(Errors.NONE.code()));
        topicMetadata.partitions().add(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(3).setLeaderId(this.node2.id()).setErrorCode(Errors.NONE.code()));
        metadataResponseData.topics().add((ImplicitLinkedHashCollection.Element)topicMetadata);
        MetadataResponse metadataResponse = new MetadataResponse(metadataResponseData, ApiKeys.METADATA.latestVersion());
        DeleteRecordsHandler handler = new DeleteRecordsHandler(this.recordsToDelete, this.logContext, 2000);
        AdminApiLookupStrategy strategy = handler.lookupStrategy();
        Assertions.assertInstanceOf(PartitionLeaderStrategy.class, (Object)strategy);
        PartitionLeaderStrategy specificStrategy = (PartitionLeaderStrategy)strategy;
        MetadataRequest request = (MetadataRequest)specificStrategy.buildRequest(Set.of(this.t0p0, this.t0p1, this.t0p2, this.t0p3)).build();
        Assertions.assertEquals(Set.of("t0"), new HashSet(request.topics()));
        Set<TopicPartition> tpSet = Set.of(this.t0p0, this.t0p1, this.t0p2, this.t0p3);
        AdminApiLookupStrategy.LookupResult lookupResult = strategy.handleResponse(tpSet, (AbstractResponse)metadataResponse);
        Assertions.assertEquals(Collections.emptyMap(), (Object)lookupResult.failedKeys);
        Assertions.assertEquals(tpSet, lookupResult.mappedKeys.keySet());
        HashMap partitionsPerBroker = new HashMap();
        lookupResult.mappedKeys.forEach((tp, node) -> partitionsPerBroker.computeIfAbsent(node, key -> new HashSet()).add(tp));
        DeleteRecordsRequest deleteRequest = (DeleteRecordsRequest)handler.buildBatchedRequest(this.node1.id(), (Set)partitionsPerBroker.get(this.node1.id())).build();
        Assertions.assertEquals((int)2, (int)((DeleteRecordsRequestData.DeleteRecordsTopic)deleteRequest.data().topics().get(0)).partitions().size());
        Assertions.assertEquals(Set.of(this.t0p0, this.t0p2), ((DeleteRecordsRequestData.DeleteRecordsTopic)deleteRequest.data().topics().get(0)).partitions().stream().map(drp -> new TopicPartition("t0", drp.partitionIndex())).collect(Collectors.toSet()));
        deleteRequest = (DeleteRecordsRequest)handler.buildBatchedRequest(this.node2.id(), (Set)partitionsPerBroker.get(this.node2.id())).build();
        Assertions.assertEquals((int)2, (int)((DeleteRecordsRequestData.DeleteRecordsTopic)deleteRequest.data().topics().get(0)).partitions().size());
        Assertions.assertEquals(Set.of(this.t0p1, this.t0p3), ((DeleteRecordsRequestData.DeleteRecordsTopic)deleteRequest.data().topics().get(0)).partitions().stream().map(drp -> new TopicPartition("t0", drp.partitionIndex())).collect(Collectors.toSet()));
    }

    private DeleteRecordsResponse createResponse(Map<TopicPartition, Short> errorsByPartition) {
        return this.createResponse(errorsByPartition, this.recordsToDelete.keySet());
    }

    private DeleteRecordsResponse createResponse(Map<TopicPartition, Short> errorsByPartition, Set<TopicPartition> topicPartitions) {
        HashMap<String, DeleteRecordsResponseData.DeleteRecordsTopicResultCollection> responsesByTopic = new HashMap<String, DeleteRecordsResponseData.DeleteRecordsTopicResultCollection>();
        DeleteRecordsResponseData.DeleteRecordsTopicResultCollection topicResponse = null;
        for (TopicPartition topicPartition : topicPartitions) {
            topicResponse = responsesByTopic.computeIfAbsent(topicPartition.topic(), t -> new DeleteRecordsResponseData.DeleteRecordsTopicResultCollection());
            topicResponse.add((ImplicitLinkedHashCollection.Element)new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(topicPartition.topic()));
            DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResponse = new DeleteRecordsResponseData.DeleteRecordsPartitionResult();
            partitionResponse.setPartitionIndex(topicPartition.partition());
            partitionResponse.setErrorCode(errorsByPartition.getOrDefault(topicPartition, (short)0).shortValue());
            topicResponse.find(topicPartition.topic()).partitions().add((ImplicitLinkedHashCollection.Element)partitionResponse);
        }
        DeleteRecordsResponseData responseData = new DeleteRecordsResponseData();
        responseData.setTopics(topicResponse);
        return new DeleteRecordsResponse(responseData);
    }

    private AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> handleResponse(DeleteRecordsResponse response) {
        DeleteRecordsHandler handler = new DeleteRecordsHandler(this.recordsToDelete, this.logContext, 2000);
        return handler.handleResponse(this.node1, this.recordsToDelete.keySet(), (AbstractResponse)response);
    }

    private void assertResult(AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> result, Set<TopicPartition> expectedCompleted, Map<TopicPartition, Throwable> expectedFailed, List<TopicPartition> expectedUnmapped, Set<TopicPartition> expectedRetriable) {
        Assertions.assertEquals(expectedCompleted, result.completedKeys.keySet());
        Assertions.assertEquals(expectedFailed, (Object)result.failedKeys);
        Assertions.assertEquals(expectedUnmapped, (Object)result.unmappedKeys);
        HashSet<TopicPartition> actualRetriable = new HashSet<TopicPartition>(this.recordsToDelete.keySet());
        actualRetriable.removeAll(result.completedKeys.keySet());
        actualRetriable.removeAll(result.failedKeys.keySet());
        actualRetriable.removeAll(new HashSet(result.unmappedKeys));
        Assertions.assertEquals(expectedRetriable, actualRetriable);
    }
}

