/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import org.apache.kafka.common.message.SimpleRecordsMessageData;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.MemoryRecords;

public class SimpleRecordsMessageDataJsonConverter {
    public static SimpleRecordsMessageData read(JsonNode _node, short _version) {
        SimpleRecordsMessageData _object = new SimpleRecordsMessageData();
        JsonNode _topicNode = _node.get("topic");
        if (_topicNode == null) {
            throw new RuntimeException("SimpleRecordsMessageData: unable to locate field 'topic', which is mandatory in version " + _version);
        }
        if (!_topicNode.isTextual()) {
            throw new RuntimeException("SimpleRecordsMessageData expected a string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.topic = _topicNode.asText();
        JsonNode _recordSetNode = _node.get("recordSet");
        if (_recordSetNode == null) {
            throw new RuntimeException("SimpleRecordsMessageData: unable to locate field 'recordSet', which is mandatory in version " + _version);
        }
        _object.recordSet = _recordSetNode.isNull() ? null : MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.wrap(MessageUtil.jsonNodeToBinary((JsonNode)_recordSetNode, (String)"SimpleRecordsMessageData")));
        return _object;
    }

    public static JsonNode write(SimpleRecordsMessageData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("topic", (JsonNode)new TextNode(_object.topic));
        if (_object.recordSet == null) {
            _node.set("recordSet", (JsonNode)NullNode.instance);
        } else if (_serializeRecords) {
            _node.set("recordSet", (JsonNode)new BinaryNode(new byte[0]));
        } else {
            _node.set("recordSetSizeInBytes", (JsonNode)new IntNode(_object.recordSet.sizeInBytes()));
        }
        return _node;
    }

    public static JsonNode write(SimpleRecordsMessageData _object, short _version) {
        return SimpleRecordsMessageDataJsonConverter.write(_object, _version, true);
    }
}

