/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.network.netty.DisableSsl;
import org.apache.kafka.common.network.netty.NettyClient;
import org.apache.kafka.common.network.netty.NettyClientTestBase;
import org.apache.kafka.common.network.netty.NettyHttp2Connection;
import org.apache.kafka.common.network.netty.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NettyClientInitializerTest
extends NettyClientTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelHasAppropriateHandlers() throws Exception {
        SslContext sslContext = NettyClientInitializerTest.acceptAllSslContext();
        NettyHttp2Connection connection = null;
        try {
            NettyClient client = new NettyClient(sslContext, this.eventLoopGroup, logContext);
            NettyHttp2Connection finalConnection = connection = (NettyHttp2Connection)client.createConnection(NettyClientInitializerTest.serverAddress(), Integer.valueOf(0x100000), Integer.valueOf(0x100000)).get();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> TestUtils.handlers(finalConnection.channel()).size() == 3, "Channel has unexpected number of handlers");
            List<ChannelHandler> handlers = TestUtils.handlers(finalConnection.channel());
            this.verifyChannelHasHandler(handlers, SslHandler.class);
            this.verifyChannelHasHandler(handlers, Http2FrameCodec.class);
            this.verifyChannelHasHandler(handlers, Http2MultiplexHandler.class);
        }
        finally {
            if (connection != null) {
                connection.close().get(10L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DisableSsl
    @Test
    public void testChannelSkipsAlpnHandlerIfPlainText() throws Exception {
        NettyHttp2Connection connection = null;
        try {
            NettyClient client = new NettyClient(null, this.eventLoopGroup, logContext);
            NettyHttp2Connection finalConnection = connection = (NettyHttp2Connection)client.createConnection(NettyClientInitializerTest.serverAddress(), Integer.valueOf(0x100000), Integer.valueOf(0x100000)).get();
            org.apache.kafka.test.TestUtils.waitForCondition(() -> TestUtils.handlers(finalConnection.channel()).size() == 2, "Channel has unexpected number of handlers");
            List<ChannelHandler> handlers = TestUtils.handlers(finalConnection.channel());
            boolean alpnHandlerPresent = handlers.stream().anyMatch(handler -> handler instanceof ApplicationProtocolNegotiationHandler);
            Assertions.assertFalse((boolean)alpnHandlerPresent, (String)"Channel contains APN handler");
            this.verifyChannelHasHandler(handlers, Http2FrameCodec.class);
            this.verifyChannelHasHandler(handlers, Http2MultiplexHandler.class);
        }
        finally {
            if (connection != null) {
                connection.close().get(10L, TimeUnit.SECONDS);
            }
        }
    }

    private void verifyChannelHasHandler(List<ChannelHandler> handlers, Class<?> handlerClass) {
        boolean hasHandler = handlers.stream().anyMatch(handler -> handlerClass.isAssignableFrom(handler.getClass()));
        Assertions.assertTrue((boolean)hasHandler, (String)("Channel does not have " + handlerClass.getSimpleName() + " handler"));
    }
}

