/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.DecoratingNettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyClientTestBase;
import org.apache.kafka.common.network.netty.NettyHttp2Selector;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class NettyHttp2SelectorTest
extends NettyClientTestBase {
    private static final long reconnectBackoffMsTest = 10000L;
    private static final long reconnectBackoffMaxMs = 100000L;
    private static final long connectionSetupTimeoutMsTest = 5000L;
    private static final long connectionSetupTimeoutMaxMsTest = 127000L;
    private static final int socketSendBufferSize = 65536;
    private static final int socketReceiveBufferSize = 65536;
    private static final int defaultRequestTimeoutMs = 1000;
    private static final String clientId = "http2-selector-test-client-id";
    private static final MockTime time = new MockTime();
    private static Node node;
    private static NetworkClient networkClient;
    private static Selectable http2Selector;

    @BeforeEach
    public void setupNetClient() {
        SslContext sslContext = NettyHttp2SelectorTest.acceptAllSslContext();
        http2Selector = new NettyHttp2Selector(this.eventLoopGroup, sslContext, new LogContext());
        InetSocketAddress serverAddress = NettyHttp2SelectorTest.serverAddress();
        node = new Node(1, serverAddress.getHostName(), serverAddress.getPort());
        ManualMetadataUpdater metadataUpdater = new ManualMetadataUpdater(Collections.singletonList(node));
        networkClient = new NetworkClient(http2Selector, (MetadataUpdater)metadataUpdater, clientId, Integer.MAX_VALUE, 10000L, 100000L, 65536, 65536, 1000, 5000L, 127000L, (Time)new MockTime(), true, new ApiVersions(), new LogContext(), MetadataRecoveryStrategy.NONE);
    }

    @AfterEach
    public void closeResources() {
        networkClient.close();
    }

    @Test
    public void testApiVersionsRequest() throws InterruptedException {
        networkClient.ready(node, time.milliseconds());
        TestUtils.waitForCondition(() -> {
            networkClient.poll(1000L, time.milliseconds());
            return http2Selector.connected().size() == 1;
        }, 10000L, "Unable to connect to the node " + node.toString());
        Assertions.assertEquals((int)1, (int)http2Selector.connected().size());
        Assertions.assertEquals((Object)node.idString(), http2Selector.connected().get(0));
        Assertions.assertTrue((boolean)networkClient.hasInFlightRequests(node.idString()));
    }

    @Test
    public void testConnectMultipleTimes() throws InterruptedException {
        networkClient.ready(node, time.milliseconds());
        TestUtils.waitForCondition(() -> {
            networkClient.poll(1000L, time.milliseconds());
            return http2Selector.connected().size() == 1;
        }, 10000L, "Unable to connect to the node " + node.toString());
        Assertions.assertEquals((int)1, (int)http2Selector.connected().size());
        Assertions.assertEquals((Object)node.idString(), http2Selector.connected().get(0));
        Assertions.assertTrue((boolean)networkClient.hasInFlightRequests(node.idString()));
        networkClient.close(node.idString());
        TestUtils.waitForCondition(() -> {
            networkClient.poll(1000L, time.milliseconds());
            return http2Selector.connected().isEmpty();
        }, 10000L, "Unable to disconnect from the node " + node.toString());
        networkClient.ready(node, time.milliseconds());
        networkClient.poll(10000L, time.milliseconds());
        Assertions.assertEquals((int)1, (int)http2Selector.connected().size());
        Assertions.assertEquals((Object)node.idString(), http2Selector.connected().get(0));
        Assertions.assertTrue((boolean)networkClient.hasInFlightRequests(node.idString()));
    }

    @Test
    void testReceiveMoreCalledOnPartialData() throws IOException {
        LogContext logContext = new LogContext();
        try (NettyHttp2Selector selector = new NettyHttp2Selector(this.eventLoopGroup, null, logContext);){
            NettyHttp2Selector nettyHttp2Selector = selector;
            Objects.requireNonNull(nettyHttp2Selector);
            NettyHttp2Selector.StreamChannel channel = new NettyHttp2Selector.StreamChannel(nettyHttp2Selector, "test", logContext);
            final AtomicInteger receiveMoreCalls = new AtomicInteger(0);
            DecoratingNettyHttp2Stream stream = new DecoratingNettyHttp2Stream(this, (NettyStream)Mockito.mock(NettyHttp2Stream.class)){
                final /* synthetic */ NettyHttp2SelectorTest this$0;
                {
                    this.this$0 = this$0;
                    super(delegate);
                }

                @Override
                public void receiveMore() {
                    super.receiveMore();
                    receiveMoreCalls.incrementAndGet();
                }
            };
            channel.stream((NettyStream)stream);
            selector.streams().put("test", channel);
            boolean API_VERSION = true;
            RequestHeader requestHeader = new RequestHeader(ApiKeys.API_VERSIONS, 1, "test_client_id", 100);
            Send send = new ApiVersionsRequest.Builder().build((short)1).toSend(requestHeader);
            byte[] serializedRequest = NettyHttp2SelectorTest.serializeSend(send);
            ByteBuf data1 = Unpooled.wrappedBuffer((byte[])serializedRequest, (int)0, (int)5);
            channel.handleData(data1);
            ByteBuf data2 = Unpooled.wrappedBuffer((byte[])serializedRequest, (int)5, (int)(serializedRequest.length - 5));
            channel.handleData(data2);
            Assertions.assertEquals((int)2, (int)receiveMoreCalls.get());
            Assertions.assertEquals((int)1, (int)data1.refCnt());
            Assertions.assertEquals((int)1, (int)data2.refCnt());
            ReferenceCountUtil.release((Object)data1);
            ReferenceCountUtil.release((Object)data2);
        }
    }

    private static byte[] serializeSend(Send send) throws IOException {
        ByteBufferChannel byteBufferChannel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)byteBufferChannel);
        return byteBufferChannel.buffer().array();
    }
}

