/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.ssl.SslContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.Tag;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.AfterProperty;
import net.jqwik.api.lifecycle.BeforeProperty;
import net.jqwik.api.statistics.Histogram;
import net.jqwik.api.statistics.StatisticsReport;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.NettyHttp2Selector;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.TestUtils;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

@Tag(value="propertybased")
public class NettyHttp2SelectorTestPBT {
    private static NettyHttp2Selector selector;

    @BeforeProperty
    public void setup() {
        SslContext sslContext = TestUtils.trustAllCertsSSlContext();
        EventLoopGroup eventLoopGroup = (EventLoopGroup)Mockito.mock(EventLoopGroup.class);
        Mockito.when((Object)eventLoopGroup.next()).thenReturn((Object)((EventLoop)Mockito.mock(EventLoop.class)));
        selector = new NettyHttp2Selector(eventLoopGroup, sslContext, new LogContext());
    }

    @AfterProperty
    public void tearDown() {
        selector.close();
    }

    @Property
    @StatisticsReport(format=Histogram.class)
    void testStreamChannelHandleDataOfSingleRequestCorrectly(@ForAll(value="twoFrameLengths") Tuple.Tuple2<Integer, Integer> frameLengths) throws Exception {
        LogContext logContext = new LogContext();
        NettyHttp2Selector nettyHttp2Selector = selector;
        Objects.requireNonNull(nettyHttp2Selector);
        NettyHttp2Selector.StreamChannel channel = new NettyHttp2Selector.StreamChannel(nettyHttp2Selector, "test", logContext);
        NettyHttp2Stream stream = (NettyHttp2Stream)Mockito.mock(NettyHttp2Stream.class);
        channel.stream((NettyStream)stream);
        selector.streams().put("test", channel);
        NettyHttp2Stream.NettyHttp2StreamHandler streamHandler = new NettyHttp2Stream.NettyHttp2StreamHandler((NettyStream)stream, (NettyStream.StreamHandler)channel, logContext);
        boolean apiVersion = true;
        RequestHeader requestHeader = new RequestHeader(ApiKeys.API_VERSIONS, 1, "test_client_id", 100);
        Send send = new ApiVersionsRequest.Builder().build((short)1).toSend(requestHeader);
        ByteBufferChannel byteBufferChannel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)byteBufferChannel);
        byte[] serializedRequest = byteBufferChannel.buffer().array();
        Assertions.assertEquals((int)28, (int)serializedRequest.length);
        int firstFrameLength = (Integer)frameLengths.get1();
        int secondFrameLength = (Integer)frameLengths.get2();
        ByteBuf data1 = Unpooled.wrappedBuffer((byte[])serializedRequest, (int)0, (int)firstFrameLength);
        ByteBuf data2 = Unpooled.wrappedBuffer((byte[])serializedRequest, (int)firstFrameLength, (int)secondFrameLength);
        ByteBuf data3 = Unpooled.wrappedBuffer((byte[])serializedRequest, (int)(firstFrameLength + secondFrameLength), (int)(serializedRequest.length - (firstFrameLength + secondFrameLength)));
        Assertions.assertEquals((int)serializedRequest.length, (int)(data1.readableBytes() + data2.readableBytes() + data3.readableBytes()));
        streamHandler.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)new DefaultHttp2DataFrame(data1));
        Assertions.assertFalse((boolean)data1.isReadable());
        streamHandler.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)new DefaultHttp2DataFrame(data2));
        Assertions.assertFalse((boolean)data2.isReadable());
        streamHandler.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)new DefaultHttp2DataFrame(data3));
        Assertions.assertFalse((boolean)data3.isReadable());
        selector.poll(Duration.ofMillis(10L).toMillis());
        Assertions.assertEquals((int)1, (int)selector.completedReceives().size());
        Assertions.assertEquals((int)serializedRequest.length, (int)((NetworkReceive)selector.completedReceives().iterator().next()).size());
        Assertions.assertEquals((int)0, (int)data1.refCnt());
        Assertions.assertEquals((int)0, (int)data2.refCnt());
        Assertions.assertEquals((int)0, (int)data3.refCnt());
    }

    @Property
    @StatisticsReport(format=Histogram.class)
    void testStreamChannelHandleDataOfMultipleRequestsCorrectly(@ForAll(value="requestSplitLength") int requestSplit) throws Exception {
        LogContext logContext = new LogContext();
        NettyHttp2Selector nettyHttp2Selector = selector;
        Objects.requireNonNull(nettyHttp2Selector);
        NettyHttp2Selector.StreamChannel channel = new NettyHttp2Selector.StreamChannel(nettyHttp2Selector, "test", logContext);
        NettyHttp2Stream stream = (NettyHttp2Stream)Mockito.mock(NettyHttp2Stream.class);
        channel.stream((NettyStream)stream);
        selector.streams().put("test", channel);
        NettyHttp2Stream.NettyHttp2StreamHandler streamHandler = new NettyHttp2Stream.NettyHttp2StreamHandler((NettyStream)stream, (NettyStream.StreamHandler)channel, logContext);
        boolean apiVersion = true;
        RequestHeader requestHeader = new RequestHeader(ApiKeys.API_VERSIONS, 1, "test_client_id", 100);
        Send send1 = new ApiVersionsRequest.Builder().build((short)1).toSend(requestHeader);
        Send send2 = new ApiVersionsRequest.Builder().build((short)1).toSend(requestHeader);
        ByteBufferChannel byteBufferChannel = new ByteBufferChannel(send1.size() + send2.size());
        send1.writeTo((TransferableChannel)byteBufferChannel);
        send2.writeTo((TransferableChannel)byteBufferChannel);
        byte[] serializedRequests = byteBufferChannel.buffer().array();
        Assertions.assertEquals((int)56, (int)serializedRequests.length);
        ByteBuf data1 = Unpooled.wrappedBuffer((byte[])serializedRequests, (int)0, (int)requestSplit);
        ByteBuf data2 = Unpooled.wrappedBuffer((byte[])serializedRequests, (int)requestSplit, (int)((int)send1.size() + (int)send2.size() - requestSplit));
        Assertions.assertEquals((int)serializedRequests.length, (int)(data1.readableBytes() + data2.readableBytes()));
        streamHandler.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)new DefaultHttp2DataFrame(data1));
        streamHandler.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)new DefaultHttp2DataFrame(data2));
        selector.poll(Duration.ofMillis(10L).toMillis());
        Assertions.assertEquals((int)2, (int)selector.completedReceives().size());
        ArrayList completedReceives = new ArrayList(selector.completedReceives());
        Assertions.assertEquals((int)serializedRequests.length, (int)(((NetworkReceive)completedReceives.get(0)).size() + ((NetworkReceive)completedReceives.get(1)).size()));
        Assertions.assertEquals((int)0, (int)data1.refCnt());
        Assertions.assertEquals((int)0, (int)data2.refCnt());
    }

    @Provide
    private Arbitrary<Tuple.Tuple2<Integer, Integer>> twoFrameLengths() {
        return Arbitraries.integers().between(1, 24).flatMap(a -> Arbitraries.integers().between(1, 25 - a).map(b -> Tuple.of((Object)a, (Object)b)));
    }

    @Provide
    private Arbitrary<Integer> requestSplitLength() {
        return Arbitraries.integers().between(1, 55);
    }
}

