/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelOption;
import java.util.Map;

public class TestHttp2StreamChannel
extends EmbeddedChannel
implements Http2StreamChannel {
    private final ChannelConfig thisConfig = new TestHttp2StreamChannelConfig((Channel)this);
    private final Channel parent;
    private final int streamId;
    private final Http2FrameStream stream = new Http2FrameStream(){

        public int id() {
            return TestHttp2StreamChannel.this.streamId;
        }

        public Http2Stream.State state() {
            return Http2Stream.State.OPEN;
        }
    };

    public TestHttp2StreamChannel(Channel parent, int streamId) {
        this.parent = parent;
        this.streamId = streamId;
    }

    public ChannelConfig config() {
        if (this.thisConfig == null) {
            return super.config();
        }
        return this.thisConfig;
    }

    public Http2FrameStream stream() {
        return this.stream;
    }

    public Channel parent() {
        return this.parent;
    }

    private static class TestHttp2StreamChannelConfig
    extends DefaultChannelConfig {
        private volatile boolean autoStreamFlowControl = true;

        public TestHttp2StreamChannelConfig(Channel channel) {
            super(channel);
        }

        public Map<ChannelOption<?>, Object> getOptions() {
            return this.getOptions(super.getOptions(), new ChannelOption[]{Http2StreamChannelOption.AUTO_STREAM_FLOW_CONTROL});
        }

        public <T> T getOption(ChannelOption<T> option) {
            if (option == Http2StreamChannelOption.AUTO_STREAM_FLOW_CONTROL) {
                return (T)Boolean.valueOf(this.autoStreamFlowControl);
            }
            return (T)super.getOption(option);
        }

        public <T> boolean setOption(ChannelOption<T> option, T value) {
            if (option == Http2StreamChannelOption.AUTO_STREAM_FLOW_CONTROL) {
                this.autoStreamFlowControl = (Boolean)value;
                return true;
            }
            return super.setOption(option, value);
        }
    }
}

