/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.network.netty.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNettyClient {
    private static final Logger log = LoggerFactory.getLogger(TestNettyClient.class);
    private final boolean managedEventLoopGroup;
    private final EventLoopGroup group;
    private final ChannelHandler channelHandler;
    private Channel channel;

    public TestNettyClient() {
        this(null, null);
    }

    public TestNettyClient(EventLoopGroup group) {
        this(group, null);
    }

    public TestNettyClient(ChannelHandler channelHandler) {
        this(null, channelHandler);
    }

    public TestNettyClient(EventLoopGroup group, ChannelHandler channelHandler) {
        if (group == null) {
            this.group = Utils.createEventLoopGroup((int)1, (String)TestNettyClient.class.getSimpleName());
            this.managedEventLoopGroup = true;
        } else {
            this.group = group;
            this.managedEventLoopGroup = false;
        }
        this.channelHandler = Objects.requireNonNullElseGet(channelHandler, () -> new DefaultChannelInitializer());
    }

    public void connect(SocketAddress address) throws InterruptedException {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(Utils.channelTypeForEventLoop((EventLoopGroup)this.group, (!(address instanceof InetSocketAddress) ? 1 : 0) != 0))).handler(this.channelHandler);
        for (Map.Entry<ChannelOption<?>, Object> entry : this.channelOptions().entrySet()) {
            bootstrap.option(entry.getKey(), entry.getValue());
        }
        ChannelFuture future = bootstrap.connect(address).sync();
        log.info("Client connected to {}", (Object)address);
        this.channel = future.channel();
    }

    public Channel channel() {
        return this.channel;
    }

    public void sendMessage(String message) throws InterruptedException {
        if (!(this.channelHandler instanceof DefaultChannelInitializer)) {
            throw new UnsupportedOperationException("sendMessage is only supported with DefaultChannelInitializer or its subclasses");
        }
        this.channel.writeAndFlush((Object)message).sync();
    }

    public List<String> getReceivedMessages() {
        if (!(this.channelHandler instanceof DefaultChannelInitializer)) {
            throw new UnsupportedOperationException("getReceivedMessages is only supported with DefaultChannelInitializer or its subclasses");
        }
        ClientStringHandler handler = (ClientStringHandler)this.channel.pipeline().get(ClientStringHandler.class);
        return Collections.unmodifiableList(handler.receivedMessages);
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.managedEventLoopGroup) {
            this.group.shutdownGracefully();
        }
    }

    protected Map<ChannelOption<?>, Object> channelOptions() {
        return Collections.singletonMap(ChannelOption.SO_KEEPALIVE, true);
    }

    private static class DefaultChannelInitializer
    extends ChannelInitializer<Channel> {
        private DefaultChannelInitializer() {
        }

        protected void initChannel(Channel ch) {
            ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder(StandardCharsets.UTF_8)});
            ch.pipeline().addLast(new ChannelHandler[]{new StringEncoder(StandardCharsets.UTF_8)});
            ch.pipeline().addLast(new ChannelHandler[]{new ClientStringHandler()});
        }
    }

    private static class ClientStringHandler
    extends SimpleChannelInboundHandler<String> {
        private final List<String> receivedMessages = new ArrayList<String>();

        private ClientStringHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, String msg) {
            log.info("Received from server: {}", (Object)msg);
            this.receivedMessages.add(msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.error("Exception in client handler", cause);
            ctx.close();
        }
    }
}

