/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.network.netty.NettyStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNettyStreamHandler
implements NettyStream.StreamHandler,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TestNettyStreamHandler.class);
    private ByteBuf receivedData;
    private final CountDownLatch dataReceivedLatch;
    private boolean streamChannelClosed = false;
    private boolean closed = false;
    private boolean exceptionHandlerInvoked = false;
    private boolean writabilityChangedEventInvoked = false;
    private boolean throwOnDataReceived = false;

    public TestNettyStreamHandler(CountDownLatch dataReceivedLatch) {
        this.dataReceivedLatch = dataReceivedLatch;
    }

    public ByteBuf receivedData() {
        return this.receivedData;
    }

    public boolean isStreamChannelClosed() {
        return this.streamChannelClosed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean exceptionHandlerInvoked() {
        return this.exceptionHandlerInvoked;
    }

    public boolean isWritabilityChangedEventInvoked() {
        return this.writabilityChangedEventInvoked;
    }

    @Override
    public void close() {
        if (this.receivedData != null) {
            this.receivedData.release();
        }
        this.receivedData = null;
        this.closed = true;
    }

    public void handleData(ByteBuf data) {
        if (this.throwOnDataReceived) {
            throw new RuntimeException("Throwing exception as configured to do so.");
        }
        this.receivedData = data.retain();
        this.dataReceivedLatch.countDown();
    }

    public void handleReadyForSend() {
        log.info("Stream ready event received");
        this.writabilityChangedEventInvoked = true;
    }

    public void handleException(Throwable t) {
        log.error("Error in stream handler", t);
        this.exceptionHandlerInvoked = true;
        this.dataReceivedLatch.countDown();
    }

    public void handleClose() {
        log.info("Stream closed");
        this.streamChannelClosed = true;
        this.close();
    }

    public void throwOnDataReceived() {
        this.throwOnDataReceived = true;
    }
}

