/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;

public class OffsetFetchRequestTest {
    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testWithMultipleGroups(short version) {
        OffsetFetchRequestData data = new OffsetFetchRequestData().setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(Uuid.randomUuid()).setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))))), new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp2").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("bar").setTopicId(Uuid.randomUuid()).setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))));
        OffsetFetchRequest.Builder builder = OffsetFetchRequest.Builder.forTopicIdsOrNames((OffsetFetchRequestData)data, (boolean)false, (boolean)true);
        if (version < 8) {
            Assertions.assertThrows(OffsetFetchRequest.NoBatchedOffsetFetchRequestException.class, () -> builder.build(version));
        } else {
            Assertions.assertEquals((Object)data, (Object)builder.build(version).data());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testThrowOnFetchStableOffsetsUnsupported(short version) {
        OffsetFetchRequest.Builder builder = OffsetFetchRequest.Builder.forTopicIdsOrNames((OffsetFetchRequestData)new OffsetFetchRequestData().setRequireStable(true).setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(Uuid.randomUuid()).setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))))))), (boolean)true, (boolean)true);
        if (version < 7) {
            Assertions.assertThrows(UnsupportedVersionException.class, () -> builder.build(version));
        } else {
            builder.build(version);
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testSingleGroup(short version) {
        OffsetFetchRequestData data = new OffsetFetchRequestData().setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(Uuid.randomUuid()).setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))));
        OffsetFetchRequest.Builder builder = OffsetFetchRequest.Builder.forTopicIdsOrNames((OffsetFetchRequestData)data, (boolean)false, (boolean)true);
        if (version < 8) {
            OffsetFetchRequestData expectedRequest = new OffsetFetchRequestData().setGroupId("grp1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopic().setName("foo").setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))));
            Assertions.assertEquals((Object)expectedRequest, (Object)builder.build(version).data());
        } else {
            Assertions.assertEquals((Object)data, (Object)builder.build(version).data());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testSingleGroupWithAllTopics(short version) {
        OffsetFetchRequestData data = new OffsetFetchRequestData().setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(null)));
        OffsetFetchRequest.Builder builder = OffsetFetchRequest.Builder.forTopicIdsOrNames((OffsetFetchRequestData)data, (boolean)false, (boolean)true);
        if (version < 2) {
            Assertions.assertThrows(UnsupportedVersionException.class, () -> builder.build(version));
        } else if (version < 8) {
            OffsetFetchRequestData expectedRequest = new OffsetFetchRequestData().setGroupId("grp1").setTopics(null);
            Assertions.assertEquals((Object)expectedRequest, (Object)builder.build(version).data());
        } else {
            Assertions.assertEquals((Object)data, (Object)builder.build(version).data());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testGetErrorResponse(short version) {
        OffsetFetchRequest request = OffsetFetchRequest.Builder.forTopicIdsOrNames((OffsetFetchRequestData)new OffsetFetchRequestData().setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(Uuid.randomUuid()).setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1))))))), (boolean)false, (boolean)true).build(version);
        if (version < 2) {
            OffsetFetchResponseData expectedResponse = new OffsetFetchResponseData().setThrottleTimeMs(1000).setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(0).setErrorCode(Errors.INVALID_GROUP_ID.code()).setCommittedOffset(-1L).setMetadata("").setCommittedLeaderEpoch(-1), new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(1).setErrorCode(Errors.INVALID_GROUP_ID.code()).setCommittedOffset(-1L).setMetadata("").setCommittedLeaderEpoch(-1)))));
            Assertions.assertEquals((Object)expectedResponse, (Object)request.getErrorResponse(1000, (Throwable)Errors.INVALID_GROUP_ID.exception()).data());
        } else if (version < 8) {
            OffsetFetchResponseData expectedResponse = new OffsetFetchResponseData().setThrottleTimeMs(1000).setErrorCode(Errors.INVALID_GROUP_ID.code());
            Assertions.assertEquals((Object)expectedResponse, (Object)request.getErrorResponse(1000, (Throwable)Errors.INVALID_GROUP_ID.exception()).data());
        } else {
            OffsetFetchResponseData expectedResponse = new OffsetFetchResponseData().setThrottleTimeMs(1000).setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp1").setErrorCode(Errors.INVALID_GROUP_ID.code())));
            Assertions.assertEquals((Object)expectedResponse, (Object)request.getErrorResponse(1000, (Throwable)Errors.INVALID_GROUP_ID.exception()).data());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testGroups(short version) {
        OffsetFetchRequest request = OffsetFetchRequest.Builder.forTopicIdsOrNames((OffsetFetchRequestData)new OffsetFetchRequestData().setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(Uuid.randomUuid()).setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))))))), (boolean)false, (boolean)true).build(version);
        if (version < 8) {
            List<OffsetFetchRequestData.OffsetFetchRequestGroup> expectedGroups = List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))))));
            Assertions.assertEquals(expectedGroups, (Object)request.groups());
        } else {
            Assertions.assertEquals((Object)request.data().groups(), (Object)request.groups());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH, fromVersion=2)
    public void testGroupsWithAllTopics(short version) {
        OffsetFetchRequest request = OffsetFetchRequest.Builder.forTopicIdsOrNames((OffsetFetchRequestData)new OffsetFetchRequestData().setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(null))), (boolean)false, (boolean)true).build(version);
        if (version < 8) {
            List<OffsetFetchRequestData.OffsetFetchRequestGroup> expectedGroups = List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp1").setTopics(null));
            Assertions.assertEquals(expectedGroups, (Object)request.groups());
        } else {
            Assertions.assertEquals((Object)request.data().groups(), (Object)request.groups());
        }
    }
}

