/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.message.PublishQuotaTargetRequestData;
import org.apache.kafka.common.message.PublishQuotaTargetResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.requests.PublishQuotaTargetResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PublishQuotaTargetRequestTest {
    @Test
    public void testGetErrorResponse() {
        PublishQuotaTargetRequest req = new PublishQuotaTargetRequest(new PublishQuotaTargetRequestData(), 0);
        PublishQuotaTargetResponse resp = req.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)resp.errorCounts());
    }

    @Test
    public void testErrorCountsReturnsNoneWhenNoErrors() {
        PublishQuotaTargetResponseData data = new PublishQuotaTargetResponseData().setThrottleTimeMs(10).setErrorCode(Errors.NONE.code());
        PublishQuotaTargetResponse response = new PublishQuotaTargetResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.NONE, 1), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsReturnsOneError() {
        PublishQuotaTargetResponseData data = new PublishQuotaTargetResponseData().setThrottleTimeMs(10).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.CLUSTER_AUTHORIZATION_FAILED.message());
        PublishQuotaTargetResponse response = new PublishQuotaTargetResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }
}

