/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;

public class TestUtils {
    private TestUtils() {
    }

    public static void createKeystoreAndSetConfigs(Map<String, Object> configs) throws Exception {
        File keystore = Files.createTempFile("keystore", ".jks", new FileAttribute[0]).toFile();
        keystore.deleteOnExit();
        KeyPair keyPair = TestSslUtils.generateKeyPair("RSA");
        Password keyPassword = new Password("keyPassword");
        X509Certificate certificate = TestSslUtils.generateCertificate("CN=localhost", keyPair, 365, "SHA1withRSA");
        TestSslUtils.createKeyStore(keystore.getAbsolutePath(), keyPassword, keyPassword, "server", (Key)keyPair.getPrivate(), certificate);
        configs.put("ssl.keystore.location", keystore.getAbsolutePath());
        configs.put("ssl.keystore.password", keyPassword);
        configs.put("ssl.key.password", keyPassword);
        configs.put("ssl.keystore.type", "JKS");
    }
}

