/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class TimeTest {
    protected abstract Time createTime();

    @Test
    public void testWaitObjectTimeout() throws InterruptedException {
        Object obj = new Object();
        Time time = this.createTime();
        long timeoutMs = 100L;
        long deadlineMs = time.milliseconds() + timeoutMs;
        AtomicReference caughtException = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                time.waitObject(obj, () -> false, deadlineMs);
            }
            catch (Exception e) {
                caughtException.set(e);
            }
        });
        t.start();
        time.sleep(timeoutMs);
        t.join();
        Assertions.assertEquals(TimeoutException.class, ((Exception)caughtException.get()).getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWaitObjectConditionSatisfied() throws InterruptedException {
        Object obj = new Object();
        Time time = this.createTime();
        long timeoutMs = 1000000000L;
        long deadlineMs = time.milliseconds() + timeoutMs;
        AtomicBoolean condition = new AtomicBoolean(false);
        AtomicReference caughtException = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                time.waitObject(obj, condition::get, deadlineMs);
            }
            catch (Exception e) {
                caughtException.set(e);
            }
        });
        t.start();
        Object object = obj;
        synchronized (object) {
            condition.set(true);
            obj.notify();
        }
        t.join();
        Assertions.assertTrue((time.milliseconds() < deadlineMs ? 1 : 0) != 0);
        Assertions.assertNull(caughtException.get());
    }
}

