/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.apache.kafka.server.metrics.TenantRequestSensorBuilder;
import org.apache.kafka.server.metrics.TenantRequestSensors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TenantRequestSensorBuilderTest {
    private Metrics metrics;
    private Time time;

    @BeforeEach
    public void setUp() {
        this.time = new MockTime();
        this.metrics = new Metrics(this.time);
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testRequestCount() {
        class TenantLevelMetricsContext
        implements MetricsBuilderContext {
            private final String principal;

            public TenantLevelMetricsContext(String principal) {
                this.principal = principal;
            }

            public String principal() {
                return this.principal;
            }

            public String metricsGroup() {
                return "tenant-metrics";
            }

            public Map<String, String> metricTags() {
                HashMap<String, String> tags = new HashMap<String, String>();
                tags.put("tenant", this.principal);
                return tags;
            }

            public String sensorSuffix() {
                return String.format(":%s-%s", "tenant", this.principal);
            }
        }
        TenantRequestSensors tenantRequestSensors = new TenantRequestSensorBuilder(this.metrics, (MetricsBuilderContext)new TenantLevelMetricsContext("lkc-123")).build();
        tenantRequestSensors.recordRequest(this.time.milliseconds());
        tenantRequestSensors.recordRequest(this.time.milliseconds());
        tenantRequestSensors.recordRequest(this.time.milliseconds());
        tenantRequestSensors.recordRequest(this.time.milliseconds());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tenant", "lkc-123");
        TenantRequestSensorBuilderTest.verifyMetrics(this.metrics, tags, "aggregate-request-total", 4.0);
        TenantRequestSensorBuilderTest.verifyMetrics(this.metrics, tags, "aggregate-request-rate", 0.13333334028720856);
    }

    public static void verifyMetrics(Metrics metrics, Map<String, String> tags, String metricNameToVerify, double metricValueToVerify) {
        for (Map.Entry entry : metrics.metrics().entrySet()) {
            MetricName metricName = (MetricName)entry.getKey();
            if (!metricNameToVerify.equals(metricName.name()) || !tags.equals(metricName.tags())) continue;
            KafkaMetric metric = (KafkaMetric)entry.getValue();
            double value = (Double)metric.metricValue();
            Assertions.assertEquals((double)value, (double)metricValueToVerify, (double)1.0E-4, (String)String.format("Metric (%s) expected value: %f, actual value: %f", metricNameToVerify, metricValueToVerify, value));
            return;
        }
        Assertions.assertEquals((Object)false, (Object)true, (String)String.format("Metric (%s) with value: %f not recorded", metricNameToVerify, metricValueToVerify));
    }
}

