/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsSpec;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ListShareGroupOffsetsHandler
extends AdminApiHandler.Batched<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> {
    private final Map<String, ListShareGroupOffsetsSpec> groupSpecs;
    private final Logger log;
    private final CoordinatorStrategy lookupStrategy;

    public ListShareGroupOffsetsHandler(Map<String, ListShareGroupOffsetsSpec> groupSpecs, LogContext logContext) {
        this.groupSpecs = groupSpecs;
        this.log = logContext.logger(ListShareGroupOffsetsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> newFuture(Collection<String> groupIds) {
        return AdminApiFuture.forKeys(ListShareGroupOffsetsHandler.coordinatorKeys(groupIds));
    }

    @Override
    public String apiName() {
        return "describeShareGroupOffsets";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public DescribeShareGroupOffsetsRequest.Builder buildBatchedRequest(int coordinatorId, Set<CoordinatorKey> keys) {
        this.validateKeys(keys);
        ArrayList<DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup> groups = new ArrayList<DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup>(keys.size());
        keys.forEach(coordinatorKey -> {
            String groupId = coordinatorKey.idValue;
            ListShareGroupOffsetsSpec spec = this.groupSpecs.get(groupId);
            DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup requestGroup = new DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup().setGroupId(groupId);
            if (spec.topicPartitions() != null) {
                HashMap topicPartitionMap = new HashMap();
                spec.topicPartitions().forEach(tp -> topicPartitionMap.computeIfAbsent(tp.topic(), t -> new ArrayList()).add(tp.partition()));
                HashMap<String, DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestTopic> requestTopics = new HashMap<String, DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestTopic>();
                for (TopicPartition tp2 : spec.topicPartitions()) {
                    requestTopics.computeIfAbsent(tp2.topic(), t -> new DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestTopic().setTopicName(tp2.topic()).setPartitions(new ArrayList<Integer>())).partitions().add(tp2.partition());
                }
                requestGroup.setTopics(new ArrayList<DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestTopic>(requestTopics.values()));
            } else {
                requestGroup.setTopics(null);
            }
            groups.add(requestGroup);
        });
        DescribeShareGroupOffsetsRequestData data = new DescribeShareGroupOffsetsRequestData().setGroups(groups);
        return new DescribeShareGroupOffsetsRequest.Builder(data);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        this.validateKeys(groupIds);
        DescribeShareGroupOffsetsResponse response = (DescribeShareGroupOffsetsResponse)abstractResponse;
        HashMap completed = new HashMap();
        HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
        ArrayList<CoordinatorKey> unmapped = new ArrayList<CoordinatorKey>();
        for (CoordinatorKey coordinatorKey : groupIds) {
            String groupId = coordinatorKey.idValue;
            if (response.hasGroupError(groupId)) {
                this.handleGroupError(coordinatorKey, response.groupError(groupId), failed, unmapped);
                continue;
            }
            HashMap groupOffsetsListing = new HashMap();
            response.data().groups().stream().filter(g2 -> g2.groupId().equals(groupId)).forEach(groupResponse -> {
                for (DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseTopic topicResponse : groupResponse.topics()) {
                    for (DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponsePartition partitionResponse : topicResponse.partitions()) {
                        TopicPartition tp = new TopicPartition(topicResponse.topicName(), partitionResponse.partitionIndex());
                        if (partitionResponse.errorCode() == Errors.NONE.code()) {
                            Optional<Integer> leaderEpoch;
                            long startOffset = partitionResponse.startOffset();
                            Optional<Integer> optional = leaderEpoch = partitionResponse.leaderEpoch() < 0 ? Optional.empty() : Optional.of(partitionResponse.leaderEpoch());
                            if (partitionResponse.startOffset() < 0L) {
                                groupOffsetsListing.put(tp, null);
                                continue;
                            }
                            groupOffsetsListing.put(tp, new OffsetAndMetadata(startOffset, leaderEpoch, ""));
                            continue;
                        }
                        this.log.warn("Skipping return offset for {} due to error {}: {}.", new Object[]{tp, partitionResponse.errorCode(), partitionResponse.errorMessage()});
                    }
                }
            });
            completed.put(coordinatorKey, groupOffsetsListing);
        }
        return new AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>>(completed, failed, unmapped);
    }

    private static Set<CoordinatorKey> coordinatorKeys(Collection<String> groupIds) {
        return groupIds.stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        Set<CoordinatorKey> keys = ListShareGroupOffsetsHandler.coordinatorKeys(this.groupSpecs.keySet());
        if (!keys.containsAll(groupIds)) {
            throw new IllegalArgumentException("Received unexpected group ids " + String.valueOf(groupIds) + " (expected one of " + String.valueOf(keys) + ")");
        }
    }

    private void handleGroupError(CoordinatorKey groupId, Throwable exception, Map<CoordinatorKey, Throwable> failed, List<CoordinatorKey> groupsToUnmap) {
        Errors error = Errors.forException(exception);
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: 
            case UNKNOWN_MEMBER_ID: 
            case STALE_MEMBER_EPOCH: {
                this.log.debug("`DescribeShareGroupOffsets` request for group id {} failed due to error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, exception);
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`DescribeShareGroupOffsets` request for group id {} failed because the coordinator is still in the process of loading state. Will retry", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`DescribeShareGroupOffsets` request for group id {} returned error {}. Will attempt to find the coordinator again and retry", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            default: {
                this.log.error("`DescribeShareGroupOffsets` request for group id {} failed due to unexpected error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, exception);
            }
        }
    }
}

