/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.StreamsGroupHeartbeatResponseData;

public class StreamsRebalanceData {
    private final UUID processId;
    private final Optional<HostInfo> endpoint;
    private final Map<String, String> clientTags;
    private final Map<String, Subtopology> subtopologies;
    private final AtomicReference<Assignment> reconciledAssignment = new AtomicReference<Assignment>(Assignment.EMPTY);
    private final AtomicReference<Map<HostInfo, EndpointPartitions>> partitionsByHost = new AtomicReference(Collections.emptyMap());
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final AtomicReference<List<StreamsGroupHeartbeatResponseData.Status>> statuses = new AtomicReference(List.of());

    public StreamsRebalanceData(UUID processId, Optional<HostInfo> endpoint, Map<String, Subtopology> subtopologies, Map<String, String> clientTags) {
        this.processId = Objects.requireNonNull(processId, "Process ID cannot be null");
        this.endpoint = Objects.requireNonNull(endpoint, "Endpoint cannot be null");
        this.subtopologies = Map.copyOf(Objects.requireNonNull(subtopologies, "Subtopologies cannot be null"));
        this.clientTags = Map.copyOf(Objects.requireNonNull(clientTags, "Client tags cannot be null"));
    }

    public UUID processId() {
        return this.processId;
    }

    public Optional<HostInfo> endpoint() {
        return this.endpoint;
    }

    public Map<String, String> clientTags() {
        return this.clientTags;
    }

    public Map<String, Subtopology> subtopologies() {
        return this.subtopologies;
    }

    public int topologyEpoch() {
        return 0;
    }

    public void setReconciledAssignment(Assignment assignment) {
        this.reconciledAssignment.set(assignment);
    }

    public Assignment reconciledAssignment() {
        return this.reconciledAssignment.get();
    }

    public void setPartitionsByHost(Map<HostInfo, EndpointPartitions> partitionsByHost) {
        this.partitionsByHost.set(partitionsByHost);
    }

    public Map<HostInfo, EndpointPartitions> partitionsByHost() {
        return this.partitionsByHost.get();
    }

    public void requestShutdown() {
        this.shutdownRequested.set(true);
    }

    public boolean shutdownRequested() {
        return this.shutdownRequested.get();
    }

    public void setStatuses(List<StreamsGroupHeartbeatResponseData.Status> s2) {
        this.statuses.set(s2);
    }

    public List<StreamsGroupHeartbeatResponseData.Status> statuses() {
        return this.statuses.get();
    }

    public static class Assignment {
        public static final Assignment EMPTY = new Assignment();
        private final Set<TaskId> activeTasks;
        private final Set<TaskId> standbyTasks;
        private final Set<TaskId> warmupTasks;

        private Assignment() {
            this.activeTasks = Set.of();
            this.standbyTasks = Set.of();
            this.warmupTasks = Set.of();
        }

        public Assignment(Set<TaskId> activeTasks, Set<TaskId> standbyTasks, Set<TaskId> warmupTasks) {
            this.activeTasks = Set.copyOf((Collection)Objects.requireNonNull(activeTasks, "Active tasks cannot be null"));
            this.standbyTasks = Set.copyOf((Collection)Objects.requireNonNull(standbyTasks, "Standby tasks cannot be null"));
            this.warmupTasks = Set.copyOf((Collection)Objects.requireNonNull(warmupTasks, "Warmup tasks cannot be null"));
        }

        public Set<TaskId> activeTasks() {
            return this.activeTasks;
        }

        public Set<TaskId> standbyTasks() {
            return this.standbyTasks;
        }

        public Set<TaskId> warmupTasks() {
            return this.warmupTasks;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Assignment that = (Assignment)o;
            return Objects.equals(this.activeTasks, that.activeTasks) && Objects.equals(this.standbyTasks, that.standbyTasks) && Objects.equals(this.warmupTasks, that.warmupTasks);
        }

        public int hashCode() {
            return Objects.hash(this.activeTasks, this.standbyTasks, this.warmupTasks);
        }

        public Assignment copy() {
            return new Assignment(this.activeTasks, this.standbyTasks, this.warmupTasks);
        }

        public String toString() {
            return "Assignment{activeTasks=" + String.valueOf(this.activeTasks) + ", standbyTasks=" + String.valueOf(this.standbyTasks) + ", warmupTasks=" + String.valueOf(this.warmupTasks) + "}";
        }
    }

    public static class TopicInfo {
        private final Optional<Integer> numPartitions;
        private final Optional<Short> replicationFactor;
        private final Map<String, String> topicConfigs;

        public TopicInfo(Optional<Integer> numPartitions, Optional<Short> replicationFactor, Map<String, String> topicConfigs) {
            this.numPartitions = Objects.requireNonNull(numPartitions, "Number of partitions cannot be null");
            this.replicationFactor = Objects.requireNonNull(replicationFactor, "Replication factor cannot be null");
            this.topicConfigs = Map.copyOf(Objects.requireNonNull(topicConfigs, "Additional topic configs cannot be null"));
        }

        public Optional<Integer> numPartitions() {
            return this.numPartitions;
        }

        public Optional<Short> replicationFactor() {
            return this.replicationFactor;
        }

        public Map<String, String> topicConfigs() {
            return this.topicConfigs;
        }

        public String toString() {
            return "TopicInfo{numPartitions=" + String.valueOf(this.numPartitions) + ", replicationFactor=" + String.valueOf(this.replicationFactor) + ", topicConfigs=" + String.valueOf(this.topicConfigs) + "}";
        }
    }

    public static class Subtopology {
        private final Set<String> sourceTopics;
        private final Set<String> repartitionSinkTopics;
        private final Map<String, TopicInfo> stateChangelogTopics;
        private final Map<String, TopicInfo> repartitionSourceTopics;
        private final Collection<Set<String>> copartitionGroups;

        public Subtopology(Set<String> sourceTopics, Set<String> repartitionSinkTopics, Map<String, TopicInfo> repartitionSourceTopics, Map<String, TopicInfo> stateChangelogTopics, Collection<Set<String>> copartitionGroups) {
            this.sourceTopics = Set.copyOf((Collection)Objects.requireNonNull(sourceTopics, "Subtopology ID cannot be null"));
            this.repartitionSinkTopics = Set.copyOf((Collection)Objects.requireNonNull(repartitionSinkTopics, "Repartition sink topics cannot be null"));
            this.repartitionSourceTopics = Map.copyOf(Objects.requireNonNull(repartitionSourceTopics, "Repartition source topics cannot be null"));
            this.stateChangelogTopics = Map.copyOf(Objects.requireNonNull(stateChangelogTopics, "State changelog topics cannot be null"));
            this.copartitionGroups = Collections.unmodifiableCollection(Objects.requireNonNull(copartitionGroups, "Co-partition groups cannot be null"));
        }

        public Set<String> sourceTopics() {
            return this.sourceTopics;
        }

        public Set<String> repartitionSinkTopics() {
            return this.repartitionSinkTopics;
        }

        public Map<String, TopicInfo> stateChangelogTopics() {
            return this.stateChangelogTopics;
        }

        public Map<String, TopicInfo> repartitionSourceTopics() {
            return this.repartitionSourceTopics;
        }

        public Collection<Set<String>> copartitionGroups() {
            return this.copartitionGroups;
        }

        public String toString() {
            return "Subtopology{sourceTopics=" + String.valueOf(this.sourceTopics) + ", repartitionSinkTopics=" + String.valueOf(this.repartitionSinkTopics) + ", stateChangelogTopics=" + String.valueOf(this.stateChangelogTopics) + ", repartitionSourceTopics=" + String.valueOf(this.repartitionSourceTopics) + ", copartitionGroups=" + String.valueOf(this.copartitionGroups) + "}";
        }
    }

    public static class EndpointPartitions {
        private final List<TopicPartition> activePartitions;
        private final List<TopicPartition> standbyPartitions;

        public EndpointPartitions(List<TopicPartition> activePartitions, List<TopicPartition> standbyPartitions) {
            this.activePartitions = activePartitions;
            this.standbyPartitions = standbyPartitions;
        }

        public List<TopicPartition> activePartitions() {
            return new ArrayList<TopicPartition>(this.activePartitions);
        }

        public List<TopicPartition> standbyPartitions() {
            return new ArrayList<TopicPartition>(this.standbyPartitions);
        }

        public String toString() {
            return "EndpointPartitions {activePartitions=" + String.valueOf(this.activePartitions) + ", standbyPartitions=" + String.valueOf(this.standbyPartitions) + "}";
        }
    }

    public static class HostInfo {
        private final String host;
        private final int port;

        public HostInfo(String host, int port) {
            this.host = Objects.requireNonNull(host);
            this.port = port;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostInfo hostInfo = (HostInfo)o;
            return this.port == hostInfo.port && Objects.equals(this.host, hostInfo.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }

        public String toString() {
            return "HostInfo{host='" + this.host + "', port=" + this.port + "}";
        }
    }

    public static class TaskId
    implements Comparable<TaskId> {
        private final String subtopologyId;
        private final int partitionId;

        public TaskId(String subtopologyId, int partitionId) {
            this.subtopologyId = Objects.requireNonNull(subtopologyId, "Subtopology ID cannot be null");
            this.partitionId = partitionId;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskId taskId = (TaskId)o;
            return this.partitionId == taskId.partitionId && Objects.equals(this.subtopologyId, taskId.subtopologyId);
        }

        public int hashCode() {
            return Objects.hash(this.subtopologyId, this.partitionId);
        }

        @Override
        public int compareTo(TaskId taskId) {
            Objects.requireNonNull(taskId, "taskId cannot be null");
            return Comparator.comparing(TaskId::subtopologyId).thenComparingInt(TaskId::partitionId).compare(this, taskId);
        }

        public String toString() {
            return this.subtopologyId + "_" + this.partitionId;
        }
    }
}

