/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Utils;

public class BrokerSecurityConfigs {
    public static final String PRINCIPAL_BUILDER_CLASS_CONFIG = "principal.builder.class";
    public static final String SSL_PRINCIPAL_MAPPING_RULES_CONFIG = "ssl.principal.mapping.rules";
    public static final String DEFAULT_SSL_PRINCIPAL_MAPPING_RULES = "DEFAULT";
    public static final String SSL_PRINCIPAL_MAPPING_RULES_DOC = "A list of rules for mapping from distinguished name from the client certificate to short name. The rules are evaluated in order and the first rule that matches a principal name is used to map it to a short name. Any later rules in the list are ignored. By default, distinguished name of the X.500 certificate will be the principal. For more details on the format please see <a href=\"#security_authz\"> security authorization and acls</a>. Note that this configuration is ignored if an extension of KafkaPrincipalBuilder is provided by the <code>principal.builder.class</code> configuration.";
    public static final String SASL_SERVER_AUTHN_ASYNC_ENABLE = "sasl.server.authn.async.enable";
    public static final String SASL_SERVER_AUTHN_ASYNC_TIMEOUT_MS = "sasl.server.authn.async.timeout.ms";
    public static final String SASL_SERVER_AUTHN_ASYNC_MAX_THREADS_PROP = "sasl.server.authn.async.max.threads";
    public static final String SASL_SERVER_AUTHN_ASYNC_ENABLE_DOC = "Setting this configuration to true allows the SASL authentication to attempt to perform authentication asynchronously.";
    public static final String SASL_SERVER_AUTHN_ASYNC_TIMEOUT_MS_DOC = "The broker will attempt to forcibly stop authentication that runs longer than this.";
    public static final String SASL_SERVER_AUTHN_ASYNC_MAX_THREADS_PROP_DOC = "Maximum number of threads in async authentication thread pool to perform authentication asynchronously.";
    public static final boolean DEFAULT_SASL_SERVER_AUTHN_ASYNC_ENABLE = false;
    public static final int DEFAULT_SASL_SERVER_AUTHN_ASYNC_MAX_THREADS = 1;
    public static final long DEFAULT_SASL_SERVER_AUTHN_ASYNC_TIMEOUT_MS = 30000L;
    public static final String SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_CONFIG = "sasl.kerberos.principal.to.local.rules";
    public static final List<String> DEFAULT_SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES = Collections.singletonList("DEFAULT");
    public static final String SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_DOC = "A list of rules for mapping from principal names to short names (typically operating system usernames). The rules are evaluated in order and the first rule that matches a principal name is used to map it to a short name. Any later rules in the list are ignored. By default, principal names of the form <code>{username}/{hostname}@{REALM}</code> are mapped to <code>{username}</code>. For more details on the format please see <a href=\"#security_authz\"> security authorization and acls</a>. Note that this configuration is ignored if an extension of <code>KafkaPrincipalBuilder</code> is provided by the <code>principal.builder.class</code> configuration.";
    public static final Class<? extends KafkaPrincipalBuilder> PRINCIPAL_BUILDER_CLASS_DEFAULT = DefaultKafkaPrincipalBuilder.class;
    public static final String PRINCIPAL_BUILDER_CLASS_DOC = "The fully qualified name of a class that implements the KafkaPrincipalBuilder interface, which is used to build the KafkaPrincipal object used during authorization. If no principal builder is defined, the default behavior depends on the security protocol in use. For SSL authentication,  the principal will be derived using the rules defined by <code>ssl.principal.mapping.rules</code> applied on the distinguished name from the client certificate if one is provided; otherwise, if client authentication is not required, the principal name will be ANONYMOUS. For SASL authentication, the principal will be derived using the rules defined by <code>sasl.kerberos.principal.to.local.rules</code> if GSSAPI is in use, and the SASL authentication ID for other mechanisms. For PLAINTEXT, the principal will be ANONYMOUS. Note that custom implementations of <code>KafkaPrincipalBuilder</code> is required to implement <code>KafkaPrincipalSerde</code> interface, otherwise brokers will not be able to forward requests to the controller.";
    public static final String SSL_CLIENT_AUTH_CONFIG = "ssl.client.auth";
    public static final String SSL_CLIENT_AUTH_DEFAULT = SslClientAuth.NONE.toString();
    public static final String SSL_CLIENT_AUTH_DOC = "Configures kafka broker to request client authentication. The following settings are common:  <ul> <li><code>ssl.client.auth=required</code> If set to required client authentication is required. <li><code>ssl.client.auth=requested</code> This means client authentication is optional. unlike required, if this option is set client can choose not to provide authentication information about itself <li><code>ssl.client.auth=none</code> This means client authentication is not needed.</ul>";
    public static final String SASL_ENABLED_MECHANISMS_CONFIG = "sasl.enabled.mechanisms";
    public static final List<String> DEFAULT_SASL_ENABLED_MECHANISMS = Collections.singletonList("GSSAPI");
    public static final String SASL_ENABLED_MECHANISMS_DOC = "The list of SASL mechanisms enabled in the Kafka server. The list may contain any mechanism for which a security provider is available. Only GSSAPI is enabled by default.";
    public static final String SASL_SERVER_CALLBACK_HANDLER_CLASS_CONFIG = "sasl.server.callback.handler.class";
    public static final String SASL_SERVER_CALLBACK_HANDLER_CLASS_DOC = "The fully qualified name of a SASL server callback handler class that implements the AuthenticateCallbackHandler interface. Server callback handlers must be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.plain.sasl.server.callback.handler.class=com.example.CustomPlainCallbackHandler.";
    public static final String CONNECTIONS_MAX_REAUTH_MS_CONFIG = "connections.max.reauth.ms";
    public static final long DEFAULT_CONNECTIONS_MAX_REAUTH_MS = 0L;
    public static final String CONNECTIONS_MAX_REAUTH_MS_DOC = "When explicitly set to a positive number (the default is 0, not a positive number), a session lifetime that will not exceed the configured value will be communicated to v2.2.0 or later clients when they authenticate. The broker will disconnect any such connection that is not re-authenticated within the session lifetime and that is then subsequently used for any purpose other than re-authentication. Configuration names can optionally be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.oauthbearer.connections.max.reauth.ms=3600000";
    public static final String SASL_SERVER_MAX_RECEIVE_SIZE_CONFIG = "sasl.server.max.receive.size";
    public static final int DEFAULT_SASL_SERVER_MAX_RECEIVE_SIZE = 524288;
    public static final String SASL_SERVER_MAX_RECEIVE_SIZE_DOC = "The maximum receive size allowed before and during initial SASL authentication. Default receive size is 512KB. GSSAPI limits requests to 64K, but we allow upto 512KB by default for custom SASL mechanisms. In practice, PLAIN, SCRAM and OAUTH mechanisms can use much smaller limits.";
    public static final String SSL_ALLOW_DN_CHANGES_CONFIG = "ssl.allow.dn.changes";
    public static final boolean DEFAULT_SSL_ALLOW_DN_CHANGES_VALUE = false;
    public static final String SSL_ALLOW_DN_CHANGES_DOC = "Indicates whether changes to the certificate distinguished name should be allowed during a dynamic reconfiguration of certificates or not.";
    public static final String SSL_ALLOW_SAN_CHANGES_CONFIG = "ssl.allow.san.changes";
    public static final boolean DEFAULT_SSL_ALLOW_SAN_CHANGES_VALUE = false;
    public static final String SSL_ALLOW_SAN_CHANGES_DOC = "Indicates whether changes to the certificate subject alternative names should be allowed during a dynamic reconfiguration of certificates or not.";
    public static final String SASL_MECHANISM_INTER_BROKER_PROTOCOL_CONFIG = "sasl.mechanism.inter.broker.protocol";
    public static final String SASL_MECHANISM_INTER_BROKER_PROTOCOL_DOC = "SASL mechanism used for inter-broker communication. Default is GSSAPI.";
    public static final String TOKEN_IMPERSONATION_VALIDATION = "token.impersonation.validation";
    public static final boolean DEFAULT_TOKEN_IMPERSONATION_VALIDATION_VALUE = true;
    public static final String TOKEN_IMPERSONATION_VALIDATION_DOC = "Indicates whether impersonation token validation should be enabled or not. If enabled, the broker will validate the incoming certificate subject with the cp_proxy claim in impersonation token.";
    public static final String ALLOWED_SASL_OAUTHBEARER_URLS_CONFIG = "org.apache.kafka.sasl.oauthbearer.allowed.urls";
    public static final String ALLOWED_SASL_OAUTHBEARER_URLS_DEFAULT = "";
    public static final String ALLOWED_SASL_OAUTHBEARER_FILES_CONFIG = "org.apache.kafka.sasl.oauthbearer.allowed.files";
    public static final String ALLOWED_SASL_OAUTHBEARER_FILES_DEFAULT = "";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("connections.max.reauth.ms", ConfigDef.Type.LONG, 0L, ConfigDef.Importance.MEDIUM, "When explicitly set to a positive number (the default is 0, not a positive number), a session lifetime that will not exceed the configured value will be communicated to v2.2.0 or later clients when they authenticate. The broker will disconnect any such connection that is not re-authenticated within the session lifetime and that is then subsequently used for any purpose other than re-authentication. Configuration names can optionally be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.oauthbearer.connections.max.reauth.ms=3600000").define("sasl.server.max.receive.size", ConfigDef.Type.INT, 524288, ConfigDef.Importance.MEDIUM, "The maximum receive size allowed before and during initial SASL authentication. Default receive size is 512KB. GSSAPI limits requests to 64K, but we allow upto 512KB by default for custom SASL mechanisms. In practice, PLAIN, SCRAM and OAUTH mechanisms can use much smaller limits.").define("security.providers", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "A list of configurable creator classes each returning a provider implementing security algorithms. These classes should implement the <code>org.apache.kafka.common.security.auth.SecurityProviderCreator</code> interface.").define("token.impersonation.validation", ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, "Indicates whether impersonation token validation should be enabled or not. If enabled, the broker will validate the incoming certificate subject with the cp_proxy claim in impersonation token.").define("principal.builder.class", ConfigDef.Type.CLASS, PRINCIPAL_BUILDER_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, "The fully qualified name of a class that implements the KafkaPrincipalBuilder interface, which is used to build the KafkaPrincipal object used during authorization. If no principal builder is defined, the default behavior depends on the security protocol in use. For SSL authentication,  the principal will be derived using the rules defined by <code>ssl.principal.mapping.rules</code> applied on the distinguished name from the client certificate if one is provided; otherwise, if client authentication is not required, the principal name will be ANONYMOUS. For SASL authentication, the principal will be derived using the rules defined by <code>sasl.kerberos.principal.to.local.rules</code> if GSSAPI is in use, and the SASL authentication ID for other mechanisms. For PLAINTEXT, the principal will be ANONYMOUS. Note that custom implementations of <code>KafkaPrincipalBuilder</code> is required to implement <code>KafkaPrincipalSerde</code> interface, otherwise brokers will not be able to forward requests to the controller.").define("ssl.client.auth", ConfigDef.Type.STRING, (Object)SSL_CLIENT_AUTH_DEFAULT, ConfigDef.ValidString.in(Utils.enumOptions(SslClientAuth.class)), ConfigDef.Importance.MEDIUM, "Configures kafka broker to request client authentication. The following settings are common:  <ul> <li><code>ssl.client.auth=required</code> If set to required client authentication is required. <li><code>ssl.client.auth=requested</code> This means client authentication is optional. unlike required, if this option is set client can choose not to provide authentication information about itself <li><code>ssl.client.auth=none</code> This means client authentication is not needed.</ul>").define("ssl.principal.mapping.rules", ConfigDef.Type.STRING, "DEFAULT", ConfigDef.Importance.LOW, "A list of rules for mapping from distinguished name from the client certificate to short name. The rules are evaluated in order and the first rule that matches a principal name is used to map it to a short name. Any later rules in the list are ignored. By default, distinguished name of the X.500 certificate will be the principal. For more details on the format please see <a href=\"#security_authz\"> security authorization and acls</a>. Note that this configuration is ignored if an extension of KafkaPrincipalBuilder is provided by the <code>principal.builder.class</code> configuration.").define("ssl.allow.dn.changes", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW, "Indicates whether changes to the certificate distinguished name should be allowed during a dynamic reconfiguration of certificates or not.").define("ssl.allow.san.changes", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW, "Indicates whether changes to the certificate subject alternative names should be allowed during a dynamic reconfiguration of certificates or not.").define("ssl.protocol", ConfigDef.Type.STRING, "TLSv1.3", ConfigDef.Importance.MEDIUM, "The SSL protocol used to generate the SSLContext. The default is 'TLSv1.3', which should be fine for most use cases. A typical alternative to the default is 'TLSv1.2'. Allowed values for this config are dependent on the JVM. Clients using the defaults for this config and 'ssl.enabled.protocols' will downgrade to 'TLSv1.2' if the server does not support 'TLSv1.3'. If this config is set to 'TLSv1.2', however, clients will not use 'TLSv1.3' even if it is one of the values in `ssl.enabled.protocols` and the server only supports 'TLSv1.3'.").define("ssl.provider", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The name of the security provider used for SSL connections. Default value is the default security provider of the JVM.").define("ssl.enabled.protocols", ConfigDef.Type.LIST, "TLSv1.2,TLSv1.3", ConfigDef.Importance.MEDIUM, "The list of protocols enabled for SSL connections. The default is 'TLSv1.2,TLSv1.3'. This means that clients and servers will prefer TLSv1.3 if both support it and fallback to TLSv1.2 otherwise (assuming both support at least TLSv1.2). This default should be fine for most use cases. Also see the config documentation for `ssl.protocol` to understand how it can impact the TLS version negotiation behavior.").define("ssl.keystore.type", ConfigDef.Type.STRING, "JKS", ConfigDef.Importance.MEDIUM, "The file format of the key store file. This is optional for client. The values currently supported by the default `ssl.engine.factory.class` are [JKS, PKCS12, PEM].").define("ssl.keystore.location", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The location of the key store file. This is optional for client and can be used for two-way authentication for client.").define("ssl.keystore.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "The store password for the key store file. This is optional for client and only needed if 'ssl.keystore.location' is configured. Key store password is not supported for PEM format.").define("ssl.key.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "The password of the private key in the key store file or the PEM key specified in 'ssl.keystore.key'.").define("ssl.keystore.key", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "Private key in the format specified by 'ssl.keystore.type'. Default SSL engine factory supports only PEM format with PKCS#8 keys. If the key is encrypted, key password must be specified using 'ssl.key.password'").define("ssl.keystore.certificate.chain", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "Certificate chain in the format specified by 'ssl.keystore.type'. Default SSL engine factory supports only PEM format with a list of X.509 certificates").define("ssl.truststore.type", ConfigDef.Type.STRING, "JKS", ConfigDef.Importance.MEDIUM, "The file format of the trust store file. The values currently supported by the default `ssl.engine.factory.class` are [JKS, PKCS12, PEM].").define("ssl.truststore.location", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The location of the trust store file.").define("ssl.truststore.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "The password for the trust store file. If a password is not set, trust store file configured will still be used, but integrity checking is disabled. Trust store password is not supported for PEM format.").define("ssl.truststore.certificates", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "Trusted certificates in the format specified by 'ssl.truststore.type'. Default SSL engine factory supports only PEM format with X.509 certificates.").define("ssl.keymanager.algorithm", ConfigDef.Type.STRING, SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM, ConfigDef.Importance.MEDIUM, "The algorithm used by key manager factory for SSL connections. Default value is the key manager factory algorithm configured for the Java Virtual Machine.").define("ssl.trustmanager.algorithm", ConfigDef.Type.STRING, SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM, ConfigDef.Importance.MEDIUM, "The algorithm used by trust manager factory for SSL connections. Default value is the trust manager factory algorithm configured for the Java Virtual Machine.").define("ssl.endpoint.identification.algorithm", ConfigDef.Type.STRING, "https", ConfigDef.Importance.LOW, "The endpoint identification algorithm to validate server hostname using server certificate. ").define("ssl.secure.random.implementation", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The SecureRandom PRNG implementation to use for SSL cryptography operations. ").define("ssl.cipher.suites", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, "A list of cipher suites. This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol. By default all the available cipher suites are supported.").define("ssl.engine.factory.class", ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, "The class of type org.apache.kafka.common.security.auth.SslEngineFactory to provide SSLEngine objects. Default value is org.apache.kafka.common.security.ssl.DefaultSslEngineFactory. Alternatively, setting this to org.apache.kafka.common.security.ssl.CommonNameLoggingSslEngineFactory will log the common name of expired SSL certificates used by clients to authenticate at any of the brokers with log level INFO. Note that this will cause a tiny delay during establishment of new connections from mTLS clients to brokers due to the extra code for examining the certificate chain provided by the client. Note further that the implementation uses a custom truststore based on the standard Java truststore and thus might be considered a security risk due to not being as mature as the standard one.").define("sasl.mechanism.inter.broker.protocol", ConfigDef.Type.STRING, "GSSAPI", ConfigDef.Importance.MEDIUM, "SASL mechanism used for inter-broker communication. Default is GSSAPI.").define("sasl.enabled.mechanisms", ConfigDef.Type.LIST, DEFAULT_SASL_ENABLED_MECHANISMS, ConfigDef.Importance.MEDIUM, "The list of SASL mechanisms enabled in the Kafka server. The list may contain any mechanism for which a security provider is available. Only GSSAPI is enabled by default.").define("sasl.server.callback.handler.class", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "The fully qualified name of a SASL server callback handler class that implements the AuthenticateCallbackHandler interface. Server callback handlers must be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.plain.sasl.server.callback.handler.class=com.example.CustomPlainCallbackHandler.").define("sasl.kerberos.principal.to.local.rules", ConfigDef.Type.LIST, DEFAULT_SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES, ConfigDef.Importance.MEDIUM, "A list of rules for mapping from principal names to short names (typically operating system usernames). The rules are evaluated in order and the first rule that matches a principal name is used to map it to a short name. Any later rules in the list are ignored. By default, principal names of the form <code>{username}/{hostname}@{REALM}</code> are mapped to <code>{username}</code>. For more details on the format please see <a href=\"#security_authz\"> security authorization and acls</a>. Note that this configuration is ignored if an extension of <code>KafkaPrincipalBuilder</code> is provided by the <code>principal.builder.class</code> configuration.").define("sasl.jaas.config", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "JAAS login context parameters for SASL connections in the format used by JAAS configuration files. JAAS configuration file format is described <a href=\"https://docs.oracle.com/javase/8/docs/technotes/guides/security/jgss/tutorials/LoginConfigFile.html\">here</a>. The format for the value is: <code>loginModuleClass controlFlag (optionName=optionValue)*;</code>. For brokers, the config must be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.scram-sha-256.sasl.jaas.config=com.example.ScramLoginModule required;").define("sasl.client.callback.handler.class", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "The fully qualified name of a SASL client callback handler class that implements the AuthenticateCallbackHandler interface.").define("sasl.login.class", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "The fully qualified name of a class that implements the Login interface. For brokers, login config must be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.scram-sha-256.sasl.login.class=com.example.CustomScramLogin").define("sasl.login.callback.handler.class", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "The fully qualified name of a SASL login callback handler class that implements the AuthenticateCallbackHandler interface. For brokers, login callback handler config must be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.scram-sha-256.sasl.login.callback.handler.class=com.example.CustomScramLoginCallbackHandler").define("sasl.kerberos.service.name", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The Kerberos principal name that Kafka runs as. This can be defined either in Kafka's JAAS config or in Kafka's config.").define("sasl.kerberos.kinit.cmd", ConfigDef.Type.STRING, "/usr/bin/kinit", ConfigDef.Importance.MEDIUM, "Kerberos kinit command path.").define("sasl.kerberos.ticket.renew.window.factor", ConfigDef.Type.DOUBLE, 0.8, ConfigDef.Importance.MEDIUM, "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.").define("sasl.kerberos.ticket.renew.jitter", ConfigDef.Type.DOUBLE, 0.05, ConfigDef.Importance.MEDIUM, "Percentage of random jitter added to the renewal time.").define("sasl.kerberos.min.time.before.relogin", ConfigDef.Type.LONG, 60000L, ConfigDef.Importance.MEDIUM, "Login thread sleep time between refresh attempts.").define("sasl.login.refresh.window.factor", ConfigDef.Type.DOUBLE, 0.8, ConfigDef.Importance.MEDIUM, "Login refresh thread will sleep until the specified window factor relative to the credential's lifetime has been reached, at which time it will try to refresh the credential. Legal values are between 0.5 (50%) and 1.0 (100%) inclusive; a default value of 0.8 (80%) is used if no value is specified. Currently applies only to OAUTHBEARER.").define("sasl.login.refresh.window.jitter", ConfigDef.Type.DOUBLE, 0.05, ConfigDef.Importance.MEDIUM, "The maximum amount of random jitter relative to the credential's lifetime that is added to the login refresh thread's sleep time. Legal values are between 0 and 0.25 (25%) inclusive; a default value of 0.05 (5%) is used if no value is specified. Currently applies only to OAUTHBEARER.").define("sasl.login.refresh.min.period.seconds", ConfigDef.Type.SHORT, (short)60, ConfigDef.Importance.MEDIUM, "The desired minimum time for the login refresh thread to wait before refreshing a credential, in seconds. Legal values are between 0 and 900 (15 minutes); a default value of 60 (1 minute) is used if no value is specified.  This value and  sasl.login.refresh.buffer.seconds are both ignored if their sum exceeds the remaining lifetime of a credential. Currently applies only to OAUTHBEARER.").define("sasl.login.refresh.buffer.seconds", ConfigDef.Type.SHORT, (short)300, ConfigDef.Importance.MEDIUM, "The amount of buffer time before credential expiration to maintain when refreshing a credential, in seconds. If a refresh would otherwise occur closer to expiration than the number of buffer seconds then the refresh will be moved up to maintain as much of the buffer time as possible. Legal values are between 0 and 3600 (1 hour); a default value of  300 (5 minutes) is used if no value is specified. This value and sasl.login.refresh.min.period.seconds are both ignored if their sum exceeds the remaining lifetime of a credential. Currently applies only to OAUTHBEARER.").define("sasl.login.connect.timeout.ms", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The (optional) value in milliseconds for the external authentication provider connection timeout. Currently applies only to OAUTHBEARER.").define("sasl.login.read.timeout.ms", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The (optional) value in milliseconds for the external authentication provider read timeout. Currently applies only to OAUTHBEARER.").define("sasl.login.retry.backoff.max.ms", ConfigDef.Type.LONG, 10000L, ConfigDef.Importance.LOW, "The (optional) value in milliseconds for the maximum wait between login attempts to the external authentication provider. Login uses an exponential backoff algorithm with an initial wait based on the sasl.login.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.login.retry.backoff.max.ms setting. Currently applies only to OAUTHBEARER.").define("sasl.login.retry.backoff.ms", ConfigDef.Type.LONG, 100L, ConfigDef.Importance.LOW, "The (optional) value in milliseconds for the initial wait between login attempts to the external authentication provider. Login uses an exponential backoff algorithm with an initial wait based on the sasl.login.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.login.retry.backoff.max.ms setting. Currently applies only to OAUTHBEARER.").define("sasl.oauthbearer.scope.claim.name", ConfigDef.Type.STRING, "scope", ConfigDef.Importance.LOW, "The OAuth claim for the scope is often named \"scope\", but this (optional) setting can provide a different name to use for the scope included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.").define("sasl.oauthbearer.sub.claim.name", ConfigDef.Type.STRING, "sub", ConfigDef.Importance.LOW, "The OAuth claim for the subject is often named \"sub\", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.").define("sasl.oauthbearer.token.endpoint.url", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The URL for the OAuth/OIDC identity provider. If the URL is HTTP(S)-based, it is the issuer's token endpoint URL to which requests will be made to login based on the configuration in <code>sasl.oauthbearer.jwt.retriever.class</code>. If the URL is file-based, it specifies a file containing an access token (in JWT serialized form) issued by the OAuth/OIDC identity provider to use for authorization.").define("sasl.oauthbearer.jwks.endpoint.url", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The OAuth/OIDC provider URL from which the provider's <a href=\"https://datatracker.ietf.org/doc/html/rfc7517#section-5\">JWKS (JSON Web Key Set)</a> can be retrieved. The URL can be HTTP(S)-based or file-based. If the URL is HTTP(S)-based, the JWKS data will be retrieved from the OAuth/OIDC provider via the configured URL on broker startup. All then-current keys will be cached on the broker for incoming requests. If an authentication request is received for a JWT that includes a \"kid\" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand. However, the broker polls the URL every sasl.oauthbearer.jwks.endpoint.refresh.ms milliseconds to refresh the cache with any forthcoming keys before any JWT requests that include them are received. If the URL is file-based, the broker will load the JWKS file from a configured location on startup. In the event that the JWT includes a \"kid\" header value that isn't in the JWKS file, the broker will reject the JWT and authentication will fail.").define("sasl.oauthbearer.jwks.endpoint.refresh.ms", ConfigDef.Type.LONG, 3600000L, ConfigDef.Importance.LOW, "The (optional) value in milliseconds for the broker to wait between refreshing its JWKS (JSON Web Key Set) cache that contains the keys to verify the signature of the JWT.").define("sasl.oauthbearer.jwks.endpoint.retry.backoff.ms", ConfigDef.Type.LONG, 100L, ConfigDef.Importance.LOW, "The (optional) value in milliseconds for the initial wait between JWKS (JSON Web Key Set) retrieval attempts from the external authentication provider. JWKS retrieval uses an exponential backoff algorithm with an initial wait based on the sasl.oauthbearer.jwks.endpoint.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms setting.").define("sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms", ConfigDef.Type.LONG, 10000L, ConfigDef.Importance.LOW, "The (optional) value in milliseconds for the maximum wait between attempts to retrieve the JWKS (JSON Web Key Set) from the external authentication provider. JWKS retrieval uses an exponential backoff algorithm with an initial wait based on the sasl.oauthbearer.jwks.endpoint.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms setting.").define("sasl.oauthbearer.clock.skew.seconds", ConfigDef.Type.INT, 30, ConfigDef.Importance.LOW, "The (optional) value in seconds to allow for differences between the time of the OAuth/OIDC identity provider and the broker.").define("sasl.oauthbearer.expected.audience", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "The (optional) comma-delimited setting for the broker to use to verify that the JWT was issued for one of the expected audiences. The JWT will be inspected for the standard OAuth \"aud\" claim and if this value is set, the broker will match the value from JWT's \"aud\" claim  to see if there is an exact match. If there is no match, the broker will reject the JWT and authentication will fail.").define("sasl.oauthbearer.expected.issuer", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The (optional) setting for the broker to use to verify that the JWT was created by the expected issuer. The JWT will be inspected for the standard OAuth \"iss\" claim and if this value is set, the broker will match it exactly against what is in the JWT's \"iss\" claim. If there is no match, the broker will reject the JWT and authentication will fail.").define("sasl.oauthbearer.jwt.retriever.class", ConfigDef.Type.CLASS, "org.apache.kafka.common.security.oauthbearer.DefaultJwtRetriever", ConfigDef.Importance.MEDIUM, "<p>The fully-qualified class name of a <code>JwtRetriever</code> implementation used to request tokens from the identity provider.</p><p>The default configuration value represents a class that maintains backward compatibility with previous versions of Apache Kafka. The default implementation uses the configuration to determine which concrete implementation to create.<p>Other implementations that are provided include:</p><ul><li><code>org.apache.kafka.common.security.oauthbearer.ClientCredentialsJwtRetriever</code></li><li><code>org.apache.kafka.common.security.oauthbearer.DefaultJwtRetriever</code></li><li><code>org.apache.kafka.common.security.oauthbearer.FileJwtRetriever</code></li><li><code>org.apache.kafka.common.security.oauthbearer.JwtBearerJwtRetriever</code></li></ul>").define("sasl.oauthbearer.jwt.validator.class", ConfigDef.Type.CLASS, "org.apache.kafka.common.security.oauthbearer.DefaultJwtValidator", ConfigDef.Importance.MEDIUM, "<p>The fully-qualified class name of a <code>JwtValidator</code> implementation used to validate the JWT from the identity provider.</p><p>The default validator (<code>org.apache.kafka.common.security.oauthbearer.DefaultJwtValidator</code>) maintains backward compatibility with previous versions of Apache Kafka. The default validator uses configuration to determine which concrete implementation to create.<p>The built-in <code>JwtValidator</code> implementations are:</p><ul><li><code>org.apache.kafka.common.security.oauthbearer.BrokerJwtValidator</code></li><li><code>org.apache.kafka.common.security.oauthbearer.ClientJwtValidator</code></li><li><code>org.apache.kafka.common.security.oauthbearer.DefaultJwtValidator</code></li></ul>").define("sasl.oauthbearer.scope", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "<p>This is the level of access a client application is granted to a resource or API which is included in the token request. If provided, it should match one or more scopes configured in the identity provider.</p><p>The scope was previously stored as part of the <code>sasl.jaas.config</code> configuration with the key <code>scope</code>. For backward compatibility, the <code>scope</code> JAAS option can still be used, but it is deprecated and will be removed in a future version.</p><p>Order of precedence:</p><ul><li><code>sasl.oauthbearer.scope</code> from configuration</li><li><code>scope</code> from JAAS</li></ul>").define("sasl.oauthbearer.client.credentials.client.id", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "<p>The ID (defined in/by the OAuth identity provider) to identify the client requesting the token.</p><p>The client ID was previously stored as part of the <code>sasl.jaas.config</code> configuration with the key <code>clientId</code>. For backward compatibility, the <code>clientId</code> JAAS option can still be used, but it is deprecated and will be removed in a future version.</p><p>Order of precedence:</p><ul><li><code>sasl.oauthbearer.client.credentials.client.id</code> from configuration</li><li><code>clientId</code> from JAAS</li></ul>").define("sasl.oauthbearer.client.credentials.client.secret", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "<p>The secret (defined by either the user or preassigned, depending on the identity provider) of the client requesting the token.</p><p>The client secret was previously stored as part of the <code>sasl.jaas.config</code> configuration with the key <code>clientSecret</code>. For backward compatibility, the <code>clientSecret</code> JAAS option can still be used, but it is deprecated and will be removed in a future version.</p><p>Order of precedence:</p><ul><li><code>sasl.oauthbearer.client.credentials.client.secret</code> from configuration</li><li><code>clientSecret</code> from JAAS</li></ul>").define("sasl.oauthbearer.assertion.algorithm", ConfigDef.Type.STRING, (Object)"RS256", ConfigDef.CaseInsensitiveValidString.in("ES256", "RS256"), ConfigDef.Importance.MEDIUM, "<p>The algorithm the Apache Kafka client should use to sign the assertion sent to the identity provider. It is also used as the value of the OAuth <code>alg</code> (Algorithm) header in the JWT assertion.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.claim.aud", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "<p>The JWT <code>aud</code> (Audience) claim which will be included in the  client JWT assertion created locally.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.claim.exp.seconds", ConfigDef.Type.INT, (Object)300, ConfigDef.Range.between(0, 86400), ConfigDef.Importance.LOW, "<p>The number of seconds <em>in the future</em> for which the JWT is valid. The value is used to determine the JWT <code>exp</code> (Expiration) claim based on the current system time when the JWT is created.</p><p>The formula to generate the <code>exp</code> claim is very simple:</p><pre>Let:\n\n  x = the current timestamp in seconds, on client\n  y = the value of this configuration\n\nThen:\n\n  exp = x + y\n</pre><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.claim.iss", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "<p>The value to be used as the <code>iss</code> (Issuer) claim which will be included in the client JWT assertion created locally.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.claim.jti.include", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, "<p>Flag that determines if the JWT assertion should generate a unique ID for the JWT and include it in the <code>jti</code> (JWT ID) claim.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.claim.nbf.seconds", ConfigDef.Type.INT, (Object)60, ConfigDef.Range.between(0, 3600), ConfigDef.Importance.LOW, "<p>The number of seconds <em>in the past</em> from which the JWT is valid. The value is used to determine the JWT <code>nbf</code> (Not Before) claim based on the current system time when the JWT is created.</p><p>The formula to generate the <code>nbf</code> claim is very simple:</p><pre>Let:\n\n  x = the current timestamp in seconds, on client\n  y = the value of this configuration\n\nThen:\n\n  nbf = x - y\n</pre><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.claim.sub", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "<p>The value to be used as the <code>sub</code> (Subject) claim which will be included in the client JWT assertion created locally.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.claim.exp.minutes", ConfigDef.Type.INT, 5, ConfigDef.Importance.LOW, "The (Optional) expiration time for the client assertion in minutesThe default value is 5 minutes").define("sasl.oauthbearer.assertion.file", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "<p>File that contains a <em>pre-generated</em> JWT assertion.</p><p>The underlying implementation caches the file contents to avoid the performance hit of loading the file on each access. The caching mechanism will detect whenthe file changes to allow for the file to be reloaded on modifications. This allows for &quot;live&quot; assertion rotation without restarting the Kafka client.</p><p>The file contains the assertion in the serialized, three part JWT format:</p><ol><li>The <em>header</em> section is a base 64-encoded JWT header that contains values like <code>alg</code> (Algorithm), <code>typ</code> (Type, always the literal value <code>JWT</code>), etc.</li><li>The <em>payload</em> section includes the base 64-encoded set of JWT claims, such as <code>aud</code> (Audience), <code>iss</code> (Issuer), <code>sub</code> (Subject), etc.</li><li>The <em>signature</em> section is the concatenated <em>header</em> and <em>payload</em> sections that was signed using a private key</li></ol><p>See <a href=\"https://datatracker.ietf.org/doc/html/rfc7519\">RFC 7519</a> and <a href=\"https://datatracker.ietf.org/doc/html/rfc7515\">RFC 7515</a> for more details on the JWT and JWS formats.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, all other <code>sasl.oauthbearer.assertion.*</code> configurations are ignored.</p>").define("sasl.oauthbearer.assertion.claim.nbf.include", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW, "The (optional) setting for specifying whether to include \"not before\" (nbf) claim or notIf set to true, nbf claim with (current time - 1 minute) will be included in the client assertion").define("sasl.oauthbearer.assertion.private.key.file", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "<p>File that contains a private key in the standard PEM format which is used to sign the JWT assertion sent to the identity provider.</p><p>The underlying implementation caches the file contents to avoid the performance hit of loading the file on each access. The caching mechanism will detect when the file changes to allow for the file to be reloaded on modifications. This allows for &quot;live&quot; private key rotation without restarting the Kafka client.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.private.key.passphrase", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "<p>The optional passphrase to decrypt the private key file specified by <code>sasl.oauthbearer.assertion.private.key.file</code>.</p><p><em>Note</em>: If the file referred to by <code>sasl.oauthbearer.assertion.private.key.file</code> is modified on the file system at runtime and it was created with a <em>different</em> passphrase than it was previously, the client will not be able to access the private key file because the passphrase is now out of date. For that reason, when using private key passphrases, either use the same passphrase each time, or&mdash;for improved security&mdash;restart the Kafka client using the new passphrase configuration.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.oauthbearer.assertion.template.file", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "<p>This optional configuration specifies the file containing the JWT headers and/or payload claims to be used when creating the JWT assertion.</p><p>Not all identity providers require the same set of claims; some may require a given claim while others may prohibit it. In order to provide the most flexibility, this configuration allows the user to provide the static header values and claims that are to be included in the JWT.</p><p><em>Note</em>: If a value for <code>sasl.oauthbearer.assertion.file</code> is provided, this configuration will be ignored.</p>").define("sasl.server.authn.async.enable", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, "Setting this configuration to true allows the SASL authentication to attempt to perform authentication asynchronously.").define("sasl.server.authn.async.timeout.ms", ConfigDef.Type.LONG, (Object)30000L, ConfigDef.Range.between(0, 60000L), ConfigDef.Importance.MEDIUM, "The broker will attempt to forcibly stop authentication that runs longer than this.").define("sasl.server.authn.async.max.threads", ConfigDef.Type.INT, (Object)1, ConfigDef.Range.atLeast(1), ConfigDef.Importance.MEDIUM, "Maximum number of threads in async authentication thread pool to perform authentication asynchronously.");
}

