/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeShareGroupOffsetsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<DescribeShareGroupOffsetsResponseGroup> groups;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("groups", new CompactArrayOf(DescribeShareGroupOffsetsResponseGroup.SCHEMA_0), "The results for each group."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeShareGroupOffsetsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeShareGroupOffsetsResponseData() {
        this.throttleTimeMs = 0;
        this.groups = new ArrayList<DescribeShareGroupOffsetsResponseGroup>(0);
    }

    @Override
    public short apiKey() {
        return 90;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field groups was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<DescribeShareGroupOffsetsResponseGroup> newCollection = new ArrayList<DescribeShareGroupOffsetsResponseGroup>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DescribeShareGroupOffsetsResponseGroup(_readable, _version, _context));
        }
        this.groups = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.groups.size() + 1);
        for (DescribeShareGroupOffsetsResponseGroup groupsElement : this.groups) {
            groupsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.groups.size() + 1));
        for (DescribeShareGroupOffsetsResponseGroup groupsElement : this.groups) {
            groupsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeShareGroupOffsetsResponseData)) {
            return false;
        }
        DescribeShareGroupOffsetsResponseData other = (DescribeShareGroupOffsetsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        return hashCode;
    }

    @Override
    public DescribeShareGroupOffsetsResponseData duplicate() {
        DescribeShareGroupOffsetsResponseData _duplicate = new DescribeShareGroupOffsetsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<DescribeShareGroupOffsetsResponseGroup> newGroups = new ArrayList<DescribeShareGroupOffsetsResponseGroup>(this.groups.size());
        for (DescribeShareGroupOffsetsResponseGroup _element : this.groups) {
            newGroups.add(_element.duplicate());
        }
        _duplicate.groups = newGroups;
        return _duplicate;
    }

    public String toString() {
        return "DescribeShareGroupOffsetsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", groups=" + MessageUtil.deepToString(this.groups.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DescribeShareGroupOffsetsResponseGroup> groups() {
        return this.groups;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeShareGroupOffsetsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeShareGroupOffsetsResponseData setGroups(List<DescribeShareGroupOffsetsResponseGroup> v) {
        this.groups = v;
        return this;
    }

    public static class DescribeShareGroupOffsetsResponseGroup
    implements Message {
        String groupId;
        List<DescribeShareGroupOffsetsResponseTopic> topics;
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("topics", new CompactArrayOf(DescribeShareGroupOffsetsResponseTopic.SCHEMA_0), "The results for each topic."), new Field("error_code", Type.INT16, "The group-level error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The group-level error message, or null if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public DescribeShareGroupOffsetsResponseGroup(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DescribeShareGroupOffsetsResponseGroup() {
            this.groupId = "";
            this.topics = new ArrayList<DescribeShareGroupOffsetsResponseTopic>(0);
            this.errorCode = 0;
            this.errorMessage = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeShareGroupOffsetsResponseGroup");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _context.read(EntityType.GROUP_ID, _readable.readString(length));
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<DescribeShareGroupOffsetsResponseTopic> newCollection = new ArrayList<DescribeShareGroupOffsetsResponseTopic>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeShareGroupOffsetsResponseTopic(_readable, _version, _context));
            }
            this.topics = newCollection;
            this.errorCode = _readable.readShort();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.groupId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                DescribeShareGroupOffsetsResponseTopic topicsElement = (DescribeShareGroupOffsetsResponseTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version, _context);
            }
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeShareGroupOffsetsResponseGroup");
            }
            Object _stringBytes = _context.write(EntityType.GROUP_ID, this.groupId).getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupId, (byte[])_stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                DescribeShareGroupOffsetsResponseTopic topicsElement = (DescribeShareGroupOffsetsResponseTopic)_stringBytes.next();
                topicsElement.addSize(_size, _cache, _version, _context);
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, (byte[])_stringBytes);
                _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeShareGroupOffsetsResponseGroup)) {
                return false;
            }
            DescribeShareGroupOffsetsResponseGroup other = (DescribeShareGroupOffsetsResponseGroup)obj;
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        @Override
        public DescribeShareGroupOffsetsResponseGroup duplicate() {
            DescribeShareGroupOffsetsResponseGroup _duplicate = new DescribeShareGroupOffsetsResponseGroup();
            _duplicate.groupId = this.groupId;
            ArrayList<DescribeShareGroupOffsetsResponseTopic> newTopics = new ArrayList<DescribeShareGroupOffsetsResponseTopic>(this.topics.size());
            for (DescribeShareGroupOffsetsResponseTopic _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "DescribeShareGroupOffsetsResponseGroup(groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public String groupId() {
            return this.groupId;
        }

        public List<DescribeShareGroupOffsetsResponseTopic> topics() {
            return this.topics;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeShareGroupOffsetsResponseGroup setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponseGroup setTopics(List<DescribeShareGroupOffsetsResponseTopic> v) {
            this.topics = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponseGroup setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponseGroup setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }
    }

    public static class DescribeShareGroupOffsetsResponsePartition
    implements Message {
        int partitionIndex;
        long startOffset;
        int leaderEpoch;
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("start_offset", Type.INT64, "The share-partition start offset."), new Field("leader_epoch", Type.INT32, "The leader epoch of the partition."), new Field("error_code", Type.INT16, "The partition-level error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The partition-level error message, or null if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public DescribeShareGroupOffsetsResponsePartition(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DescribeShareGroupOffsetsResponsePartition() {
            this.partitionIndex = 0;
            this.startOffset = 0L;
            this.leaderEpoch = 0;
            this.errorCode = 0;
            this.errorMessage = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeShareGroupOffsetsResponsePartition");
            }
            this.partitionIndex = _readable.readInt();
            this.startOffset = _readable.readLong();
            this.leaderEpoch = _readable.readInt();
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.startOffset);
            _writable.writeInt(this.leaderEpoch);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeShareGroupOffsetsResponsePartition");
            }
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeShareGroupOffsetsResponsePartition)) {
                return false;
            }
            DescribeShareGroupOffsetsResponsePartition other = (DescribeShareGroupOffsetsResponsePartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.startOffset != other.startOffset) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.startOffset >> 32) ^ (int)this.startOffset);
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        @Override
        public DescribeShareGroupOffsetsResponsePartition duplicate() {
            DescribeShareGroupOffsetsResponsePartition _duplicate = new DescribeShareGroupOffsetsResponsePartition();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.startOffset = this.startOffset;
            _duplicate.leaderEpoch = this.leaderEpoch;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "DescribeShareGroupOffsetsResponsePartition(partitionIndex=" + this.partitionIndex + ", startOffset=" + this.startOffset + ", leaderEpoch=" + this.leaderEpoch + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long startOffset() {
            return this.startOffset;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeShareGroupOffsetsResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponsePartition setStartOffset(long v) {
            this.startOffset = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponsePartition setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponsePartition setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }
    }

    public static class DescribeShareGroupOffsetsResponseTopic
    implements Message {
        String topicName;
        Uuid topicId;
        List<DescribeShareGroupOffsetsResponsePartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("topic_id", Type.UUID, "The unique topic ID."), new Field("partitions", new CompactArrayOf(DescribeShareGroupOffsetsResponsePartition.SCHEMA_0), ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public DescribeShareGroupOffsetsResponseTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DescribeShareGroupOffsetsResponseTopic() {
            this.topicName = "";
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<DescribeShareGroupOffsetsResponsePartition>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeShareGroupOffsetsResponseTopic");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<DescribeShareGroupOffsetsResponsePartition> newCollection = new ArrayList<DescribeShareGroupOffsetsResponsePartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeShareGroupOffsetsResponsePartition(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                DescribeShareGroupOffsetsResponsePartition partitionsElement = (DescribeShareGroupOffsetsResponsePartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeShareGroupOffsetsResponseTopic");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topicName).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (DescribeShareGroupOffsetsResponsePartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeShareGroupOffsetsResponseTopic)) {
                return false;
            }
            DescribeShareGroupOffsetsResponseTopic other = (DescribeShareGroupOffsetsResponseTopic)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public DescribeShareGroupOffsetsResponseTopic duplicate() {
            DescribeShareGroupOffsetsResponseTopic _duplicate = new DescribeShareGroupOffsetsResponseTopic();
            _duplicate.topicName = this.topicName;
            _duplicate.topicId = this.topicId;
            ArrayList<DescribeShareGroupOffsetsResponsePartition> newPartitions = new ArrayList<DescribeShareGroupOffsetsResponsePartition>(this.partitions.size());
            for (DescribeShareGroupOffsetsResponsePartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "DescribeShareGroupOffsetsResponseTopic(topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<DescribeShareGroupOffsetsResponsePartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeShareGroupOffsetsResponseTopic setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponseTopic setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public DescribeShareGroupOffsetsResponseTopic setPartitions(List<DescribeShareGroupOffsetsResponsePartition> v) {
            this.partitions = v;
            return this;
        }
    }
}

