/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class RemoveBrokersRequestDataJsonConverter {
    public static RemoveBrokersRequestData read(JsonNode _node, short _version) {
        RemoveBrokersRequestData _object = new RemoveBrokersRequestData();
        JsonNode _timeoutMsNode = _node.get("timeoutMs");
        if (_timeoutMsNode == null) {
            throw new RuntimeException("RemoveBrokersRequestData: unable to locate field 'timeoutMs', which is mandatory in version " + _version);
        }
        _object.timeoutMs = MessageUtil.jsonNodeToInt(_timeoutMsNode, "RemoveBrokersRequestData");
        JsonNode _brokersToRemoveNode = _node.get("brokersToRemove");
        if (_brokersToRemoveNode == null) {
            throw new RuntimeException("RemoveBrokersRequestData: unable to locate field 'brokersToRemove', which is mandatory in version " + _version);
        }
        if (!_brokersToRemoveNode.isArray()) {
            throw new RuntimeException("RemoveBrokersRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<RemoveBrokersRequestData.BrokerId> _collection = new ArrayList<RemoveBrokersRequestData.BrokerId>(_brokersToRemoveNode.size());
        _object.brokersToRemove = _collection;
        for (JsonNode _element : _brokersToRemoveNode) {
            _collection.add(BrokerIdJsonConverter.read(_element, _version));
        }
        JsonNode _shouldShutdownNode = _node.get("shouldShutdown");
        if (_shouldShutdownNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("RemoveBrokersRequestData: unable to locate field 'shouldShutdown', which is mandatory in version " + _version);
            }
            _object.shouldShutdown = true;
        } else {
            if (!_shouldShutdownNode.isBoolean()) {
                throw new RuntimeException("RemoveBrokersRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.shouldShutdown = _shouldShutdownNode.asBoolean();
        }
        return _object;
    }

    public static JsonNode write(RemoveBrokersRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("timeoutMs", (JsonNode)new IntNode(_object.timeoutMs));
        ArrayNode _brokersToRemoveArray = new ArrayNode(JsonNodeFactory.instance);
        for (RemoveBrokersRequestData.BrokerId _element : _object.brokersToRemove) {
            _brokersToRemoveArray.add(BrokerIdJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("brokersToRemove", (JsonNode)_brokersToRemoveArray);
        if (_version >= 1) {
            _node.set("shouldShutdown", (JsonNode)BooleanNode.valueOf((boolean)_object.shouldShutdown));
        } else if (!_object.shouldShutdown) {
            throw new UnsupportedVersionException("Attempted to write a non-default shouldShutdown at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(RemoveBrokersRequestData _object, short _version) {
        return RemoveBrokersRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class BrokerIdJsonConverter {
        public static RemoveBrokersRequestData.BrokerId read(JsonNode _node, short _version) {
            RemoveBrokersRequestData.BrokerId _object = new RemoveBrokersRequestData.BrokerId();
            JsonNode _brokerIdNode = _node.get("brokerId");
            if (_brokerIdNode == null) {
                throw new RuntimeException("BrokerId: unable to locate field 'brokerId', which is mandatory in version " + _version);
            }
            _object.brokerId = MessageUtil.jsonNodeToInt(_brokerIdNode, "BrokerId");
            return _object;
        }

        public static JsonNode write(RemoveBrokersRequestData.BrokerId _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
            return _node;
        }

        public static JsonNode write(RemoveBrokersRequestData.BrokerId _object, short _version) {
            return BrokerIdJsonConverter.write(_object, _version, true);
        }
    }
}

