/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class EventLoopThreadFactory
implements ThreadFactory {
    private final AtomicLong threadId = new AtomicLong(0L);
    private final String namePrefix;
    private final boolean daemon;

    EventLoopThreadFactory(String namePrefix, boolean daemon) {
        this.namePrefix = namePrefix;
        this.daemon = daemon;
    }

    public static EventLoopThreadFactory create(String namePrefix) {
        return new EventLoopThreadFactory(namePrefix, false);
    }

    public static EventLoopThreadFactory create(String namePrefix, boolean daemon) {
        return new EventLoopThreadFactory(namePrefix, daemon);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = Executors.defaultThreadFactory().newThread(runnable);
        t.setName(this.namePrefix + this.threadId.getAndIncrement());
        t.setDaemon(this.daemon);
        return t;
    }
}

