/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import io.netty.buffer.ByteBuf;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.LogInputStream;
import org.apache.kafka.common.record.MutableRecordBatch;

public class ByteBufLogInputStream
implements LogInputStream<MutableRecordBatch> {
    private final ByteBuf buffer;
    private final int maxMessageSize;

    public ByteBufLogInputStream(ByteBuf buffer, int maxMessageSize) {
        this.buffer = buffer;
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    public MutableRecordBatch nextBatch() {
        int remaining = this.buffer.readableBytes();
        Integer batchSize = this.nextBatchSize();
        if (batchSize == null || remaining < batchSize) {
            return null;
        }
        byte magic = this.buffer.getByte(this.buffer.readerIndex() + 16);
        ByteBuf batchSlice = this.buffer.readSlice(batchSize.intValue());
        if (magic > 1) {
            return new DefaultRecordBatch(batchSlice.nioBuffer());
        }
        return new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(batchSlice.nioBuffer());
    }

    Integer nextBatchSize() throws CorruptRecordException {
        int remaining = this.buffer.readableBytes();
        if (remaining < 12) {
            return null;
        }
        int recordSize = this.buffer.getInt(this.buffer.readerIndex() + 8);
        if (recordSize < 14) {
            throw new CorruptRecordException(String.format("Record size %d is less than the minimum record overhead (%d)", recordSize, 14));
        }
        if (recordSize > this.maxMessageSize) {
            throw new CorruptRecordException(String.format("Record size %d exceeds the largest allowable message size (%d).", recordSize, this.maxMessageSize));
        }
        if (remaining < 17) {
            return null;
        }
        byte magic = this.buffer.getByte(this.buffer.readerIndex() + 16);
        if (magic < 0 || magic > 2) {
            throw new CorruptRecordException("Invalid magic found in record: " + magic);
        }
        return recordSize + 12;
    }
}

