/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.ClientAssertion;
import io.confluent.kafka.security.oauthbearer.ClientAssertionHttpRequestFormatter;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ClientAssertionHttpRequestFormatterTest {
    ClientAssertionHttpRequestFormatterTest() {
    }

    @Test
    void testInitialization() {
        ClientAssertion mockedclientAssertion = (ClientAssertion)Mockito.mock(ClientAssertion.class);
        ClientAssertionHttpRequestFormatter formatter = new ClientAssertionHttpRequestFormatter(mockedclientAssertion, null, null);
        Assertions.assertNotNull((Object)formatter);
    }

    @Test
    void testGetRequestHeader() {
        ClientAssertion mockedclientAssertion = (ClientAssertion)Mockito.mock(ClientAssertion.class);
        ClientAssertionHttpRequestFormatter formatter = new ClientAssertionHttpRequestFormatter(mockedclientAssertion, null, null);
        Map headers = formatter.formatHeaders();
        Assertions.assertEquals((int)0, (int)headers.size());
    }

    @Test
    void testGetRequestBodyWithScope() throws IOException {
        ClientAssertion mockedclientAssertion = (ClientAssertion)Mockito.mock(ClientAssertion.class);
        Mockito.when((Object)mockedclientAssertion.getJwt()).thenReturn((Object)"mockJwt");
        ClientAssertionHttpRequestFormatter formatter = new ClientAssertionHttpRequestFormatter(mockedclientAssertion, null, "testScope");
        String requestBody = formatter.formatBody();
        Assertions.assertNotNull((Object)requestBody);
        Assertions.assertTrue((boolean)requestBody.contains("client_assertion_type=urn%3Aietf%3Aparams%3Aoauth%3Aclient-assertion-type%3Ajwt-bearer"));
        Assertions.assertTrue((boolean)requestBody.contains("&client_assertion=mockJwt"));
        Assertions.assertTrue((boolean)requestBody.contains("&grant_type=client_credentials"));
        Assertions.assertTrue((boolean)requestBody.contains("&scope=testScope"));
    }

    @Test
    void testGetRequestBodyWithoutScope() throws IOException {
        ClientAssertion clientAssertion = (ClientAssertion)Mockito.mock(ClientAssertion.class);
        Mockito.when((Object)clientAssertion.getJwt()).thenReturn((Object)"mockJwt");
        ClientAssertionHttpRequestFormatter formatter = new ClientAssertionHttpRequestFormatter(clientAssertion, null, null);
        String requestBody = formatter.formatBody();
        Assertions.assertNotNull((Object)requestBody);
        Assertions.assertTrue((boolean)requestBody.contains("client_assertion_type=urn%3Aietf%3Aparams%3Aoauth%3Aclient-assertion-type%3Ajwt-bearer"));
        Assertions.assertTrue((boolean)requestBody.contains("&client_assertion=mockJwt"));
        Assertions.assertTrue((boolean)requestBody.contains("&grant_type=client_credentials"));
        Assertions.assertFalse((boolean)requestBody.contains("&scope="));
    }

    @Test
    void testGetRequestBodyWithClientId() throws IOException {
        ClientAssertion clientAssertion = (ClientAssertion)Mockito.mock(ClientAssertion.class);
        Mockito.when((Object)clientAssertion.getJwt()).thenReturn((Object)"mockJwt");
        ClientAssertionHttpRequestFormatter formatter = new ClientAssertionHttpRequestFormatter(clientAssertion, "client_app1", null);
        String requestBody = formatter.formatBody();
        Assertions.assertNotNull((Object)requestBody);
        Assertions.assertTrue((boolean)requestBody.contains("client_assertion_type=urn%3Aietf%3Aparams%3Aoauth%3Aclient-assertion-type%3Ajwt-bearer"));
        Assertions.assertTrue((boolean)requestBody.contains("&client_assertion=mockJwt"));
        Assertions.assertTrue((boolean)requestBody.contains("&grant_type=client_credentials"));
        Assertions.assertTrue((boolean)requestBody.contains("&client_id=client_app1"));
        Assertions.assertFalse((boolean)requestBody.contains("&scope="));
    }

    @Test
    void testGetRequestBodyWithoutClientId() throws IOException {
        ClientAssertion clientAssertion = (ClientAssertion)Mockito.mock(ClientAssertion.class);
        Mockito.when((Object)clientAssertion.getJwt()).thenReturn((Object)"mockJwt");
        ClientAssertionHttpRequestFormatter formatter = new ClientAssertionHttpRequestFormatter(clientAssertion, null, "");
        String requestBody = formatter.formatBody();
        ClientAssertionHttpRequestFormatter formatter1 = new ClientAssertionHttpRequestFormatter(clientAssertion, null, null);
        String requestBody1 = formatter1.formatBody();
        Assertions.assertNotNull((Object)requestBody);
        Assertions.assertTrue((boolean)requestBody.contains("client_assertion_type=urn%3Aietf%3Aparams%3Aoauth%3Aclient-assertion-type%3Ajwt-bearer"));
        Assertions.assertTrue((boolean)requestBody.contains("&client_assertion=mockJwt"));
        Assertions.assertTrue((boolean)requestBody.contains("&grant_type=client_credentials"));
        Assertions.assertFalse((boolean)requestBody.contains("&client_id="));
        Assertions.assertFalse((boolean)requestBody.contains("&scope="));
        Assertions.assertFalse((boolean)requestBody1.contains("&client_id="));
    }
}

