/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeleteConsumerGroupOffsetsResultTest {
    private final String topic = "topic";
    private final TopicPartition tpZero = new TopicPartition("topic", 0);
    private final TopicPartition tpOne = new TopicPartition("topic", 1);
    private Set<TopicPartition> partitions;
    private Map<TopicPartition, Errors> errorsMap;
    private KafkaFutureImpl<Map<TopicPartition, Errors>> partitionFutures;

    @BeforeEach
    public void setUp() {
        this.partitionFutures = new KafkaFutureImpl();
        this.partitions = new HashSet<TopicPartition>();
        this.partitions.add(this.tpZero);
        this.partitions.add(this.tpOne);
        this.errorsMap = new HashMap<TopicPartition, Errors>();
        this.errorsMap.put(this.tpZero, Errors.NONE);
        this.errorsMap.put(this.tpOne, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testTopLevelErrorConstructor() {
        this.partitionFutures.completeExceptionally((Throwable)Errors.GROUP_AUTHORIZATION_FAILED.exception());
        DeleteConsumerGroupOffsetsResult topLevelErrorResult = new DeleteConsumerGroupOffsetsResult(this.partitionFutures, this.partitions);
        TestUtils.assertFutureThrows(GroupAuthorizationException.class, topLevelErrorResult.all());
    }

    @Test
    public void testPartitionLevelErrorConstructor() throws ExecutionException, InterruptedException {
        this.createAndVerifyPartitionLevelError();
    }

    @Test
    public void testPartitionMissingInResponseErrorConstructor() throws InterruptedException, ExecutionException {
        this.errorsMap.remove(this.tpOne);
        this.partitionFutures.complete(this.errorsMap);
        Assertions.assertFalse((boolean)this.partitionFutures.isCompletedExceptionally());
        DeleteConsumerGroupOffsetsResult missingPartitionResult = new DeleteConsumerGroupOffsetsResult(this.partitionFutures, this.partitions);
        TestUtils.assertFutureThrows(IllegalArgumentException.class, missingPartitionResult.all());
        Assertions.assertNull((Object)missingPartitionResult.partitionResult(this.tpZero).get());
        TestUtils.assertFutureThrows(IllegalArgumentException.class, missingPartitionResult.partitionResult(this.tpOne));
    }

    @Test
    public void testPartitionMissingInRequestErrorConstructor() throws InterruptedException, ExecutionException {
        DeleteConsumerGroupOffsetsResult partitionLevelErrorResult = this.createAndVerifyPartitionLevelError();
        Assertions.assertThrows(IllegalArgumentException.class, () -> partitionLevelErrorResult.partitionResult(new TopicPartition("invalid-topic", 0)));
    }

    @Test
    public void testNoErrorConstructor() throws ExecutionException, InterruptedException {
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.tpZero, Errors.NONE);
        errorsMap.put(this.tpOne, Errors.NONE);
        DeleteConsumerGroupOffsetsResult noErrorResult = new DeleteConsumerGroupOffsetsResult(this.partitionFutures, this.partitions);
        this.partitionFutures.complete(errorsMap);
        Assertions.assertNull((Object)noErrorResult.all().get());
        Assertions.assertNull((Object)noErrorResult.partitionResult(this.tpZero).get());
        Assertions.assertNull((Object)noErrorResult.partitionResult(this.tpOne).get());
    }

    private DeleteConsumerGroupOffsetsResult createAndVerifyPartitionLevelError() throws InterruptedException, ExecutionException {
        this.partitionFutures.complete(this.errorsMap);
        Assertions.assertFalse((boolean)this.partitionFutures.isCompletedExceptionally());
        DeleteConsumerGroupOffsetsResult partitionLevelErrorResult = new DeleteConsumerGroupOffsetsResult(this.partitionFutures, this.partitions);
        TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, partitionLevelErrorResult.all());
        Assertions.assertNull((Object)partitionLevelErrorResult.partitionResult(this.tpZero).get());
        TestUtils.assertFutureThrows(UnknownTopicOrPartitionException.class, partitionLevelErrorResult.partitionResult(this.tpOne));
        return partitionLevelErrorResult;
    }
}

