/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeUserScramCredentialsResultTest {
    @Test
    public void testTopLevelError() {
        KafkaFutureImpl dataFuture = new KafkaFutureImpl();
        dataFuture.completeExceptionally((Throwable)new RuntimeException());
        DescribeUserScramCredentialsResult results = new DescribeUserScramCredentialsResult((KafkaFuture)dataFuture);
        try {
            results.all().get();
            Assertions.fail((String)"expected all() to fail when there is a top-level error");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            results.users().get();
            Assertions.fail((String)"expected users() to fail when there is a top-level error");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            results.description("whatever").get();
            Assertions.fail((String)"expected description() to fail when there is a top-level error");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUserLevelErrors() throws Exception {
        String goodUser = "goodUser";
        String unknownUser = "unknownUser";
        String failedUser = "failedUser";
        KafkaFutureImpl dataFuture = new KafkaFutureImpl();
        ScramMechanism scramSha256 = ScramMechanism.SCRAM_SHA_256;
        int iterations = 4096;
        dataFuture.complete((Object)new DescribeUserScramCredentialsResponseData().setErrorCode(Errors.NONE.code()).setResults(Arrays.asList(new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser(goodUser).setCredentialInfos(Collections.singletonList(new DescribeUserScramCredentialsResponseData.CredentialInfo().setMechanism(scramSha256.type()).setIterations(iterations))), new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser(unknownUser).setErrorCode(Errors.RESOURCE_NOT_FOUND.code()), new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser(failedUser).setErrorCode(Errors.DUPLICATE_RESOURCE.code()))));
        DescribeUserScramCredentialsResult results = new DescribeUserScramCredentialsResult((KafkaFuture)dataFuture);
        try {
            results.all().get();
            Assertions.fail((String)"expected all() to fail when there is a user-level error");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals(Arrays.asList(goodUser, failedUser), (Object)results.users().get(), (String)"Expected 2 users with credentials");
        UserScramCredentialsDescription goodUserDescription = (UserScramCredentialsDescription)results.description(goodUser).get();
        Assertions.assertEquals((Object)new UserScramCredentialsDescription(goodUser, Collections.singletonList(new ScramCredentialInfo(scramSha256, iterations))), (Object)goodUserDescription);
        try {
            results.description(failedUser).get();
            Assertions.fail((String)"expected description(failedUser) to fail when there is a user-level error");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            results.description(unknownUser).get();
            Assertions.fail((String)"expected description(unknownUser) to fail when there is no such user");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSuccessfulDescription() throws Exception {
        String goodUser = "goodUser";
        String unknownUser = "unknownUser";
        KafkaFutureImpl dataFuture = new KafkaFutureImpl();
        ScramMechanism scramSha256 = ScramMechanism.SCRAM_SHA_256;
        int iterations = 4096;
        dataFuture.complete((Object)new DescribeUserScramCredentialsResponseData().setErrorCode(Errors.NONE.code()).setResults(Collections.singletonList(new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser(goodUser).setCredentialInfos(Collections.singletonList(new DescribeUserScramCredentialsResponseData.CredentialInfo().setMechanism(scramSha256.type()).setIterations(iterations))))));
        DescribeUserScramCredentialsResult results = new DescribeUserScramCredentialsResult((KafkaFuture)dataFuture);
        Assertions.assertEquals(Collections.singletonList(goodUser), (Object)results.users().get(), (String)"Expected 1 user with credentials");
        Map allResults = (Map)results.all().get();
        Assertions.assertEquals((int)1, (int)allResults.size());
        UserScramCredentialsDescription goodUserDescriptionViaAll = (UserScramCredentialsDescription)allResults.get(goodUser);
        Assertions.assertEquals((Object)new UserScramCredentialsDescription(goodUser, Collections.singletonList(new ScramCredentialInfo(scramSha256, iterations))), (Object)goodUserDescriptionViaAll);
        Assertions.assertEquals((Object)goodUserDescriptionViaAll, (Object)results.description(goodUser).get(), (String)"Expected same thing via all() and description()");
        try {
            results.description(unknownUser).get();
            Assertions.fail((String)"expected description(unknownUser) to fail when there is no such user even when all() succeeds");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

