/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ShareConsumerConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShareConsumerConfigTest {
    @Test
    public void testUnsupportedShareConsumerConfigs() {
        this.verifyUnsupportedShareConsumerConfig(Map.of("auto.offset.reset", "earliest"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("enable.auto.commit", "true"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("group.instance.id", "1"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("isolation.level", "read_committed"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("partition.assignment.strategy", "org.apache.kafka.clients.consumer.StickyAssignor"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("interceptor.classes", "org.apache.kafka.clients.consumer.ConsumerInterceptor"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("session.timeout.ms", "3000"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("heartbeat.interval.ms", "3000"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("group.protocol", "classic"));
        this.verifyUnsupportedShareConsumerConfig(Map.of("group.remote.assignor", "null"));
    }

    private void verifyUnsupportedShareConsumerConfig(Map<String, Object> extraConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("group.id", "1");
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.putAll(extraConfig);
        Assertions.assertThrows(ConfigException.class, () -> new ShareConsumerConfig(props));
    }
}

