/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.List;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.internals.AcknowledgementBatch;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AcknowledgementsTest {
    private final Acknowledgements acks = Acknowledgements.empty();
    private final int maxRecordsWithSameAcknowledgeType = 10;

    @Test
    public void testEmptyBatch() {
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertTrue((boolean)ackList.isEmpty());
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertTrue((boolean)ackList2.isEmpty());
    }

    @Test
    public void testSingleStateSingleRecord() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
    }

    @Test
    public void testSingleStateMultiRecord() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        this.acks.add(1L, AcknowledgeType.ACCEPT);
        this.acks.add(2L, AcknowledgeType.ACCEPT);
        this.acks.add(3L, AcknowledgeType.ACCEPT);
        this.acks.add(4L, AcknowledgeType.ACCEPT);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertNotEquals((int)0, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertNotEquals((int)0, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
    }

    @Test
    public void testSingleAcknowledgementTypeExceedingLimit() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.acks.add((long)i, AcknowledgeType.ACCEPT);
        }
        this.acks.add((long)i++, AcknowledgeType.ACCEPT);
        this.acks.add((long)i++, AcknowledgeType.ACCEPT);
        for (int j = 0; j <= 10; ++j) {
            this.acks.add((long)(i + j), AcknowledgeType.REJECT);
        }
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)2, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)11L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((long)12L, (long)((AcknowledgementBatch)ackList.get(1)).firstOffset());
        Assertions.assertEquals((long)(i + 10), (long)((AcknowledgementBatch)ackList.get(1)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(1)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.REJECT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(1)).acknowledgeTypes().get(0)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)2, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)11L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((long)12L, (long)((AcknowledgementBatch)ackList2.get(1)).firstOffset());
        Assertions.assertEquals((long)(i + 10), (long)((AcknowledgementBatch)ackList2.get(1)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(1)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.REJECT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(1)).acknowledgeTypes().get(0)));
    }

    @Test
    public void testSingleAcknowledgementTypeWithGap() {
        for (int i = 0; i < 10; ++i) {
            this.acks.add((long)i, null);
        }
        this.acks.add(10L, null);
        this.acks.add(11L, null);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)11L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)11L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
    }

    @Test
    public void testOptimiseBatches() {
        int offset;
        for (offset = 0; offset < 10; ++offset) {
            this.acks.add((long)offset, AcknowledgeType.ACCEPT);
        }
        this.acks.add((long)offset++, AcknowledgeType.REJECT);
        this.acks.add((long)offset++, AcknowledgeType.ACCEPT);
        this.acks.add((long)offset++, AcknowledgeType.RELEASE);
        this.acks.add((long)offset++, null);
        for (int j = 0; j <= 10; ++j) {
            this.acks.add((long)(offset + j), AcknowledgeType.ACCEPT);
        }
        offset += 11;
        this.acks.add((long)offset++, AcknowledgeType.REJECT);
        this.acks.add((long)offset, AcknowledgeType.RELEASE);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)3, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)13L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((long)14L, (long)((AcknowledgementBatch)ackList.get(1)).firstOffset());
        Assertions.assertEquals((long)24L, (long)((AcknowledgementBatch)ackList.get(1)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(1)).acknowledgeTypes().size());
        Assertions.assertEquals((long)(offset - 1), (long)((AcknowledgementBatch)ackList.get(2)).firstOffset());
        Assertions.assertEquals((long)offset, (long)((AcknowledgementBatch)ackList.get(2)).lastOffset());
        Assertions.assertEquals((int)2, (int)((AcknowledgementBatch)ackList.get(2)).acknowledgeTypes().size());
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)3, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)13L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((long)14L, (long)((AcknowledgementBatch)ackList2.get(1)).firstOffset());
        Assertions.assertEquals((long)24L, (long)((AcknowledgementBatch)ackList2.get(1)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(1)).acknowledgeTypes().size());
        Assertions.assertEquals((long)(offset - 1), (long)((AcknowledgementBatch)ackList2.get(2)).firstOffset());
        Assertions.assertEquals((long)offset, (long)((AcknowledgementBatch)ackList2.get(2)).lastOffset());
        Assertions.assertEquals((int)2, (int)((AcknowledgementBatch)ackList2.get(2)).acknowledgeTypes().size());
    }

    @Test
    public void testSingleAcknowledgementTypeWithinLimit() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        this.acks.add(1L, AcknowledgeType.ACCEPT);
        this.acks.add(2L, AcknowledgeType.ACCEPT);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
    }

    @Test
    public void testMultiStateMultiRecord() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        this.acks.add(1L, AcknowledgeType.ACCEPT);
        this.acks.add(2L, AcknowledgeType.ACCEPT);
        this.acks.add(3L, AcknowledgeType.RELEASE);
        this.acks.add(4L, AcknowledgeType.RELEASE);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(4)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(4)));
    }

    @Test
    public void testMultiStateSingleMultiRecord() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        this.acks.add(1L, AcknowledgeType.RELEASE);
        this.acks.add(2L, AcknowledgeType.RELEASE);
        this.acks.add(3L, AcknowledgeType.RELEASE);
        this.acks.add(4L, AcknowledgeType.RELEASE);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(4)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(4)));
    }

    @Test
    public void testMultiStateMultiSingleRecord() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        this.acks.add(1L, AcknowledgeType.ACCEPT);
        this.acks.add(2L, AcknowledgeType.ACCEPT);
        this.acks.add(3L, AcknowledgeType.ACCEPT);
        this.acks.add(4L, AcknowledgeType.RELEASE);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(4)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(4)));
    }

    @Test
    public void testSingleGap() {
        this.acks.addGap(0L);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
    }

    @Test
    public void testMultiGap() {
        this.acks.addGap(0L);
        this.acks.addGap(1L);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
    }

    @Test
    public void testSingleGapSingleState() {
        this.acks.addGap(0L);
        this.acks.add(1L, AcknowledgeType.ACCEPT);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)2, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(1)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)2, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(1)));
    }

    @Test
    public void testSingleStateSingleGap() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        this.acks.addGap(1L);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)2, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(1)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)2, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(1)));
    }

    @Test
    public void testMultiStateMultiGap() {
        this.acks.add(0L, AcknowledgeType.RELEASE);
        this.acks.addGap(1L);
        this.acks.addGap(2L);
        this.acks.add(3L, AcknowledgeType.ACCEPT);
        this.acks.add(4L, AcknowledgeType.ACCEPT);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(4)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(4)));
    }

    @Test
    public void testMultiStateMultiGaps() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        this.acks.add(1L, AcknowledgeType.RELEASE);
        this.acks.addGap(2L);
        this.acks.add(3L, AcknowledgeType.RELEASE);
        this.acks.addGap(4L);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(4)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)1, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)5, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(2)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(3)));
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(4)));
    }

    @Test
    public void testNoncontiguousBatches() {
        this.acks.add(0L, AcknowledgeType.ACCEPT);
        this.acks.add(1L, AcknowledgeType.RELEASE);
        this.acks.add(3L, AcknowledgeType.REJECT);
        this.acks.add(4L, AcknowledgeType.REJECT);
        this.acks.add(6L, AcknowledgeType.REJECT);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)3, (int)ackList.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)2, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((long)3L, (long)((AcknowledgementBatch)ackList.get(1)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(1)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(1)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.REJECT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(1)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((long)6L, (long)((AcknowledgementBatch)ackList.get(2)).firstOffset());
        Assertions.assertEquals((long)6L, (long)((AcknowledgementBatch)ackList.get(2)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(2)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.REJECT.id, (Byte)((Byte)((AcknowledgementBatch)ackList.get(2)).acknowledgeTypes().get(0)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)3, (int)ackList2.size());
        Assertions.assertEquals((long)0L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)1L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)2, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.ACCEPT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((byte)AcknowledgeType.RELEASE.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(1)));
        Assertions.assertEquals((long)3L, (long)((AcknowledgementBatch)ackList2.get(1)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(1)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(1)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.REJECT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(1)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((long)6L, (long)((AcknowledgementBatch)ackList2.get(2)).firstOffset());
        Assertions.assertEquals((long)6L, (long)((AcknowledgementBatch)ackList2.get(2)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(2)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)AcknowledgeType.REJECT.id, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(2)).acknowledgeTypes().get(0)));
    }

    @Test
    public void testNoncontiguousGaps() {
        this.acks.addGap(2L);
        this.acks.addGap(4L);
        List ackList = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)2, (int)ackList.size());
        Assertions.assertEquals((long)2L, (long)((AcknowledgementBatch)ackList.get(0)).firstOffset());
        Assertions.assertEquals((long)2L, (long)((AcknowledgementBatch)ackList.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(1)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList.get(1)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList.get(1)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList.get(1)).acknowledgeTypes().get(0)));
        List ackList2 = this.acks.getAcknowledgementBatches();
        Assertions.assertEquals((int)2, (int)ackList2.size());
        Assertions.assertEquals((long)2L, (long)((AcknowledgementBatch)ackList2.get(0)).firstOffset());
        Assertions.assertEquals((long)2L, (long)((AcknowledgementBatch)ackList2.get(0)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(0)).acknowledgeTypes().get(0)));
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(1)).firstOffset());
        Assertions.assertEquals((long)4L, (long)((AcknowledgementBatch)ackList2.get(1)).lastOffset());
        Assertions.assertEquals((int)1, (int)((AcknowledgementBatch)ackList2.get(1)).acknowledgeTypes().size());
        Assertions.assertEquals((byte)0, (Byte)((Byte)((AcknowledgementBatch)ackList2.get(1)).acknowledgeTypes().get(0)));
    }
}

