/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.FetchMetricsRegistry;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FetchMetricsManagerTest {
    private static final double EPSILON = 1.0E-4;
    private final Time time = new MockTime(1L, 0L, 0L);
    private static final String TOPIC_NAME = "test";
    private Metrics metrics;
    private FetchMetricsRegistry metricsRegistry;
    private FetchMetricsManager metricsManager;

    @BeforeEach
    public void setup() {
        this.metrics = new Metrics(this.time);
        this.metricsRegistry = new FetchMetricsRegistry(this.metrics.config().tags().keySet(), TOPIC_NAME);
        this.metricsManager = new FetchMetricsManager(this.metrics, this.metricsRegistry);
    }

    @AfterEach
    public void tearDown() {
        if (this.metrics != null) {
            this.metrics.close();
            this.metrics = null;
        }
        this.metricsManager = null;
    }

    @Test
    public void testLatency() {
        this.metricsManager.recordLatency("", 123L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordLatency("", 456L);
        Assertions.assertEquals((double)289.5, (double)this.metricValue(this.metricsRegistry.fetchLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)456.0, (double)this.metricValue(this.metricsRegistry.fetchLatencyMax), (double)1.0E-4);
    }

    @Test
    public void testNodeLatency() {
        String connectionId = "0";
        MetricName nodeLatencyAvg = this.metrics.metricName("request-latency-avg", "group");
        MetricName nodeLatencyMax = this.metrics.metricName("request-latency-max", "group");
        this.registerNodeLatencyMetric(connectionId, nodeLatencyAvg, nodeLatencyMax);
        this.metricsManager.recordLatency(connectionId, 123L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordLatency(connectionId, 456L);
        Assertions.assertEquals((double)289.5, (double)this.metricValue(this.metricsRegistry.fetchLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)456.0, (double)this.metricValue(this.metricsRegistry.fetchLatencyMax), (double)1.0E-4);
        Assertions.assertEquals((double)289.5, (double)this.metricValue(nodeLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)456.0, (double)this.metricValue(nodeLatencyMax), (double)1.0E-4);
        this.metricsManager.recordLatency("1", 501L);
        Assertions.assertEquals((double)360.0, (double)this.metricValue(this.metricsRegistry.fetchLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)501.0, (double)this.metricValue(this.metricsRegistry.fetchLatencyMax), (double)1.0E-4);
        Assertions.assertEquals((double)289.5, (double)this.metricValue(nodeLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)456.0, (double)this.metricValue(nodeLatencyMax), (double)1.0E-4);
    }

    @Test
    public void testBytesFetched() {
        this.metricsManager.recordBytesFetched(2);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordBytesFetched(10);
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.fetchSizeAvg), (double)1.0E-4);
        Assertions.assertEquals((double)10.0, (double)this.metricValue(this.metricsRegistry.fetchSizeMax), (double)1.0E-4);
    }

    @Test
    public void testBytesFetchedTopic() {
        String topicName1 = TOPIC_NAME;
        String topicName2 = "another.topic";
        Map<String, String> tags1 = Map.of("topic", topicName1);
        Map<String, String> tags2 = Map.of("topic", topicName2);
        Map deprecatedTags = FetchMetricsManager.topicTags((String)topicName2);
        int initialMetricsSize = this.metrics.metrics().size();
        this.metricsManager.recordBytesFetched(topicName1, 2);
        Assertions.assertEquals((int)4, (int)(this.metrics.metrics().size() - initialMetricsSize));
        this.metricsManager.recordBytesFetched(topicName2, 1);
        Assertions.assertEquals((int)12, (int)(this.metrics.metrics().size() - initialMetricsSize));
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordBytesFetched(topicName1, 10);
        this.metricsManager.recordBytesFetched(topicName2, 5);
        Assertions.assertEquals((int)12, (int)(this.metrics.metrics().size() - initialMetricsSize));
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeAvg, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)10.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeMax, tags1), (double)1.0E-4);
        Assertions.assertTrue((this.metricValue(this.metricsRegistry.topicBytesConsumedRate, tags1) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)12.0, (double)this.metricValue(this.metricsRegistry.topicBytesConsumedTotal, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeAvg, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)5.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeMax, tags2), (double)1.0E-4);
        Assertions.assertTrue((this.metricValue(this.metricsRegistry.topicBytesConsumedRate, tags2) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.topicBytesConsumedTotal, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeAvg, deprecatedTags), (double)1.0E-4);
        Assertions.assertEquals((double)5.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeMax, deprecatedTags), (double)1.0E-4);
        Assertions.assertTrue((this.metricValue(this.metricsRegistry.topicBytesConsumedRate, deprecatedTags) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.topicBytesConsumedTotal, deprecatedTags), (double)1.0E-4);
    }

    @Test
    public void testRecordsFetched() {
        this.metricsManager.recordRecordsFetched(3);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordRecordsFetched(15);
        Assertions.assertEquals((double)9.0, (double)this.metricValue(this.metricsRegistry.recordsPerRequestAvg), (double)1.0E-4);
    }

    @Test
    public void testRecordsFetchedTopic() {
        String topicName1 = TOPIC_NAME;
        String topicName2 = "another.topic";
        Map<String, String> tags1 = Map.of("topic", topicName1);
        Map<String, String> tags2 = Map.of("topic", topicName2);
        Map deprecatedTags = FetchMetricsManager.topicTags((String)topicName2);
        int initialMetricsSize = this.metrics.metrics().size();
        this.metricsManager.recordRecordsFetched(topicName1, 2);
        Assertions.assertEquals((int)3, (int)(this.metrics.metrics().size() - initialMetricsSize));
        this.metricsManager.recordRecordsFetched(topicName2, 1);
        Assertions.assertEquals((int)9, (int)(this.metrics.metrics().size() - initialMetricsSize));
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordRecordsFetched(topicName1, 10);
        this.metricsManager.recordRecordsFetched(topicName2, 5);
        Assertions.assertEquals((int)9, (int)(this.metrics.metrics().size() - initialMetricsSize));
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.topicRecordsPerRequestAvg, tags1), (double)1.0E-4);
        Assertions.assertTrue((this.metricValue(this.metricsRegistry.topicRecordsConsumedRate, tags1) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)12.0, (double)this.metricValue(this.metricsRegistry.topicRecordsConsumedTotal, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)this.metricValue(this.metricsRegistry.topicRecordsPerRequestAvg, tags2), (double)1.0E-4);
        Assertions.assertTrue((this.metricValue(this.metricsRegistry.topicRecordsConsumedRate, tags2) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.topicRecordsConsumedTotal, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)this.metricValue(this.metricsRegistry.topicRecordsPerRequestAvg, deprecatedTags), (double)1.0E-4);
        Assertions.assertTrue((this.metricValue(this.metricsRegistry.topicRecordsConsumedRate, deprecatedTags) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.topicRecordsConsumedTotal, deprecatedTags), (double)1.0E-4);
    }

    @Test
    public void testPartitionLag() {
        TopicPartition tp1 = new TopicPartition(TOPIC_NAME, 0);
        TopicPartition tp2 = new TopicPartition("another.topic", 0);
        Map<String, String> tags1 = Map.of("topic", tp1.topic(), "partition", String.valueOf(tp1.partition()));
        Map<String, String> tags2 = Map.of("topic", tp2.topic(), "partition", String.valueOf(tp2.partition()));
        Map deprecatedTags = FetchMetricsManager.topicPartitionTags((TopicPartition)tp2);
        int initialMetricsSize = this.metrics.metrics().size();
        this.metricsManager.recordPartitionLag(tp1, 14L);
        Assertions.assertEquals((int)3, (int)(this.metrics.metrics().size() - initialMetricsSize));
        this.metricsManager.recordPartitionLag(tp1, 8L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordPartitionLag(tp1, 5L);
        Assertions.assertEquals((int)3, (int)(this.metrics.metrics().size() - initialMetricsSize));
        Assertions.assertEquals((double)14.0, (double)this.metricValue(this.metricsRegistry.recordsLagMax), (double)1.0E-4);
        Assertions.assertEquals((double)5.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLag, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)14.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLagMax, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)9.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLagAvg, tags1), (double)1.0E-4);
        this.metricsManager.recordPartitionLag(tp2, 7L);
        Assertions.assertEquals((int)9, (int)(this.metrics.metrics().size() - initialMetricsSize));
        this.metricsManager.recordPartitionLag(tp2, 3L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordPartitionLag(tp2, 2L);
        Assertions.assertEquals((int)9, (int)(this.metrics.metrics().size() - initialMetricsSize));
        Assertions.assertEquals((double)7.0, (double)this.metricValue(this.metricsRegistry.recordsLagMax), (double)1.0E-4);
        Assertions.assertEquals((double)2.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLag, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)7.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLagMax, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)4.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLagAvg, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)2.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLag, deprecatedTags), (double)1.0E-4);
        Assertions.assertEquals((double)7.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLagMax, deprecatedTags), (double)1.0E-4);
        Assertions.assertEquals((double)4.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLagAvg, deprecatedTags), (double)1.0E-4);
    }

    @Test
    public void testPartitionLead() {
        TopicPartition tp1 = new TopicPartition(TOPIC_NAME, 0);
        TopicPartition tp2 = new TopicPartition("another.topic", 0);
        Map<String, String> tags1 = Map.of("topic", tp1.topic(), "partition", String.valueOf(tp1.partition()));
        Map<String, String> tags2 = Map.of("topic", tp2.topic(), "partition", String.valueOf(tp2.partition()));
        Map deprecatedTags = FetchMetricsManager.topicPartitionTags((TopicPartition)tp2);
        int initialMetricsSize = this.metrics.metrics().size();
        this.metricsManager.recordPartitionLead(tp1, 15L);
        Assertions.assertEquals((int)3, (int)(this.metrics.metrics().size() - initialMetricsSize));
        this.metricsManager.recordPartitionLead(tp1, 11L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordPartitionLead(tp1, 13L);
        Assertions.assertEquals((int)3, (int)(this.metrics.metrics().size() - initialMetricsSize));
        Assertions.assertEquals((double)11.0, (double)this.metricValue(this.metricsRegistry.recordsLeadMin), (double)1.0E-4);
        Assertions.assertEquals((double)13.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLead, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)11.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLeadMin, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)13.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLeadAvg, tags1), (double)1.0E-4);
        this.metricsManager.recordPartitionLead(tp2, 18L);
        Assertions.assertEquals((int)9, (int)(this.metrics.metrics().size() - initialMetricsSize));
        this.metricsManager.recordPartitionLead(tp2, 12L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordPartitionLead(tp2, 15L);
        Assertions.assertEquals((int)9, (int)(this.metrics.metrics().size() - initialMetricsSize));
        Assertions.assertEquals((double)12.0, (double)this.metricValue(this.metricsRegistry.recordsLeadMin), (double)1.0E-4);
        Assertions.assertEquals((double)15.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLead, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)12.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLeadMin, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)15.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLeadAvg, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)15.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLead, deprecatedTags), (double)1.0E-4);
        Assertions.assertEquals((double)12.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLeadMin, deprecatedTags), (double)1.0E-4);
        Assertions.assertEquals((double)15.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLeadAvg, deprecatedTags), (double)1.0E-4);
    }

    @Test
    public void testMaybeUpdateAssignment() {
        TopicPartition tp1 = new TopicPartition(TOPIC_NAME, 0);
        TopicPartition tp2 = new TopicPartition("another.topic", 0);
        TopicPartition tp3 = new TopicPartition("another.topic", 1);
        int initialMetricsSize = this.metrics.metrics().size();
        SubscriptionState subscriptionState = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        subscriptionState.assignFromUser(Set.of(tp1));
        this.metricsManager.maybeUpdateAssignment(subscriptionState);
        Assertions.assertEquals((int)1, (int)(this.metrics.metrics().size() - initialMetricsSize));
        subscriptionState.assignFromUser(Set.of(tp1, tp2));
        subscriptionState.updatePreferredReadReplica(tp2, 1, () -> 0L);
        this.metricsManager.maybeUpdateAssignment(subscriptionState);
        Assertions.assertEquals((int)3, (int)(this.metrics.metrics().size() - initialMetricsSize));
        Map<String, String> tags1 = Map.of("topic", tp1.topic(), "partition", String.valueOf(tp1.partition()));
        Map<String, String> tags2 = Map.of("topic", tp2.topic(), "partition", String.valueOf(tp2.partition()));
        Map deprecatedTags = FetchMetricsManager.topicPartitionTags((TopicPartition)tp2);
        Assertions.assertEquals((double)-1.0, (double)this.readReplicaMetricValue(this.metricsRegistry.partitionPreferredReadReplica, tags1).intValue(), (double)1.0E-4);
        Assertions.assertEquals((double)1.0, (double)this.readReplicaMetricValue(this.metricsRegistry.partitionPreferredReadReplica, tags2).intValue(), (double)1.0E-4);
        Assertions.assertEquals((double)1.0, (double)this.readReplicaMetricValue(this.metricsRegistry.partitionPreferredReadReplica, deprecatedTags).intValue(), (double)1.0E-4);
        subscriptionState.assignFromUser(Set.of(tp1, tp3));
        this.metricsManager.maybeUpdateAssignment(subscriptionState);
        Assertions.assertEquals((int)3, (int)(this.metrics.metrics().size() - initialMetricsSize));
        subscriptionState.assignFromUser(Set.of());
        this.metricsManager.maybeUpdateAssignment(subscriptionState);
        Assertions.assertEquals((int)initialMetricsSize, (int)this.metrics.metrics().size());
    }

    @Test
    public void testMaybeUpdateAssignmentWithAdditionalRegisteredMetrics() {
        TopicPartition tp1 = new TopicPartition(TOPIC_NAME, 0);
        TopicPartition tp2 = new TopicPartition("another.topic", 0);
        TopicPartition tp3 = new TopicPartition("another.topic", 1);
        int initialMetricsSize = this.metrics.metrics().size();
        this.metricsManager.recordPartitionLag(tp1, 14L);
        this.metricsManager.recordPartitionLead(tp1, 11L);
        this.metricsManager.recordPartitionLag(tp2, 5L);
        this.metricsManager.recordPartitionLead(tp2, 1L);
        this.metricsManager.recordPartitionLag(tp3, 4L);
        this.metricsManager.recordPartitionLead(tp3, 2L);
        int additionalRegisteredMetricsSize = this.metrics.metrics().size();
        SubscriptionState subscriptionState = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        subscriptionState.assignFromUser(Set.of(tp1, tp2, tp3));
        this.metricsManager.maybeUpdateAssignment(subscriptionState);
        Assertions.assertEquals((int)5, (int)(this.metrics.metrics().size() - additionalRegisteredMetricsSize));
        subscriptionState.assignFromUser(Set.of(tp1, tp2));
        this.metricsManager.maybeUpdateAssignment(subscriptionState);
        Assertions.assertEquals((int)9, (int)(additionalRegisteredMetricsSize - this.metrics.metrics().size()));
        subscriptionState.assignFromUser(Set.of());
        this.metricsManager.maybeUpdateAssignment(subscriptionState);
        Assertions.assertEquals((int)initialMetricsSize, (int)this.metrics.metrics().size());
    }

    private void registerNodeLatencyMetric(String connectionId, MetricName nodeLatencyAvg, MetricName nodeLatencyMax) {
        String nodeTimeName = "node-" + connectionId + ".latency";
        Sensor nodeRequestTime = this.metrics.sensor(nodeTimeName);
        nodeRequestTime.add(nodeLatencyAvg, (MeasurableStat)new Avg());
        nodeRequestTime.add(nodeLatencyMax, (MeasurableStat)new Max());
    }

    private double metricValue(MetricNameTemplate name) {
        MetricName metricName = this.metrics.metricInstance(name, new String[0]);
        return this.metricValue(metricName);
    }

    private double metricValue(MetricNameTemplate name, Map<String, String> tags) {
        MetricName metricName = this.metrics.metricInstance(name, tags);
        return this.metricValue(metricName);
    }

    private double metricValue(MetricName metricName) {
        KafkaMetric metric = this.metrics.metric(metricName);
        return (Double)metric.metricValue();
    }

    private Integer readReplicaMetricValue(MetricNameTemplate name, Map<String, String> tags) {
        MetricName metricName = this.metrics.metricInstance(name, tags);
        KafkaMetric metric = this.metrics.metric(metricName);
        return (Integer)metric.metricValue();
    }
}

