/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsRegistry;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ShareFetchMetricsManagerTest {
    private static final double EPSILON = 1.0E-4;
    private final Time time = new MockTime(1L, 0L, 0L);
    private ShareFetchMetricsManager shareFetchMetricsManager;
    private ShareFetchMetricsRegistry shareFetchMetricsRegistry;
    private Metrics metrics;

    ShareFetchMetricsManagerTest() {
    }

    @BeforeEach
    public void setup() {
        this.metrics = new Metrics(this.time);
        this.shareFetchMetricsRegistry = new ShareFetchMetricsRegistry("consumer-share");
        this.shareFetchMetricsManager = new ShareFetchMetricsManager(this.metrics, this.shareFetchMetricsRegistry);
    }

    @AfterEach
    public void tearDown() {
        if (this.metrics != null) {
            this.metrics.close();
            this.metrics = null;
        }
        this.shareFetchMetricsManager = null;
    }

    @Test
    public void testLatency() {
        this.shareFetchMetricsManager.recordLatency("", 101L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.shareFetchMetricsManager.recordLatency("", 155L);
        Assertions.assertEquals((double)155.0, (double)((Double)this.getMetric(this.shareFetchMetricsRegistry.fetchLatencyMax).metricValue()), (double)1.0E-4);
        Assertions.assertEquals((double)128.0, (double)((Double)this.getMetric(this.shareFetchMetricsRegistry.fetchLatencyAvg).metricValue()), (double)1.0E-4);
    }

    @Test
    public void testNodeLatency() {
        String connectionId = "0";
        MetricName nodeLatencyAvg = this.metrics.metricName("request-latency-avg", "group");
        MetricName nodeLatencyMax = this.metrics.metricName("request-latency-max", "group");
        this.registerNodeLatencyMetric(connectionId, nodeLatencyAvg, nodeLatencyMax);
        this.shareFetchMetricsManager.recordLatency(connectionId, 123L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.shareFetchMetricsManager.recordLatency(connectionId, 456L);
        Assertions.assertEquals((double)289.5, (double)this.metricValue(this.shareFetchMetricsRegistry.fetchLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)456.0, (double)this.metricValue(this.shareFetchMetricsRegistry.fetchLatencyMax), (double)1.0E-4);
        Assertions.assertEquals((double)289.5, (double)this.metricValue(nodeLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)456.0, (double)this.metricValue(nodeLatencyMax), (double)1.0E-4);
        this.shareFetchMetricsManager.recordLatency("1", 501L);
        Assertions.assertEquals((double)360.0, (double)this.metricValue(this.shareFetchMetricsRegistry.fetchLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)501.0, (double)this.metricValue(this.shareFetchMetricsRegistry.fetchLatencyMax), (double)1.0E-4);
        Assertions.assertEquals((double)289.5, (double)this.metricValue(nodeLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)456.0, (double)this.metricValue(nodeLatencyMax), (double)1.0E-4);
    }

    @Test
    public void testBytesFetched() {
        this.shareFetchMetricsManager.recordBytesFetched(2);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.shareFetchMetricsManager.recordBytesFetched(10);
        Assertions.assertEquals((double)10.0, (double)((Double)this.getMetric(this.shareFetchMetricsRegistry.fetchSizeMax).metricValue()));
        Assertions.assertEquals((double)6.0, (double)((Double)this.getMetric(this.shareFetchMetricsRegistry.fetchSizeAvg).metricValue()), (double)1.0E-4);
    }

    @Test
    public void testRecordsFetched() {
        this.shareFetchMetricsManager.recordRecordsFetched(7);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.shareFetchMetricsManager.recordRecordsFetched(9);
        Assertions.assertEquals((double)9.0, (double)((Double)this.getMetric(this.shareFetchMetricsRegistry.recordsPerRequestMax).metricValue()));
        Assertions.assertEquals((double)8.0, (double)((Double)this.getMetric(this.shareFetchMetricsRegistry.recordsPerRequestAvg).metricValue()), (double)1.0E-4);
    }

    private KafkaMetric getMetric(MetricNameTemplate name) {
        return this.metrics.metric(this.metrics.metricInstance(name, new String[0]));
    }

    private void registerNodeLatencyMetric(String connectionId, MetricName nodeLatencyAvg, MetricName nodeLatencyMax) {
        String nodeTimeName = "node-" + connectionId + ".latency";
        Sensor nodeRequestTime = this.metrics.sensor(nodeTimeName);
        nodeRequestTime.add(nodeLatencyAvg, (MeasurableStat)new Avg());
        nodeRequestTime.add(nodeLatencyMax, (MeasurableStat)new Max());
    }

    private double metricValue(MetricNameTemplate name) {
        MetricName metricName = this.metrics.metricInstance(name, new String[0]);
        return this.metricValue(metricName);
    }

    private double metricValue(MetricName metricName) {
        KafkaMetric metric = this.metrics.metric(metricName);
        return (Double)metric.metricValue();
    }
}

