/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.kafka.clients.consumer.internals.TopicIdPartitionSet;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TopicIdPartitionSetTest {
    private TopicIdPartitionSet topicIdPartitionSet;

    @BeforeEach
    public void setUp() {
        this.topicIdPartitionSet = new TopicIdPartitionSet();
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)this.topicIdPartitionSet.isEmpty());
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        this.topicIdPartitionSet.add(topicIdPartition);
        Assertions.assertFalse((boolean)this.topicIdPartitionSet.isEmpty());
    }

    @Test
    public void testRetrieveTopicPartitions() {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("foo", 1);
        TopicPartition tp3 = new TopicPartition("bar", 0);
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId1, tp1));
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId1, tp2));
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId2, tp3));
        SortedSet topicPartitionSet = this.topicIdPartitionSet.topicPartitions();
        Assertions.assertEquals((int)3, (int)topicPartitionSet.size());
        Assertions.assertTrue((boolean)topicPartitionSet.contains(tp1));
        Assertions.assertTrue((boolean)topicPartitionSet.contains(tp2));
        Assertions.assertTrue((boolean)topicPartitionSet.contains(tp3));
    }

    @Test
    public void testRetrieveTopicIds() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId1, new TopicPartition("foo", 0)));
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId1, new TopicPartition("foo", 1)));
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId2, new TopicPartition("bar", 0)));
        Set topicIds = this.topicIdPartitionSet.topicIds();
        Assertions.assertEquals((int)2, (int)topicIds.size());
        Assertions.assertTrue((boolean)topicIds.contains(topicId1));
        Assertions.assertTrue((boolean)topicIds.contains(topicId2));
    }

    @Test
    public void testRetrieveTopicNames() {
        String topic1 = "foo";
        String topic2 = "bar";
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId1, new TopicPartition(topic1, 0)));
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId1, new TopicPartition(topic1, 1)));
        this.topicIdPartitionSet.add(new TopicIdPartition(topicId2, new TopicPartition(topic2, 0)));
        SortedSet topicNames = this.topicIdPartitionSet.topicNames();
        Assertions.assertEquals((int)2, (int)topicNames.size());
        Assertions.assertTrue((boolean)topicNames.contains(topic1));
        Assertions.assertTrue((boolean)topicNames.contains(topic2));
    }

    @Test
    public void testRetrievedTopicNamesAreSorted() {
        LinkedHashSet<TopicIdPartition> expectedOrderedTopicPartitions = new LinkedHashSet<TopicIdPartition>();
        expectedOrderedTopicPartitions.add(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("topic-z", 1)));
        expectedOrderedTopicPartitions.add(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("topic-z", 0)));
        expectedOrderedTopicPartitions.add(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("topic-a", 0)));
        expectedOrderedTopicPartitions.add(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("topic-a", 1)));
        ArrayList reversed = new ArrayList(expectedOrderedTopicPartitions);
        Collections.reverse(reversed);
        reversed.forEach(tp -> this.topicIdPartitionSet.add(tp));
        ArrayList topicPartitions = new ArrayList(this.topicIdPartitionSet.toTopicNamePartitionSet());
        Assertions.assertEquals((int)4, (int)topicPartitions.size());
        Assertions.assertEquals((Object)new TopicPartition("topic-a", 0), topicPartitions.get(0));
        Assertions.assertEquals((Object)new TopicPartition("topic-a", 1), topicPartitions.get(1));
        Assertions.assertEquals((Object)new TopicPartition("topic-z", 0), topicPartitions.get(2));
        Assertions.assertEquals((Object)new TopicPartition("topic-z", 1), topicPartitions.get(3));
    }

    @Test
    public void testToString() {
        Uuid topicId1 = Uuid.randomUuid();
        TopicIdPartition tp1 = new TopicIdPartition(topicId1, new TopicPartition("topic-a", 0));
        TopicIdPartition tp2 = new TopicIdPartition(topicId1, new TopicPartition("topic-a", 1));
        TopicIdPartition tp3 = new TopicIdPartition(topicId1, new TopicPartition("topic-b", 0));
        this.topicIdPartitionSet.add(tp1);
        this.topicIdPartitionSet.add(tp2);
        this.topicIdPartitionSet.add(tp3);
        String toString = this.topicIdPartitionSet.toString();
        Assertions.assertEquals((Object)List.of(tp1, tp2, tp3).toString(), (Object)toString);
    }

    @Test
    public void testToStringSorted() {
        Uuid topicId1 = Uuid.randomUuid();
        TopicIdPartition tp1 = new TopicIdPartition(topicId1, new TopicPartition("topic-a", 0));
        TopicIdPartition tpz1 = new TopicIdPartition(topicId1, new TopicPartition("topic-z", 0));
        TopicIdPartition tpz2 = new TopicIdPartition(topicId1, new TopicPartition("topic-z", 1));
        this.topicIdPartitionSet.add(tpz2);
        this.topicIdPartitionSet.add(tpz1);
        this.topicIdPartitionSet.add(tp1);
        String toString = this.topicIdPartitionSet.toString();
        Assertions.assertEquals((Object)List.of(tp1, tpz1, tpz2).toString(), (Object)toString);
    }
}

