/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.TopicMetadataFetcher;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TopicMetadataFetcherTest {
    private final String topicName = "test";
    private final Uuid topicId = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = Map.of("test", this.topicId);
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final int validLeaderEpoch = 0;
    private final MetadataResponse initialUpdateResponse = RequestTestUtils.metadataUpdateWithIds(1, Collections.singletonMap("test", 4), this.topicIds);
    private MockTime time = new MockTime(1L);
    private SubscriptionState subscriptions;
    private ConsumerMetadata metadata;
    private MockClient client;
    private Metrics metrics;
    private ConsumerNetworkClient consumerClient;
    private TopicMetadataFetcher topicMetadataFetcher;

    @BeforeEach
    public void setup() {
    }

    private void assignFromUser(Set<TopicPartition> partitions) {
        this.subscriptions.assignFromUser(partitions);
        this.client.updateMetadata(this.initialUpdateResponse);
        this.metadata.updateWithCurrentRequestVersion(RequestTestUtils.metadataUpdateWithIds("dummy", 1, Collections.emptyMap(), Collections.singletonMap("test", 4), tp -> 0, this.topicIds), false, 0L);
    }

    @AfterEach
    public void teardown() throws Exception {
        if (this.metrics != null) {
            this.metrics.close();
        }
    }

    @Test
    public void testGetAllTopics() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.client.prepareResponse((AbstractResponse)this.newMetadataResponse(Errors.NONE));
        Map allTopics = this.topicMetadataFetcher.getAllTopicMetadata(this.time.timer(5000L));
        Assertions.assertEquals((int)this.initialUpdateResponse.topicMetadata().size(), (int)allTopics.size());
    }

    @Test
    public void testGetAllTopicsDisconnect() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.client.prepareResponse(null, true);
        this.client.prepareResponse((AbstractResponse)this.newMetadataResponse(Errors.NONE));
        Map allTopics = this.topicMetadataFetcher.getAllTopicMetadata(this.time.timer(5000L));
        Assertions.assertEquals((int)this.initialUpdateResponse.topicMetadata().size(), (int)allTopics.size());
    }

    @Test
    public void testGetAllTopicsTimeout() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        Assertions.assertThrows(TimeoutException.class, () -> this.topicMetadataFetcher.getAllTopicMetadata(this.time.timer(50L)));
    }

    @Test
    public void testGetAllTopicsUnauthorized() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.client.prepareResponse((AbstractResponse)this.newMetadataResponse(Errors.TOPIC_AUTHORIZATION_FAILED));
        try {
            this.topicMetadataFetcher.getAllTopicMetadata(this.time.timer(10L));
            Assertions.fail();
        }
        catch (TopicAuthorizationException e) {
            Assertions.assertEquals(Collections.singleton("test"), (Object)e.unauthorizedTopics());
        }
    }

    @Test
    public void testGetTopicMetadataInvalidTopic() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.client.prepareResponse((AbstractResponse)this.newMetadataResponse(Errors.INVALID_TOPIC_EXCEPTION));
        Assertions.assertThrows(InvalidTopicException.class, () -> this.topicMetadataFetcher.getTopicMetadata("test", true, this.time.timer(5000L)));
    }

    @Test
    public void testGetTopicMetadataUnknownTopic() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.client.prepareResponse((AbstractResponse)this.newMetadataResponse(Errors.UNKNOWN_TOPIC_OR_PARTITION));
        List topicMetadata = this.topicMetadataFetcher.getTopicMetadata("test", true, this.time.timer(5000L));
        Assertions.assertNull((Object)topicMetadata);
    }

    @Test
    public void testGetTopicMetadataLeaderNotAvailable() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        this.client.prepareResponse((AbstractResponse)this.newMetadataResponse(Errors.LEADER_NOT_AVAILABLE));
        this.client.prepareResponse((AbstractResponse)this.newMetadataResponse(Errors.NONE));
        List topicMetadata = this.topicMetadataFetcher.getTopicMetadata("test", true, this.time.timer(5000L));
        Assertions.assertNotNull((Object)topicMetadata);
    }

    @Test
    public void testGetTopicMetadataOfflinePartitions() {
        this.buildFetcher();
        this.assignFromUser(Collections.singleton(this.tp0));
        MetadataResponse originalResponse = this.newMetadataResponse(Errors.NONE);
        ArrayList<MetadataResponse.TopicMetadata> altTopics = new ArrayList<MetadataResponse.TopicMetadata>();
        for (MetadataResponse.TopicMetadata item : originalResponse.topicMetadata()) {
            List partitions = item.partitionMetadata();
            ArrayList<MetadataResponse.PartitionMetadata> altPartitions = new ArrayList<MetadataResponse.PartitionMetadata>();
            for (MetadataResponse.PartitionMetadata p : partitions) {
                altPartitions.add(new MetadataResponse.PartitionMetadata(p.error, p.topicPartition, Optional.empty(), Optional.empty(), p.replicaIds, p.inSyncReplicaIds, p.offlineReplicaIds));
            }
            MetadataResponse.TopicMetadata alteredTopic = new MetadataResponse.TopicMetadata(item.error(), item.topic(), item.isInternal(), altPartitions);
            altTopics.add(alteredTopic);
        }
        Node controller = originalResponse.controller();
        MetadataResponse altered = RequestTestUtils.metadataResponse(originalResponse.brokers(), originalResponse.clusterId(), controller != null ? controller.id() : -1, altTopics);
        this.client.prepareResponse((AbstractResponse)altered);
        List topicMetadata = this.topicMetadataFetcher.getTopicMetadata("test", false, this.time.timer(5000L));
        Assertions.assertNotNull((Object)topicMetadata);
        Assertions.assertFalse((boolean)topicMetadata.isEmpty());
        Assertions.assertEquals((long)this.metadata.fetch().partitionCountForTopic("test").longValue(), (long)topicMetadata.size());
    }

    private MetadataResponse newMetadataResponse(Errors error) {
        ArrayList partitionsMetadata = new ArrayList();
        if (error == Errors.NONE) {
            Optional<MetadataResponse.TopicMetadata> foundMetadata = this.initialUpdateResponse.topicMetadata().stream().filter(topicMetadata -> topicMetadata.topic().equals("test")).findFirst();
            foundMetadata.ifPresent(topicMetadata -> partitionsMetadata.addAll(topicMetadata.partitionMetadata()));
        }
        MetadataResponse.TopicMetadata topicMetadata2 = new MetadataResponse.TopicMetadata(error, "test", false, partitionsMetadata);
        ArrayList<Node> brokers = new ArrayList<Node>(this.initialUpdateResponse.brokers());
        return RequestTestUtils.metadataResponse(brokers, this.initialUpdateResponse.clusterId(), this.initialUpdateResponse.controller().id(), Collections.singletonList(topicMetadata2));
    }

    private void buildFetcher() {
        MetricConfig metricConfig = new MetricConfig();
        long metadataExpireMs = Long.MAX_VALUE;
        long retryBackoffMs = 100L;
        long retryBackoffMaxMs = 1000L;
        LogContext logContext = new LogContext();
        SubscriptionState subscriptionState = new SubscriptionState(logContext, AutoOffsetResetStrategy.EARLIEST);
        this.buildDependencies(metricConfig, metadataExpireMs, subscriptionState, logContext);
        this.topicMetadataFetcher = new TopicMetadataFetcher(logContext, this.consumerClient, retryBackoffMs, retryBackoffMaxMs);
    }

    private void buildDependencies(MetricConfig metricConfig, long metadataExpireMs, SubscriptionState subscriptionState, LogContext logContext) {
        this.time = new MockTime(1L);
        this.subscriptions = subscriptionState;
        this.metadata = new ConsumerMetadata(0L, 0L, metadataExpireMs, false, false, this.subscriptions, logContext, new ClusterResourceListeners());
        this.client = new MockClient((Time)this.time, (Metadata)this.metadata);
        this.metrics = new Metrics(metricConfig, (Time)this.time);
        this.consumerClient = new ConsumerNetworkClient(logContext, (KafkaClient)this.client, (Metadata)this.metadata, (Time)this.time, 100L, 1000, Integer.MAX_VALUE);
    }
}

