/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.kafka.common.internals.CompositeStrategy;
import org.apache.kafka.common.internals.LegacyStrategy;
import org.apache.kafka.common.internals.ModernStrategy;
import org.apache.kafka.common.internals.ReflectiveStrategy;
import org.apache.kafka.common.internals.SecurityManagerCompatibility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.JRE;

public class SecurityManagerCompatibilityTest {
    @EnabledForJreRange(max=JRE.JAVA_22)
    @Test
    public void testLegacyStrategyLoadable() throws ClassNotFoundException, NoSuchMethodException {
        new LegacyStrategy(ReflectiveStrategy.Loader.forName());
    }

    @EnabledForJreRange(min=JRE.JAVA_18)
    @Test
    public void testModernStrategyLoadable() throws ClassNotFoundException, NoSuchMethodException {
        new ModernStrategy(ReflectiveStrategy.Loader.forName());
    }

    @Test
    public void testCompositeStrategyLoadable() {
        new CompositeStrategy(ReflectiveStrategy.Loader.forName());
    }

    @Test
    public void testDefaultStrategyLoadable() {
        Assertions.assertNotNull((Object)SecurityManagerCompatibility.get());
    }

    @Test
    public void testDefaultStrategyDoPrivilegedReturn() {
        Object object = new Object();
        Object returned = SecurityManagerCompatibility.get().doPrivileged(() -> object);
        Assertions.assertSame((Object)object, (Object)returned);
    }

    @Test
    public void testDefaultStrategyDoPrivilegedThrow() {
        Assertions.assertThrows(RuntimeException.class, () -> SecurityManagerCompatibility.get().doPrivileged(() -> {
            throw new RuntimeException();
        }));
    }

    @Test
    public void testDefaultStrategyCurrentNull() {
        Subject current = SecurityManagerCompatibility.get().current();
        Assertions.assertNull((Object)current);
    }

    @Test
    public void testDefaultStrategyCallAsReturn() {
        Subject subject = new Subject();
        Object object = new Object();
        Object returned = SecurityManagerCompatibility.get().callAs(subject, () -> object);
        Assertions.assertSame((Object)object, (Object)returned);
    }

    @Test
    public void testDefaultStrategyCallAsCurrent() {
        Subject subject = new Subject();
        Subject returned = (Subject)SecurityManagerCompatibility.get().callAs(subject, () -> ((SecurityManagerCompatibility)SecurityManagerCompatibility.get()).current());
        Assertions.assertSame((Object)subject, (Object)returned);
    }

    @Test
    public void testLegacyStrategyThrowsWhenSecurityManagerRemoved() {
        ReflectiveStrategy.Loader loader = this.simulateSecurityManagerRemoval();
        Assertions.assertThrows(ClassNotFoundException.class, () -> new LegacyStrategy(loader));
    }

    @EnabledForJreRange(min=JRE.JAVA_18)
    @Test
    public void testModernStrategyLoadableWhenSecurityManagerRemoved() throws ClassNotFoundException, NoSuchMethodException {
        ReflectiveStrategy.Loader loader = this.simulateSecurityManagerRemoval();
        new ModernStrategy(loader);
    }

    @Test
    public void testCompositeStrategyLoadableWhenSecurityManagerRemoved() {
        ReflectiveStrategy.Loader loader = this.simulateSecurityManagerRemoval();
        new CompositeStrategy(loader);
    }

    @Test
    public void testLegacyStrategyCurrentThrowsWhenSecurityManagerUnsupported() throws ClassNotFoundException, NoSuchMethodException {
        ReflectiveStrategy.Loader loader = this.simulateMethodsThrowUnsupportedOperationExceptions();
        LegacyStrategy legacy = new LegacyStrategy(loader);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((SecurityManagerCompatibility)legacy).current());
    }

    @Test
    public void testLegacyStrategyCallAsThrowsWhenSecurityManagerUnsupported() throws ClassNotFoundException, NoSuchMethodException {
        ReflectiveStrategy.Loader loader = this.simulateMethodsThrowUnsupportedOperationExceptions();
        LegacyStrategy legacy = new LegacyStrategy(loader);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> SecurityManagerCompatibilityTest.lambda$testLegacyStrategyCallAsThrowsWhenSecurityManagerUnsupported$0((SecurityManagerCompatibility)legacy));
    }

    @Test
    public void testCompositeStrategyDoPrivilegedWhenSecurityManagerUnsupported() {
        ReflectiveStrategy.Loader loader = this.simulateMethodsThrowUnsupportedOperationExceptions();
        CompositeStrategy composite = new CompositeStrategy(loader);
        Object object = new Object();
        Object returned = composite.doPrivileged(() -> object);
        Assertions.assertSame((Object)object, (Object)returned);
    }

    @Test
    public void testCompositeStrategyCurrentWhenSecurityManagerUnsupported() {
        ReflectiveStrategy.Loader loader = this.simulateMethodsThrowUnsupportedOperationExceptions();
        CompositeStrategy composite = new CompositeStrategy(loader);
        Subject returned = composite.current();
        Assertions.assertNull((Object)returned);
    }

    @Test
    public void testCompositeStrategyCallAsWhenSecurityManagerUnsupported() {
        ReflectiveStrategy.Loader loader = this.simulateMethodsThrowUnsupportedOperationExceptions();
        CompositeStrategy composite = new CompositeStrategy(loader);
        Subject subject = new Subject();
        Subject returned = (Subject)composite.callAs(subject, () -> ((CompositeStrategy)composite).current());
        Assertions.assertSame((Object)subject, (Object)returned);
    }

    private ReflectiveStrategy.Loader simulateSecurityManagerRemoval() {
        return name -> {
            if (name.equals("java.security.AccessController")) {
                throw new ClassNotFoundException();
            }
            return ReflectiveStrategy.Loader.forName().loadClass(name);
        };
    }

    private ReflectiveStrategy.Loader simulateMethodsThrowUnsupportedOperationExceptions() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> UnsupportedOperations.doPrivileged(null));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> UnsupportedOperations.getSubject(null));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> UnsupportedOperations.doAs(null, null));
        Assertions.assertNull((Object)UnsupportedOperations.current());
        Assertions.assertNull((Object)UnsupportedOperations.callAs(null, () -> null));
        return name -> {
            switch (name) {
                case "java.security.AccessController": 
                case "javax.security.auth.Subject": {
                    return UnsupportedOperations.class;
                }
                case "java.security.AccessControlContext": {
                    return UnsupportedOperations.DummyContext.class;
                }
            }
            return ReflectiveStrategy.Loader.forName().loadClass(name);
        };
    }

    private static /* synthetic */ void lambda$testLegacyStrategyCallAsThrowsWhenSecurityManagerUnsupported$0(SecurityManagerCompatibility legacy) throws Throwable {
        legacy.callAs(null, () -> null);
    }

    public static class UnsupportedOperations {
        private static final ThreadLocal<Subject> ACTIVE_SUBJECT = new ThreadLocal();

        public static <T> void doPrivileged(PrivilegedAction<T> ignored) {
            throw new UnsupportedOperationException();
        }

        public static DummyContext getContext() {
            throw new UnsupportedOperationException();
        }

        public static void getSubject(DummyContext ignored) {
            throw new UnsupportedOperationException();
        }

        public static <T> void doAs(Subject ignored1, PrivilegedExceptionAction<T> ignored2) {
            throw new UnsupportedOperationException();
        }

        public static Subject current() {
            return ACTIVE_SUBJECT.get();
        }

        public static <T> T callAs(Subject subject, Callable<T> action) throws CompletionException {
            Subject previous = ACTIVE_SUBJECT.get();
            ACTIVE_SUBJECT.set(subject);
            try {
                T t = action.call();
                return t;
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
            finally {
                ACTIVE_SUBJECT.set(previous);
            }
        }

        public static class DummyContext {
        }
    }
}

